/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.recordcount;

import com.google.common.base.Preconditions;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.gobblin.util.RecordCountProvider;
import org.apache.gobblin.util.recordcount.IngestionRecordCountProvider;
import org.apache.hadoop.fs.Path;

public class CompactionRecordCountProvider
extends RecordCountProvider {
    public static final String MR_OUTPUT_FILE_PREFIX = "part-r-";
    public static final String M_OUTPUT_FILE_PREFIX = "part-m-";
    private static final String SEPARATOR = ".";
    private static final String SUFFIX = ".avro";
    private static final Random RANDOM = new Random();

    public static String constructFileName(String filenamePrefix, long recordCount) {
        return CompactionRecordCountProvider.constructFileName(filenamePrefix, SUFFIX, recordCount);
    }

    public static String constructFileName(String filenamePrefix, String extension, long recordCount) {
        Preconditions.checkArgument((filenamePrefix.equals(M_OUTPUT_FILE_PREFIX) || filenamePrefix.equals(MR_OUTPUT_FILE_PREFIX) ? 1 : 0) != 0, (Object)String.format("%s is not a supported prefix, which should be %s, or %s.", filenamePrefix, M_OUTPUT_FILE_PREFIX, MR_OUTPUT_FILE_PREFIX));
        StringBuilder sb = new StringBuilder();
        sb.append(filenamePrefix);
        sb.append(Long.toString(recordCount));
        sb.append(SEPARATOR);
        sb.append(Long.toString(System.currentTimeMillis()));
        sb.append(SEPARATOR);
        sb.append(Integer.toString(RANDOM.nextInt(Integer.MAX_VALUE)));
        sb.append(extension);
        return sb.toString();
    }

    public long getRecordCount(Path filepath) {
        String filename = filepath.getName();
        Preconditions.checkArgument((filename.startsWith(M_OUTPUT_FILE_PREFIX) || filename.startsWith(MR_OUTPUT_FILE_PREFIX) ? 1 : 0) != 0, (Object)String.format("%s is not a supported filename, which should start with %s, or %s.", filename, M_OUTPUT_FILE_PREFIX, MR_OUTPUT_FILE_PREFIX));
        String prefixWithCounts = filename.split(Pattern.quote(SEPARATOR))[0];
        if (filename.startsWith(M_OUTPUT_FILE_PREFIX)) {
            return Long.parseLong(prefixWithCounts.substring(M_OUTPUT_FILE_PREFIX.length()));
        }
        return Long.parseLong(prefixWithCounts.substring(MR_OUTPUT_FILE_PREFIX.length()));
    }

    public Path convertPath(Path path, String extension, RecordCountProvider src) {
        if (((Object)((Object)this)).getClass().equals(src.getClass())) {
            return path;
        }
        if (src.getClass().equals(IngestionRecordCountProvider.class)) {
            String newFileName = CompactionRecordCountProvider.constructFileName(M_OUTPUT_FILE_PREFIX, extension, src.getRecordCount(path));
            return new Path(path.getParent(), newFileName);
        }
        throw this.getNotImplementedException(src);
    }
}

