/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.request_allocation;

import com.google.common.base.Function;
import java.util.Iterator;
import java.util.Random;
import org.apache.gobblin.util.request_allocation.AllocatedRequestsIterator;
import org.apache.gobblin.util.request_allocation.Request;
import org.apache.gobblin.util.request_allocation.ResourcePool;
import org.apache.gobblin.util.request_allocation.ResourceRequirement;
import org.apache.gobblin.util.request_allocation.VectorAlgebra;

public class AllocatedRequestsIteratorBase<T extends Request<T>>
implements AllocatedRequestsIterator<T> {
    private final Iterator<RequestWithResourceRequirement<T>> underlying;
    private final double[] currentRequirement;

    public AllocatedRequestsIteratorBase(Iterator<RequestWithResourceRequirement<T>> underlying, ResourcePool resourcePool) {
        this.underlying = underlying;
        this.currentRequirement = new double[resourcePool.getNumDimensions()];
    }

    @Override
    public ResourceRequirement totalResourcesUsed() {
        return new ResourceRequirement(this.currentRequirement);
    }

    @Override
    public boolean hasNext() {
        return this.underlying.hasNext();
    }

    @Override
    public T next() {
        RequestWithResourceRequirement<T> nextElement = this.underlying.next();
        VectorAlgebra.addVector(this.currentRequirement, nextElement.getResourceRequirement().getResourceVector(), 1.0, this.currentRequirement);
        return (T)((Request)nextElement.getT());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class TExtractor<T>
    implements Function<RequestWithResourceRequirement<T>, T> {
        public T apply(RequestWithResourceRequirement<T> ttAndRequirement) {
            return ttAndRequirement.getT();
        }
    }

    public static class RequestWithResourceRequirement<T> {
        public static final Random RANDOM = new Random();
        private final T t;
        private final ResourceRequirement resourceRequirement;
        private final long id;

        RequestWithResourceRequirement(T t, ResourceRequirement resourceRequirement) {
            this.t = t;
            this.resourceRequirement = resourceRequirement;
            this.id = RANDOM.nextLong();
        }

        public T getT() {
            return this.t;
        }

        public ResourceRequirement getResourceRequirement() {
            return this.resourceRequirement;
        }

        public long getId() {
            return this.id;
        }
    }
}

