/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.request_allocation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.gobblin.util.request_allocation.AllocatedRequestsIteratorBase;
import org.apache.gobblin.util.request_allocation.RequestAllocatorConfig;
import org.apache.gobblin.util.request_allocation.ResourceEstimator;
import org.apache.gobblin.util.request_allocation.ResourcePool;
import org.apache.gobblin.util.request_allocation.ResourceRequirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentBoundedPriorityIterable<T>
implements Iterable<AllocatedRequestsIteratorBase.RequestWithResourceRequirement<T>> {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentBoundedPriorityIterable.class);
    private final TreeSet<AllocatedRequestsIteratorBase.RequestWithResourceRequirement<T>> elements;
    private final int dimensions;
    private final Comparator<? super T> comparator;
    private final Comparator<AllocatedRequestsIteratorBase.RequestWithResourceRequirement<T>> allDifferentComparator;
    private final ResourceEstimator<T> estimator;
    private final ResourcePool resourcePool;
    private final ResourceRequirement currentRequirement;
    private volatile boolean rejectedElement = false;
    private volatile boolean closed = false;
    private final ResourceRequirement maxResourceRequirement;
    private int requestsOffered = 0;
    private int requestsRefused = 0;
    private int requestsEvicted = 0;
    private String storeRejectedRequestsSetting;
    private List<T> requestsExceedingAvailableResourcePool = Lists.newArrayList();
    private List<T> requestsRejectedWithLowPriority = Lists.newArrayList();
    private List<T> requestsRejectedDueToInsufficientEviction = Lists.newArrayList();
    private List<T> requestsDropped = Lists.newArrayList();
    private final ResourceRequirement candidateRequirement;
    private final ResourceRequirement tmpRequirement;
    private final ResourceRequirement reuse;

    public ConcurrentBoundedPriorityIterable(Comparator<? super T> prioritizer, ResourceEstimator<T> resourceEstimator, String storeRejectedRequestsSetting, ResourcePool pool) {
        this.estimator = resourceEstimator;
        this.resourcePool = pool;
        this.dimensions = this.resourcePool.getNumDimensions();
        this.comparator = prioritizer;
        this.allDifferentComparator = new AllDifferentComparator();
        this.elements = new TreeSet<AllocatedRequestsIteratorBase.RequestWithResourceRequirement<T>>(this.allDifferentComparator);
        this.storeRejectedRequestsSetting = storeRejectedRequestsSetting;
        this.currentRequirement = this.resourcePool.getResourceRequirementBuilder().zero().build();
        this.maxResourceRequirement = new ResourceRequirement(this.currentRequirement);
        this.candidateRequirement = new ResourceRequirement(this.currentRequirement);
        this.tmpRequirement = new ResourceRequirement(this.currentRequirement);
        this.reuse = new ResourceRequirement(this.currentRequirement);
    }

    public boolean add(T t) {
        if (this.closed) {
            throw new RuntimeException(ConcurrentBoundedPriorityIterable.class.getSimpleName() + " is no longer accepting requests!");
        }
        AllocatedRequestsIteratorBase.RequestWithResourceRequirement<T> newElement = new AllocatedRequestsIteratorBase.RequestWithResourceRequirement<T>(t, this.estimator.estimateRequirement(t, this.resourcePool));
        boolean addedWorkunits = this.addImpl(newElement);
        if (!addedWorkunits) {
            this.rejectedElement = true;
        }
        return addedWorkunits;
    }

    private synchronized boolean addImpl(AllocatedRequestsIteratorBase.RequestWithResourceRequirement<T> newElement) {
        this.maxResourceRequirement.entryWiseMax(newElement.getResourceRequirement());
        ++this.requestsOffered;
        if (this.resourcePool.exceedsHardBound(newElement.getResourceRequirement(), false)) {
            log.warn(String.format("Request %s is larger than the available resource pool. If the pool is not expanded, it will never be selected. Request: %s.", newElement.getT(), this.resourcePool.stringifyRequirement(newElement.getResourceRequirement())));
            if (!this.storeRejectedRequestsSetting.equalsIgnoreCase(RequestAllocatorConfig.StoreRejectedRequestsConfig.NONE.name())) {
                this.requestsExceedingAvailableResourcePool.add(newElement.getT());
            }
            ++this.requestsRefused;
            return false;
        }
        ResourceRequirement candidateRequirement = ResourceRequirement.add(this.currentRequirement, newElement.getResourceRequirement(), this.candidateRequirement);
        if (this.resourcePool.exceedsHardBound(candidateRequirement, false)) {
            if (this.comparator.compare(this.elements.last().getT(), newElement.getT()) <= 0) {
                log.debug("Request {} does not fit in resource pool and is lower priority than current lowest priority request. Rejecting", newElement.getT());
                ++this.requestsRefused;
                if (this.storeRejectedRequestsSetting.equalsIgnoreCase(RequestAllocatorConfig.StoreRejectedRequestsConfig.ALL.name())) {
                    this.requestsRejectedWithLowPriority.add(newElement.getT());
                }
                return false;
            }
            ArrayList toDrop = Lists.newArrayList();
            this.currentRequirement.copyInto(this.tmpRequirement);
            for (AllocatedRequestsIteratorBase.RequestWithResourceRequirement<T> dropCandidate : this.elements.descendingSet()) {
                if (this.comparator.compare(dropCandidate.getT(), newElement.getT()) <= 0) {
                    log.debug("Cannot evict enough requests to fit request {}. Rejecting", newElement.getT());
                    ++this.requestsRefused;
                    if (this.storeRejectedRequestsSetting.equalsIgnoreCase(RequestAllocatorConfig.StoreRejectedRequestsConfig.ALL.name())) {
                        this.requestsRejectedDueToInsufficientEviction.add(newElement.getT());
                    }
                    return false;
                }
                this.tmpRequirement.subtract(dropCandidate.getResourceRequirement());
                toDrop.add(dropCandidate);
                if (this.resourcePool.exceedsHardBound(ResourceRequirement.add(this.tmpRequirement, newElement.getResourceRequirement(), this.reuse), false)) continue;
                break;
            }
            for (AllocatedRequestsIteratorBase.RequestWithResourceRequirement<Object> drop : toDrop) {
                log.debug("Evicting request {}.", drop.getT());
                ++this.requestsEvicted;
                if (this.storeRejectedRequestsSetting.equalsIgnoreCase(RequestAllocatorConfig.StoreRejectedRequestsConfig.ALL.name())) {
                    this.requestsDropped.add(drop.getT());
                }
                this.elements.remove(drop);
                this.currentRequirement.subtract(drop.getResourceRequirement());
            }
        }
        this.elements.add(newElement);
        this.currentRequirement.add(newElement.getResourceRequirement());
        return true;
    }

    public boolean hasRejectedElement() {
        return this.rejectedElement;
    }

    public synchronized boolean isFull() {
        return this.resourcePool.exceedsSoftBound(this.currentRequirement, true);
    }

    public synchronized void logStatistics(Optional<Logger> logger) {
        Logger actualLogger = (Logger)logger.or((Object)log);
        StringBuilder messageBuilder = new StringBuilder("Statistics for ").append(ConcurrentBoundedPriorityIterable.class.getSimpleName()).append(": {");
        messageBuilder.append(this.resourcePool).append(", ");
        messageBuilder.append("totalResourcesUsed: ").append(this.resourcePool.stringifyRequirement(this.currentRequirement)).append(", ");
        messageBuilder.append("maxRequirementPerDimension: ").append(this.resourcePool.stringifyRequirement(this.maxResourceRequirement)).append(", ");
        messageBuilder.append("requestsOffered: ").append(this.requestsOffered).append(", ");
        messageBuilder.append("requestsAccepted: ").append(this.requestsOffered - this.requestsEvicted - this.requestsRefused).append(", ");
        messageBuilder.append("requestsRefused: ").append(this.requestsRefused).append(", ");
        messageBuilder.append("requestsEvicted: ").append(this.requestsEvicted);
        messageBuilder.append("}");
        actualLogger.info(messageBuilder.toString());
    }

    @VisibleForTesting
    void reopen() {
        this.closed = false;
    }

    @Override
    public Iterator<AllocatedRequestsIteratorBase.RequestWithResourceRequirement<T>> iterator() {
        this.closed = true;
        return this.elements.iterator();
    }

    public Comparator<? super T> getComparator() {
        return this.comparator;
    }

    public List<T> getRequestsExceedingAvailableResourcePool() {
        return this.requestsExceedingAvailableResourcePool;
    }

    public List<T> getRequestsRejectedWithLowPriority() {
        return this.requestsRejectedWithLowPriority;
    }

    public List<T> getRequestsRejectedDueToInsufficientEviction() {
        return this.requestsRejectedDueToInsufficientEviction;
    }

    public List<T> getRequestsDropped() {
        return this.requestsDropped;
    }

    private class AllDifferentComparator
    implements Comparator<AllocatedRequestsIteratorBase.RequestWithResourceRequirement<T>> {
        private AllDifferentComparator() {
        }

        @Override
        public int compare(AllocatedRequestsIteratorBase.RequestWithResourceRequirement<T> t1, AllocatedRequestsIteratorBase.RequestWithResourceRequirement<T> t2) {
            int providedComparison = ConcurrentBoundedPriorityIterable.this.comparator.compare(t1.getT(), t2.getT());
            if (providedComparison != 0) {
                return providedComparison;
            }
            return Long.compare(t1.getId(), t2.getId());
        }
    }
}

