/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.test;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.Source;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.source.workunit.Extract;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.apache.gobblin.util.ConfigUtils;

public class HelloWorldSource
implements Source<String, String> {
    public static final String CONFIG_NAMESPACE = "gobblin.source.helloWorld";
    public static final String NUM_HELLOS_KEY = "numHellos";
    public static final String NUM_HELLOS_FULL_KEY = "gobblin.source.helloWorld.numHellos";
    public static final int DEFAULT_NUM_HELLOS = 1;
    public static final String HELLO_ID_KEY = "helloId";
    public static final String HELLO_ID_FULL_KEY = "gobblin.source.helloWorld.helloId";

    public List<WorkUnit> getWorkunits(SourceState state) {
        Config rootCfg = ConfigUtils.propertiesToConfig(state.getProperties());
        Config cfg = rootCfg.hasPath(CONFIG_NAMESPACE) ? rootCfg.getConfig(CONFIG_NAMESPACE) : ConfigFactory.empty();
        int numHellos = cfg.hasPath(NUM_HELLOS_KEY) ? cfg.getInt(NUM_HELLOS_KEY) : 1;
        Extract extract = new Extract(Extract.TableType.APPEND_ONLY, HelloWorldSource.class.getPackage().getName(), HelloWorldSource.class.getSimpleName());
        ArrayList<WorkUnit> wus = new ArrayList<WorkUnit>(numHellos);
        for (int i = 1; i <= numHellos; ++i) {
            WorkUnit wu = new WorkUnit(extract);
            wu.setProp(HELLO_ID_FULL_KEY, (Object)i);
            wus.add(wu);
        }
        return wus;
    }

    public Extractor<String, String> getExtractor(WorkUnitState state) {
        int helloId = state.getPropAsInt(HELLO_ID_FULL_KEY);
        return new ExtractorImpl(helloId);
    }

    public void shutdown(SourceState state) {
    }

    public static class ExtractorImpl
    implements Extractor<String, String> {
        private final int _helloId;
        private int _recordsEmitted = 0;

        public ExtractorImpl(int helloId) {
            this._helloId = helloId;
        }

        public void close() throws IOException {
        }

        public String getSchema() throws IOException {
            return "string";
        }

        public String readRecord(String reuse) {
            if (this._recordsEmitted > 0) {
                return null;
            }
            ++this._recordsEmitted;
            return ExtractorImpl.helloMessage(this._helloId);
        }

        public static String helloMessage(int helloId) {
            return "Hello world " + helloId + " !";
        }

        public long getExpectedRecordCount() {
            return 1L;
        }

        public long getHighWatermark() {
            return 0L;
        }
    }
}

