/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cluster;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Service;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValueFactory;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.cluster.GobblinClusterUtils;
import org.apache.gobblin.cluster.GobblinHelixJobScheduler;
import org.apache.gobblin.cluster.GobblinHelixMessagingService;
import org.apache.gobblin.cluster.HelixMessageSubTypes;
import org.apache.gobblin.cluster.HelixUtils;
import org.apache.gobblin.cluster.JobConfigurationManager;
import org.apache.gobblin.cluster.NoopReplyHandler;
import org.apache.gobblin.cluster.event.ClusterManagerShutdownRequest;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.instrumented.StandardMetricsBridge;
import org.apache.gobblin.metrics.ContextAwareHistogram;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.runtime.api.MutableJobCatalog;
import org.apache.gobblin.runtime.app.ApplicationException;
import org.apache.gobblin.runtime.app.ApplicationLauncher;
import org.apache.gobblin.runtime.app.ServiceBasedAppLauncher;
import org.apache.gobblin.scheduler.SchedulerService;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.JvmUtils;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.helix.ControllerChangeListener;
import org.apache.helix.Criteria;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixManagerFactory;
import org.apache.helix.HelixProperty;
import org.apache.helix.InstanceType;
import org.apache.helix.LiveInstanceChangeListener;
import org.apache.helix.NotificationContext;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.messaging.handling.MessageHandlerFactory;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.task.TargetState;
import org.apache.helix.task.TaskDriver;
import org.apache.helix.task.WorkflowConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class GobblinClusterManager
implements ApplicationLauncher,
StandardMetricsBridge {
    private static final Logger LOGGER = LoggerFactory.getLogger(GobblinClusterManager.class);
    private HelixManager helixManager;
    private volatile boolean stopInProgress = false;
    protected ServiceBasedAppLauncher applicationLauncher;
    protected final EventBus eventBus = new EventBus(GobblinClusterManager.class.getSimpleName());
    protected final Path appWorkDir;
    protected final FileSystem fs;
    protected final String applicationId;
    private Thread idleProcessThread;
    private volatile boolean stopIdleProcessThread = false;
    private boolean isLeader = false;
    private final boolean isStandaloneMode;
    private MutableJobCatalog jobCatalog;
    private GobblinHelixJobScheduler jobScheduler;
    private JobConfigurationManager jobConfigurationManager;
    private final String clusterName;
    private final Config config;
    private final MetricContext metricContext;
    private final Metrics metrics;

    public GobblinClusterManager(String clusterName, String applicationId, Config config, Optional<Path> appWorkDirOptional) throws Exception {
        this.clusterName = clusterName;
        this.config = config;
        this.metricContext = Instrumented.getMetricContext((State)ConfigUtils.configToState((Config)config), this.getClass());
        this.metrics = new Metrics(this.metricContext, this.config);
        this.isStandaloneMode = ConfigUtils.getBoolean((Config)config, (String)"gobblin.cluster.standaloneMode", (boolean)false);
        this.applicationId = applicationId;
        this.initializeHelixManager();
        this.fs = this.buildFileSystem(config);
        this.appWorkDir = appWorkDirOptional.isPresent() ? (Path)appWorkDirOptional.get() : GobblinClusterUtils.getAppWorkDirPathFromConfig(config, this.fs, clusterName, applicationId);
        this.initializeAppLauncherAndServices();
    }

    private void initializeAppLauncherAndServices() throws Exception {
        Properties properties = ConfigUtils.configToProperties((Config)this.config);
        if (!properties.contains("app.stop.time.seconds")) {
            properties.setProperty("app.stop.time.seconds", Long.toString(300L));
        }
        this.applicationLauncher = new ServiceBasedAppLauncher(properties, this.clusterName);
        if (this.config.hasPath("gobblin.cluster.jobconf.fullyQualifiedPath")) {
            String jobCatalogClassName = ConfigUtils.getString((Config)this.config, (String)"gobblin.cluster.job.catalog", (String)"org.apache.gobblin.runtime.job_catalog.NonObservingFSJobCatalog");
            this.jobCatalog = (MutableJobCatalog)GobblinConstructorUtils.invokeFirstConstructor(Class.forName(jobCatalogClassName), (List[])new List[]{ImmutableList.of((Object)this.config.getConfig(StringUtils.removeEnd((String)"gobblin.cluster.", (String)".")).withFallback((ConfigMergeable)this.config))});
        } else {
            this.jobCatalog = null;
        }
        SchedulerService schedulerService = new SchedulerService(properties);
        this.applicationLauncher.addService((Service)schedulerService);
        this.jobScheduler = this.buildGobblinHelixJobScheduler(this.config, this.appWorkDir, this.getMetadataTags(this.clusterName, this.applicationId), schedulerService);
        this.applicationLauncher.addService((Service)this.jobScheduler);
        this.jobConfigurationManager = this.buildJobConfigurationManager(this.config);
        this.applicationLauncher.addService((Service)this.jobConfigurationManager);
    }

    private void startAppLauncherAndServices() {
        if (this.jobCatalog instanceof Service) {
            ((Service)this.jobCatalog).startAsync().awaitRunning();
        }
        this.applicationLauncher.start();
    }

    private void stopAppLauncherAndServices() {
        try {
            this.applicationLauncher.stop();
        }
        catch (ApplicationException ae) {
            LOGGER.error("Error while stopping Gobblin Cluster application launcher", (Throwable)ae);
        }
        if (this.jobCatalog instanceof Service) {
            ((Service)this.jobCatalog).stopAsync().awaitTerminated();
        }
    }

    @VisibleForTesting
    void handleLeadershipChange(NotificationContext changeContext) {
        this.metrics.clusterLeadershipChange.update(1);
        if (this.helixManager.isLeader()) {
            LOGGER.info("Leader notification for {} isLeader {} HM.isLeader {}", new Object[]{this.helixManager.getInstanceName(), this.isLeader, this.helixManager.isLeader()});
            if (!this.isLeader) {
                LOGGER.info("New Helix Controller leader {}", (Object)this.helixManager.getInstanceName());
                TaskDriver taskDriver = new TaskDriver(this.helixManager);
                Map workflows = taskDriver.getWorkflows();
                for (Map.Entry entry : workflows.entrySet()) {
                    String queueName = (String)entry.getKey();
                    WorkflowConfig workflowConfig = (WorkflowConfig)entry.getValue();
                    if (workflowConfig.getTargetState() == TargetState.DELETE) continue;
                    taskDriver.delete(queueName);
                    LOGGER.info("Requested delete of queue {}", (Object)queueName);
                }
                this.startAppLauncherAndServices();
                this.isLeader = true;
            }
        } else if (this.isLeader) {
            this.isLeader = false;
            this.stopAppLauncherAndServices();
            try {
                this.initializeAppLauncherAndServices();
            }
            catch (Exception e) {
                throw new RuntimeException("Exception reinitializing app launcher services ", e);
            }
        }
    }

    public synchronized void start() {
        LOGGER.info("Starting the Gobblin Cluster Manager");
        this.eventBus.register((Object)this);
        this.connectHelixManager();
        if (this.isStandaloneMode) {
            this.idleProcessThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!GobblinClusterManager.this.stopInProgress && !GobblinClusterManager.this.stopIdleProcessThread) {
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                    }
                }
            });
            this.idleProcessThread.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    GobblinClusterManager.this.stopIdleProcessThread = true;
                }
            });
        } else {
            this.startAppLauncherAndServices();
        }
    }

    public synchronized void stop() {
        if (this.stopInProgress) {
            return;
        }
        this.stopInProgress = true;
        LOGGER.info("Stopping the Gobblin Cluster Manager");
        if (this.idleProcessThread != null) {
            try {
                this.idleProcessThread.join();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        if (!this.isStandaloneMode) {
            this.sendShutdownRequest();
        }
        this.stopAppLauncherAndServices();
        this.disconnectHelixManager();
    }

    private List<? extends Tag<?>> getMetadataTags(String applicationName, String applicationId) {
        return Tag.fromMap((Map)new ImmutableMap.Builder().put((Object)"application.name", (Object)applicationName).put((Object)"application.id", (Object)applicationId).build());
    }

    private HelixManager buildHelixManager(Config config, String zkConnectionString) {
        String helixInstanceName = ConfigUtils.getString((Config)config, (String)"gobblin.cluster.helixInstanceName", (String)GobblinClusterManager.class.getSimpleName());
        return HelixManagerFactory.getZKHelixManager((String)config.getString("gobblin.cluster.helix.cluster.name"), (String)helixInstanceName, (InstanceType)InstanceType.CONTROLLER, (String)zkConnectionString);
    }

    private FileSystem buildFileSystem(Config config) throws IOException {
        return config.hasPath("fs.uri") ? FileSystem.get((URI)URI.create(config.getString("fs.uri")), (Configuration)new Configuration()) : FileSystem.get((Configuration)new Configuration());
    }

    private GobblinHelixJobScheduler buildGobblinHelixJobScheduler(Config config, Path appWorkDir, List<? extends Tag<?>> metadataTags, SchedulerService schedulerService) throws Exception {
        Properties properties = ConfigUtils.configToProperties((Config)config);
        return new GobblinHelixJobScheduler(properties, this.helixManager, this.eventBus, appWorkDir, metadataTags, schedulerService, this.jobCatalog);
    }

    private JobConfigurationManager buildJobConfigurationManager(Config config) {
        return this.create(config);
    }

    private JobConfigurationManager create(Config config) {
        try {
            if (config.hasPath("gobblin.cluster.job.configuration.manager")) {
                return (JobConfigurationManager)((Object)GobblinConstructorUtils.invokeFirstConstructor(Class.forName(config.getString("gobblin.cluster.job.configuration.manager")), (List[])new List[]{ImmutableList.of((Object)this.eventBus, (Object)config, (Object)this.jobCatalog), ImmutableList.of((Object)this.eventBus, (Object)config)}));
            }
            return new JobConfigurationManager(this.eventBus, config);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Subscribe
    public void handleApplicationMasterShutdownRequest(ClusterManagerShutdownRequest shutdownRequest) {
        this.stop();
    }

    @VisibleForTesting
    EventBus getEventBus() {
        return this.eventBus;
    }

    @VisibleForTesting
    void connectHelixManager() {
        try {
            this.isLeader = false;
            this.helixManager.connect();
            this.helixManager.addLiveInstanceChangeListener((LiveInstanceChangeListener)new GobblinLiveInstanceChangeListener());
            this.helixManager.getMessagingService().registerMessageHandlerFactory("SHUTDOWN", (MessageHandlerFactory)new ControllerShutdownMessageHandlerFactory());
            this.helixManager.getMessagingService().registerMessageHandlerFactory(Message.MessageType.USER_DEFINE_MSG.toString(), this.getUserDefinedMessageHandlerFactory());
            if (this.isStandaloneMode) {
                this.helixManager.addControllerListener(new ControllerChangeListener(){

                    public void onControllerChange(NotificationContext changeContext) {
                        GobblinClusterManager.this.handleLeadershipChange(changeContext);
                    }
                });
            }
        }
        catch (Exception e) {
            LOGGER.error("HelixManager failed to connect", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected MessageHandlerFactory getUserDefinedMessageHandlerFactory() {
        return new ControllerUserDefinedMessageHandlerFactory();
    }

    @VisibleForTesting
    void disconnectHelixManager() {
        if (this.isHelixManagerConnected()) {
            this.helixManager.disconnect();
        }
    }

    @VisibleForTesting
    boolean isHelixManagerConnected() {
        return this.helixManager.isConnected();
    }

    @VisibleForTesting
    void initializeHelixManager() {
        String zkConnectionString = this.config.getString("gobblin.cluster.zk.connection.string");
        LOGGER.info("Using ZooKeeper connection string: " + zkConnectionString);
        this.helixManager = this.buildHelixManager(this.config, zkConnectionString);
    }

    @VisibleForTesting
    void sendShutdownRequest() {
        Criteria criteria = new Criteria();
        criteria.setInstanceName("%");
        criteria.setResource("%");
        criteria.setPartition("%");
        criteria.setPartitionState("%");
        criteria.setRecipientInstanceType(InstanceType.PARTICIPANT);
        criteria.setSessionSpecific(true);
        Message shutdownRequest = new Message("SHUTDOWN", HelixMessageSubTypes.WORK_UNIT_RUNNER_SHUTDOWN.toString().toLowerCase() + UUID.randomUUID().toString());
        shutdownRequest.setMsgSubType(HelixMessageSubTypes.WORK_UNIT_RUNNER_SHUTDOWN.toString());
        shutdownRequest.setMsgState(Message.MessageState.NEW);
        int timeout = 300000;
        GobblinHelixMessagingService messagingService = new GobblinHelixMessagingService(this.helixManager);
        int messagesSent = messagingService.send(criteria, shutdownRequest, new NoopReplyHandler(), 300000);
        if (messagesSent == 0) {
            LOGGER.error(String.format("Failed to send the %s message to the participants", shutdownRequest.getMsgSubType()));
        }
    }

    public void close() throws IOException {
        this.applicationLauncher.close();
    }

    public StandardMetricsBridge.StandardMetrics getStandardMetrics() {
        return this.metrics;
    }

    @Nonnull
    public MetricContext getMetricContext() {
        return this.metricContext;
    }

    public boolean isInstrumentationEnabled() {
        return GobblinMetrics.isEnabled((Properties)ConfigUtils.configToProperties((Config)this.config));
    }

    private static String getApplicationId() {
        return "1";
    }

    private static Options buildOptions() {
        Options options = new Options();
        options.addOption("a", "app_name", true, "Gobblin application name");
        options.addOption("s", "standalone_cluster", true, "Standalone cluster mode");
        options.addOption("i", "helix_instance_name", true, "Helix instance name");
        return options;
    }

    private static void printUsage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(GobblinClusterManager.class.getSimpleName(), options);
    }

    public static void main(String[] args) throws Exception {
        Options options = GobblinClusterManager.buildOptions();
        try {
            CommandLine cmd = new DefaultParser().parse(options, args);
            if (!cmd.hasOption("app_name")) {
                GobblinClusterManager.printUsage(options);
                System.exit(1);
            }
            boolean isStandaloneClusterManager = false;
            if (cmd.hasOption("standalone_cluster")) {
                isStandaloneClusterManager = Boolean.parseBoolean(cmd.getOptionValue("standalone_cluster", "false"));
            }
            LOGGER.info(JvmUtils.getJvmInputArguments());
            Config config = ConfigFactory.load();
            if (cmd.hasOption("helix_instance_name")) {
                config = config.withValue("gobblin.cluster.helixInstanceName", ConfigValueFactory.fromAnyRef((Object)cmd.getOptionValue("helix_instance_name")));
            }
            if (isStandaloneClusterManager) {
                config = config.withValue("gobblin.cluster.standaloneMode", ConfigValueFactory.fromAnyRef((Object)true));
            }
            try (GobblinClusterManager gobblinClusterManager = new GobblinClusterManager(cmd.getOptionValue("app_name"), GobblinClusterManager.getApplicationId(), config, (Optional<Path>)Optional.absent());){
                if (isStandaloneClusterManager) {
                    String zkConnectionString = config.getString("gobblin.cluster.zk.connection.string");
                    String helixClusterName = config.getString("gobblin.cluster.helix.cluster.name");
                    HelixUtils.createGobblinHelixCluster(zkConnectionString, helixClusterName, false);
                    LOGGER.info("Created Helix cluster " + helixClusterName);
                }
                gobblinClusterManager.start();
            }
        }
        catch (ParseException pe) {
            GobblinClusterManager.printUsage(options);
            System.exit(1);
        }
    }

    public MutableJobCatalog getJobCatalog() {
        return this.jobCatalog;
    }

    public GobblinHelixJobScheduler getJobScheduler() {
        return this.jobScheduler;
    }

    public JobConfigurationManager getJobConfigurationManager() {
        return this.jobConfigurationManager;
    }

    private static class ControllerUserDefinedMessageHandlerFactory
    implements MessageHandlerFactory {
        private ControllerUserDefinedMessageHandlerFactory() {
        }

        public MessageHandler createHandler(Message message, NotificationContext context) {
            return new ControllerUserDefinedMessageHandler(message, context);
        }

        public String getMessageType() {
            return Message.MessageType.USER_DEFINE_MSG.toString();
        }

        public List<String> getMessageTypes() {
            return Collections.singletonList(this.getMessageType());
        }

        public void reset() {
        }

        private static class ControllerUserDefinedMessageHandler
        extends MessageHandler {
            public ControllerUserDefinedMessageHandler(Message message, NotificationContext context) {
                super(message, context);
            }

            public HelixTaskResult handleMessage() throws InterruptedException {
                LOGGER.warn(String.format("No handling setup for %s message of subtype: %s", Message.MessageType.USER_DEFINE_MSG.toString(), this._message.getMsgSubType()));
                HelixTaskResult helixTaskResult = new HelixTaskResult();
                helixTaskResult.setSuccess(true);
                return helixTaskResult;
            }

            public void onError(Exception e, MessageHandler.ErrorCode code, MessageHandler.ErrorType type) {
                LOGGER.error(String.format("Failed to handle message with exception %s, error code %s, error type %s", e, code, type));
            }
        }
    }

    private class ControllerShutdownMessageHandlerFactory
    implements MessageHandlerFactory {
        private ControllerShutdownMessageHandlerFactory() {
        }

        public MessageHandler createHandler(Message message, NotificationContext context) {
            return new ControllerShutdownMessageHandler(message, context);
        }

        public String getMessageType() {
            return "SHUTDOWN";
        }

        public List<String> getMessageTypes() {
            return Collections.singletonList(this.getMessageType());
        }

        public void reset() {
        }

        private class ControllerShutdownMessageHandler
        extends MessageHandler {
            public ControllerShutdownMessageHandler(Message message, NotificationContext context) {
                super(message, context);
            }

            public HelixTaskResult handleMessage() throws InterruptedException {
                String messageSubType = this._message.getMsgSubType();
                Preconditions.checkArgument((boolean)messageSubType.equalsIgnoreCase(HelixMessageSubTypes.APPLICATION_MASTER_SHUTDOWN.toString()), (Object)String.format("Unknown %s message subtype: %s", "SHUTDOWN", messageSubType));
                HelixTaskResult result = new HelixTaskResult();
                if (GobblinClusterManager.this.stopInProgress) {
                    result.setSuccess(true);
                    return result;
                }
                LOGGER.info("Handling message " + HelixMessageSubTypes.APPLICATION_MASTER_SHUTDOWN.toString());
                ScheduledExecutorService shutdownMessageHandlingCompletionWatcher = MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)new ScheduledThreadPoolExecutor(1));
                shutdownMessageHandlingCompletionWatcher.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        HelixManager helixManager = ControllerShutdownMessageHandler.this._notificationContext.getManager();
                        HelixDataAccessor helixDataAccessor = helixManager.getHelixDataAccessor();
                        HelixProperty helixProperty = helixDataAccessor.getProperty(ControllerShutdownMessageHandler.this._message.getKey(helixDataAccessor.keyBuilder(), helixManager.getInstanceName()));
                        if (helixProperty == null) {
                            GobblinClusterManager.this.eventBus.post((Object)new ClusterManagerShutdownRequest());
                        }
                    }
                }, 0L, 1L, TimeUnit.SECONDS);
                result.setSuccess(true);
                return result;
            }

            public void onError(Exception e, MessageHandler.ErrorCode code, MessageHandler.ErrorType type) {
                LOGGER.error(String.format("Failed to handle message with exception %s, error code %s, error type %s", e, code, type));
            }
        }
    }

    private class Metrics
    extends StandardMetricsBridge.StandardMetrics {
        public static final String CLUSTER_LEADERSHIP_CHANGE = "clusterLeadershipChange";
        private ContextAwareHistogram clusterLeadershipChange;

        public Metrics(MetricContext metricContext, Config config) {
            int timeWindowSizeInMinutes = ConfigUtils.getInt((Config)config, (String)"metrics.timer.window.size.in.minutes", (Integer)15);
            this.clusterLeadershipChange = metricContext.contextAwareHistogram(CLUSTER_LEADERSHIP_CHANGE, (long)timeWindowSizeInMinutes, TimeUnit.MINUTES);
            this.contextAwareMetrics.add(this.clusterLeadershipChange);
        }

        public String getName() {
            return GobblinClusterManager.class.getName();
        }
    }

    private static class GobblinLiveInstanceChangeListener
    implements LiveInstanceChangeListener {
        private GobblinLiveInstanceChangeListener() {
        }

        public void onLiveInstanceChange(List<LiveInstance> liveInstances, NotificationContext changeContext) {
            for (LiveInstance liveInstance : liveInstances) {
                LOGGER.info("Live Helix participant instance: " + liveInstance.getInstanceName());
            }
        }
    }
}

