/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;
import org.influxdb.dto.Pong;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;

public interface InfluxDB {
    public static final int CONNECT_TIMEOUT_SECONDS_DEFAULT = 15;
    public static final int READ_TIMEOUT_SECONDS_DEFAULT = 20;
    public static final int WRITE_TIMEOUT_SECONDS_DEFAULT = 20;

    public InfluxDB setLogLevel(LogLevel var1);

    public InfluxDB enableBatch(int var1, int var2, TimeUnit var3);

    public void disableBatch();

    public Pong ping();

    public String version();

    public void write(String var1, String var2, Point var3);

    public void write(BatchPoints var1);

    public QueryResult query(Query var1);

    public QueryResult query(Query var1, TimeUnit var2);

    public void createDatabase(String var1);

    public void deleteDatabase(String var1);

    public List<String> describeDatabases();

    public void setConnectTimeout(long var1, TimeUnit var3);

    public void setReadTimeout(long var1, TimeUnit var3);

    public void setWriteTimeout(long var1, TimeUnit var3);

    public static enum ConsistencyLevel {
        ALL("all"),
        ANY("any"),
        ONE("one"),
        QUORUM("quorum");

        private final String value;

        private ConsistencyLevel(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static enum LogLevel {
        NONE,
        BASIC,
        HEADERS,
        FULL;

    }
}

