/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.squareup.okhttp.OkHttpClient;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.influxdb.InfluxDB;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;
import org.influxdb.dto.Pong;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.influxdb.impl.BatchProcessor;
import org.influxdb.impl.InfluxDBErrorHandler;
import org.influxdb.impl.InfluxDBService;
import org.influxdb.impl.TimeUtil;
import retrofit.ErrorHandler;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.client.Header;
import retrofit.client.OkClient;
import retrofit.client.Response;
import retrofit.mime.TypedString;

public class InfluxDBImpl
implements InfluxDB {
    private final String username;
    private final String password;
    private final RestAdapter restAdapter;
    private final InfluxDBService influxDBService;
    private BatchProcessor batchProcessor;
    private final AtomicBoolean batchEnabled = new AtomicBoolean(false);
    private final AtomicLong writeCount = new AtomicLong();
    private final AtomicLong unBatchedCount = new AtomicLong();
    private final AtomicLong batchedCount = new AtomicLong();
    private InfluxDB.LogLevel logLevel = InfluxDB.LogLevel.NONE;
    private OkHttpClient okHttpClient;

    public InfluxDBImpl(String url, String username, String password) {
        this.username = username;
        this.password = password;
        this.okHttpClient = new OkHttpClient();
        this.okHttpClient.setConnectTimeout(15L, TimeUnit.SECONDS);
        this.okHttpClient.setReadTimeout(20L, TimeUnit.SECONDS);
        this.okHttpClient.setWriteTimeout(20L, TimeUnit.SECONDS);
        OkClient client = new OkClient(this.okHttpClient);
        this.restAdapter = new RestAdapter.Builder().setEndpoint(url).setErrorHandler((ErrorHandler)new InfluxDBErrorHandler()).setClient((Client)client).build();
        this.influxDBService = (InfluxDBService)this.restAdapter.create(InfluxDBService.class);
    }

    @Override
    public InfluxDB setLogLevel(InfluxDB.LogLevel logLevel) {
        switch (logLevel) {
            case NONE: {
                this.restAdapter.setLogLevel(RestAdapter.LogLevel.NONE);
                break;
            }
            case BASIC: {
                this.restAdapter.setLogLevel(RestAdapter.LogLevel.BASIC);
                break;
            }
            case HEADERS: {
                this.restAdapter.setLogLevel(RestAdapter.LogLevel.HEADERS);
                break;
            }
            case FULL: {
                this.restAdapter.setLogLevel(RestAdapter.LogLevel.FULL);
                break;
            }
        }
        this.logLevel = logLevel;
        return this;
    }

    @Override
    public InfluxDB enableBatch(int actions, int flushDuration, TimeUnit flushDurationTimeUnit) {
        if (this.batchEnabled.get()) {
            throw new IllegalArgumentException("BatchProcessing is already enabled.");
        }
        this.batchProcessor = BatchProcessor.builder(this).actions(actions).interval(flushDuration, flushDurationTimeUnit).build();
        this.batchEnabled.set(true);
        return this;
    }

    @Override
    public void disableBatch() {
        this.batchEnabled.set(false);
        this.batchProcessor.flush();
        if (this.logLevel != InfluxDB.LogLevel.NONE) {
            System.out.println("total writes:" + this.writeCount.get() + " unbatched:" + this.unBatchedCount.get() + "batchPoints:" + this.batchedCount);
        }
    }

    @Override
    public Pong ping() {
        Stopwatch watch = Stopwatch.createStarted();
        Response response = this.influxDBService.ping();
        List headers = response.getHeaders();
        String version = "unknown";
        for (Header header : headers) {
            if (null == header.getName() || !header.getName().equalsIgnoreCase("X-Influxdb-Version")) continue;
            version = header.getValue();
        }
        Pong pong = new Pong();
        pong.setVersion(version);
        pong.setResponseTime(watch.elapsed(TimeUnit.MILLISECONDS));
        return pong;
    }

    @Override
    public String version() {
        return this.ping().getVersion();
    }

    @Override
    public void write(String database, String retentionPolicy, Point point) {
        if (this.batchEnabled.get()) {
            BatchProcessor.BatchEntry batchEntry = new BatchProcessor.BatchEntry(point, database, retentionPolicy);
            this.batchProcessor.put(batchEntry);
        } else {
            BatchPoints batchPoints = BatchPoints.database(database).retentionPolicy(retentionPolicy).build();
            batchPoints.point(point);
            this.write(batchPoints);
            this.unBatchedCount.incrementAndGet();
        }
        this.writeCount.incrementAndGet();
    }

    @Override
    public void write(BatchPoints batchPoints) {
        this.batchedCount.addAndGet(batchPoints.getPoints().size());
        TypedString lineProtocol = new TypedString(batchPoints.lineProtocol());
        this.influxDBService.writePoints(this.username, this.password, batchPoints.getDatabase(), batchPoints.getRetentionPolicy(), TimeUtil.toTimePrecision(TimeUnit.NANOSECONDS), batchPoints.getConsistency().value(), lineProtocol);
    }

    @Override
    public QueryResult query(Query query) {
        QueryResult response = this.influxDBService.query(this.username, this.password, query.getDatabase(), query.getCommand());
        return response;
    }

    @Override
    public QueryResult query(Query query, TimeUnit timeUnit) {
        QueryResult response = this.influxDBService.query(this.username, this.password, query.getDatabase(), TimeUtil.toTimePrecision(timeUnit), query.getCommand());
        return response;
    }

    @Override
    public void createDatabase(String name) {
        Preconditions.checkArgument((!name.contains("-") ? 1 : 0) != 0, (Object)"Databasename cant contain -");
        this.influxDBService.query(this.username, this.password, "CREATE DATABASE IF NOT EXISTS " + name);
    }

    @Override
    public void deleteDatabase(String name) {
        this.influxDBService.query(this.username, this.password, "DROP DATABASE " + name);
    }

    @Override
    public List<String> describeDatabases() {
        QueryResult result = this.influxDBService.query(this.username, this.password, "SHOW DATABASES");
        List<List<Object>> databaseNames = result.getResults().get(0).getSeries().get(0).getValues();
        ArrayList databases = Lists.newArrayList();
        if (databaseNames != null) {
            for (List<Object> database : databaseNames) {
                databases.add(database.get(0).toString());
            }
        }
        return databases;
    }

    @Override
    public void setConnectTimeout(long connectTimeout, TimeUnit timeUnit) {
        this.okHttpClient.setConnectTimeout(connectTimeout, timeUnit);
    }

    @Override
    public void setReadTimeout(long readTimeout, TimeUnit timeUnit) {
        this.okHttpClient.setReadTimeout(readTimeout, timeUnit);
    }

    @Override
    public void setWriteTimeout(long writeTimeout, TimeUnit timeUnit) {
        this.okHttpClient.setWriteTimeout(writeTimeout, timeUnit);
    }
}

