/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.properties;

import com.linkedin.util.ArgumentUtil;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ServiceProperties {
    private final String _serviceName;
    private final String _clusterName;
    private final String _path;
    private final List<String> _loadBalancerStrategyList;
    private final Map<String, Object> _loadBalancerStrategyProperties;
    private final Map<String, Object> _transportClientProperties;
    private final Map<String, String> _degraderProperties;
    private final List<String> _prioritizedSchemes;
    private final Set<URI> _banned;
    private final Map<String, Object> _serviceMetadataProperties;

    public ServiceProperties(String serviceName, String clusterName, String path, List<String> loadBalancerStrategyList) {
        this(serviceName, clusterName, path, loadBalancerStrategyList, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList(), Collections.emptySet());
    }

    public ServiceProperties(String serviceName, String clusterName, String path, List<String> loadBalancerStrategyList, Map<String, Object> loadBalancerStrategyProperties) {
        this(serviceName, clusterName, path, loadBalancerStrategyList, loadBalancerStrategyProperties, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList(), Collections.emptySet());
    }

    public ServiceProperties(String serviceName, String clusterName, String path, List<String> loadBalancerStrategyList, Map<String, Object> loadBalancerStrategyProperties, Map<String, Object> transportClientProperties, Map<String, String> degraderProperties, List<String> prioritizedSchemes, Set<URI> banned) {
        this(serviceName, clusterName, path, loadBalancerStrategyList, loadBalancerStrategyProperties, transportClientProperties, degraderProperties, prioritizedSchemes, banned, Collections.emptyMap());
    }

    public ServiceProperties(String serviceName, String clusterName, String path, List<String> loadBalancerStrategyList, Map<String, Object> loadBalancerStrategyProperties, Map<String, Object> transportClientProperties, Map<String, String> degraderProperties, List<String> prioritizedSchemes, Set<URI> banned, Map<String, Object> serviceMetadataProperties) {
        ArgumentUtil.notNull((Object)serviceName, (String)"serviceName");
        ArgumentUtil.notNull((Object)clusterName, (String)"clusterName");
        ArgumentUtil.notNull((Object)path, (String)"path");
        ArgumentUtil.notNull(loadBalancerStrategyProperties, (String)"loadBalancerStrategyProperties");
        if (loadBalancerStrategyList == null || loadBalancerStrategyList.isEmpty()) {
            throw new NullPointerException("loadBalancerStrategyList is null or empty");
        }
        this._serviceName = serviceName;
        this._clusterName = clusterName;
        this._path = path;
        this._loadBalancerStrategyList = Collections.unmodifiableList(loadBalancerStrategyList);
        this._loadBalancerStrategyProperties = Collections.unmodifiableMap(loadBalancerStrategyProperties);
        this._transportClientProperties = transportClientProperties != null ? Collections.unmodifiableMap(transportClientProperties) : Collections.emptyMap();
        this._degraderProperties = degraderProperties != null ? Collections.unmodifiableMap(degraderProperties) : Collections.emptyMap();
        this._prioritizedSchemes = prioritizedSchemes != null ? Collections.unmodifiableList(prioritizedSchemes) : Collections.emptyList();
        this._banned = banned != null ? Collections.unmodifiableSet(banned) : Collections.emptySet();
        this._serviceMetadataProperties = serviceMetadataProperties != null ? Collections.unmodifiableMap(serviceMetadataProperties) : Collections.emptyMap();
    }

    public String getClusterName() {
        return this._clusterName;
    }

    public List<String> getLoadBalancerStrategyList() {
        return this._loadBalancerStrategyList;
    }

    public String getPath() {
        return this._path;
    }

    public String getServiceName() {
        return this._serviceName;
    }

    public Map<String, Object> getLoadBalancerStrategyProperties() {
        return this._loadBalancerStrategyProperties;
    }

    public Map<String, Object> getTransportClientProperties() {
        return this._transportClientProperties;
    }

    public Map<String, String> getDegraderProperties() {
        return this._degraderProperties;
    }

    public List<String> getPrioritizedSchemes() {
        return this._prioritizedSchemes;
    }

    public Set<URI> getBanned() {
        return this._banned;
    }

    public boolean isBanned(URI uri) {
        return this._banned.contains(uri);
    }

    public Map<String, Object> getServiceMetadataProperties() {
        return this._serviceMetadataProperties;
    }

    public String toString() {
        return "ServiceProperties [_clusterName=" + this._clusterName + ", _path=" + this._path + ", _serviceName=" + this._serviceName + ", _loadBalancerStrategyList=" + this._loadBalancerStrategyList + ", _loadBalancerStrategyProperties=" + this._loadBalancerStrategyProperties + ", _transportClientProperties=" + this._transportClientProperties + ", _degraderProperties=" + this._degraderProperties + ", prioritizedSchemes=" + this._prioritizedSchemes + ", bannedUris=" + this._banned + ", serviceMetadata=" + this._serviceMetadataProperties + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._clusterName.hashCode();
        result = 31 * result + this._loadBalancerStrategyList.hashCode();
        result = 31 * result + this._path.hashCode();
        result = 31 * result + this._serviceName.hashCode();
        result = 31 * result + this._loadBalancerStrategyProperties.hashCode();
        result = 31 * result + this._degraderProperties.hashCode();
        result = 31 * result + this._transportClientProperties.hashCode();
        result = 31 * result + this._prioritizedSchemes.hashCode();
        result = 31 * result + this._banned.hashCode();
        result = 31 * result + this._serviceMetadataProperties.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceProperties other = (ServiceProperties)obj;
        if (!this._clusterName.equals(other._clusterName)) {
            return false;
        }
        if (!this._loadBalancerStrategyList.equals(other._loadBalancerStrategyList)) {
            return false;
        }
        if (!this._path.equals(other._path)) {
            return false;
        }
        if (!this._serviceName.equals(other._serviceName)) {
            return false;
        }
        if (!this._loadBalancerStrategyProperties.equals(other._loadBalancerStrategyProperties)) {
            return false;
        }
        if (!this._transportClientProperties.equals(other._transportClientProperties)) {
            return false;
        }
        if (!this._degraderProperties.equals(other._degraderProperties)) {
            return false;
        }
        if (!this._prioritizedSchemes.equals(other._prioritizedSchemes)) {
            return false;
        }
        if (!this._banned.equals(other._banned)) {
            return false;
        }
        return this._serviceMetadataProperties.equals(other._serviceMetadataProperties);
    }
}

