/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.strategies.degrader;

import com.linkedin.d2.balancer.KeyMapper;
import com.linkedin.d2.balancer.clients.TrackerClient;
import com.linkedin.d2.balancer.strategies.LoadBalancerStrategy;
import com.linkedin.d2.balancer.strategies.degrader.DegraderLoadBalancerStrategyConfig;
import com.linkedin.d2.balancer.strategies.degrader.TrackerClientUpdater;
import com.linkedin.d2.balancer.util.hashing.ConsistentHashRing;
import com.linkedin.d2.balancer.util.hashing.HashFunction;
import com.linkedin.d2.balancer.util.hashing.RandomHash;
import com.linkedin.d2.balancer.util.hashing.Ring;
import com.linkedin.d2.balancer.util.hashing.URIRegexHash;
import com.linkedin.d2.discovery.util.LogUtil;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DegraderLoadBalancerStrategyV2_1
implements LoadBalancerStrategy {
    public static final String HASH_METHOD_NONE = "none";
    public static final String HASH_METHOD_URI_REGEX = "uriRegex";
    public static final int DEFAULT_PARTITION_ID = 0;
    private static final Logger _log = LoggerFactory.getLogger(DegraderLoadBalancerStrategyV2_1.class);
    private boolean _updateEnabled = true;
    private volatile DegraderLoadBalancerStrategyConfig _config;
    private volatile HashFunction<Request> _hashFunction;
    private volatile DegraderLoadBalancerState _state;
    private volatile Lock _lock;

    public DegraderLoadBalancerStrategyV2_1(DegraderLoadBalancerStrategyConfig config, String serviceName, Map<String, String> degraderProperties) {
        this.setConfig(config);
        this._lock = new ReentrantLock();
        if (degraderProperties == null) {
            degraderProperties = Collections.emptyMap();
        }
        this._state = new DegraderLoadBalancerState(this._config.getUpdateIntervalMs(), -1L, new HashMap<URI, Integer>(), this._config.getClock().currentTimeMillis(), DegraderLoadBalancerState.Strategy.LOAD_BALANCE, 0.0, 0.0, false, new HashMap<TrackerClient, Double>(), serviceName, degraderProperties, 0L);
    }

    @Override
    public TrackerClient getTrackerClient(Request request, RequestContext requestContext, long clusterGenerationId, int partitionId, List<TrackerClient> trackerClients) {
        boolean dropCall;
        if (partitionId != 0) {
            throw new UnsupportedOperationException("Trying to access partition: " + partitionId + "on an unpartitioned cluster");
        }
        LogUtil.debug(_log, "getTrackerClient with generation id ", clusterGenerationId, " on tracker clients: ", clusterGenerationId);
        if (trackerClients == null || trackerClients.size() == 0) {
            LogUtil.warn(_log, "getTrackerClient called with null/empty trackerClients, so returning null");
            return null;
        }
        this.checkUpdateState(clusterGenerationId, trackerClients);
        URI targetHostUri = KeyMapper.TargetHostHints.getRequestContextTargetHost(requestContext);
        Set<URI> excludedUris = LoadBalancerStrategy.ExcludedHostHints.getRequestContextExcludedHosts(requestContext);
        URI hostHeaderUri = targetHostUri;
        if (targetHostUri == null) {
            int hashCode = this._hashFunction.hash(request);
            Ring<URI> ring = this._state.getRing();
            Iterator<URI> iterator = ring.getIterator(hashCode);
            while (iterator.hasNext() && targetHostUri == null) {
                URI uri = iterator.next();
                if (excludedUris != null && excludedUris.contains(uri)) continue;
                targetHostUri = uri;
            }
            LoadBalancerStrategy.ExcludedHostHints.addRequestContextExcludedHost(requestContext, targetHostUri);
        } else {
            LogUtil.debug(_log, "Degrader honoring target host header in request, skipping hashing.  URI: " + targetHostUri.toString());
        }
        TrackerClient client = null;
        if (targetHostUri != null) {
            for (TrackerClient trackerClient : trackerClients) {
                if (!trackerClient.getUri().equals(targetHostUri)) continue;
                client = trackerClient;
                break;
            }
            if (client == null) {
                LogUtil.warn(_log, "No client found for " + targetHostUri + (hostHeaderUri == null ? ", degrader load balancer state is inconsistent with cluster manager" : ", target host specified is no longer part of cluster"));
            }
        } else {
            LogUtil.warn(_log, "unable to find a URI to use");
        }
        boolean bl = dropCall = client == null;
        if (!dropCall) {
            dropCall = client.getDegrader(0).checkDrop();
            if (dropCall) {
                LogUtil.warn(_log, "client's degrader is dropping call for: ", client);
            } else {
                LogUtil.debug(_log, "returning client: ", client);
            }
        }
        return !dropCall ? client : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkUpdateState(long clusterGenerationId, List<TrackerClient> trackerClients) {
        DegraderLoadBalancerStrategyConfig config = this.getConfig();
        if (!this._state.isInitialized()) {
            this._lock.lock();
            try {
                if (this._state.isInitialized()) return;
                LogUtil.debug(_log, "initializing load balancer strategy state");
                this.updateState(clusterGenerationId, trackerClients, config);
                if (this.getState().isInitialized()) return;
                _log.error("Failed to initialize state");
                return;
            }
            finally {
                this._lock.unlock();
            }
        }
        if (!DegraderLoadBalancerStrategyV2_1.shouldUpdate(clusterGenerationId, this._state, config, this._updateEnabled) || !this._lock.tryLock()) return;
        try {
            if (!DegraderLoadBalancerStrategyV2_1.shouldUpdate(clusterGenerationId, this._state, config, this._updateEnabled)) return;
            LogUtil.debug(_log, "updating for cluster generation id: ", clusterGenerationId);
            LogUtil.debug(_log, "old state was: ", this._state);
            this.updateState(clusterGenerationId, trackerClients, config);
            return;
        }
        finally {
            this._lock.unlock();
        }
    }

    private void updateState(long clusterGenerationId, List<TrackerClient> trackerClients, DegraderLoadBalancerStrategyConfig config) {
        DegraderLoadBalancerState state;
        ArrayList<TrackerClientUpdater> clientUpdaters = new ArrayList<TrackerClientUpdater>();
        for (TrackerClient client : trackerClients) {
            clientUpdaters.add(new TrackerClientUpdater(client, 0));
        }
        this._state = state = DegraderLoadBalancerStrategyV2_1.doUpdateState(clusterGenerationId, this._state, config, clientUpdaters);
        for (TrackerClientUpdater clientUpdater : clientUpdaters) {
            clientUpdater.update();
        }
    }

    static boolean isNewStateHealthy(DegraderLoadBalancerState newState, DegraderLoadBalancerStrategyConfig config, List<TrackerClientUpdater> trackerClientUpdaters) {
        if (newState.getCurrentAvgClusterLatency() > config.getLowWaterMark()) {
            return false;
        }
        Map<URI, Integer> pointsMap = newState.getPointsMap();
        for (TrackerClientUpdater clientUpdater : trackerClientUpdaters) {
            TrackerClient client = clientUpdater.getTrackerClient();
            int perfectHealth = (int)(client.getPartitionWeight(0) * (double)config.getPointsPerWeight());
            Integer point = pointsMap.get(client.getUri());
            if (point >= perfectHealth) continue;
            return false;
        }
        return true;
    }

    static boolean isOldStateTheSameAsNewState(DegraderLoadBalancerState oldState, DegraderLoadBalancerState newState) {
        return oldState.getClusterGenerationId() == newState.getClusterGenerationId() && oldState.getCurrentOverrideDropRate() == newState.getCurrentOverrideDropRate() && oldState.getPointsMap().equals(newState.getPointsMap()) && oldState.getRecoveryMap().equals(newState.getRecoveryMap());
    }

    private static void logState(DegraderLoadBalancerState oldState, DegraderLoadBalancerState newState, DegraderLoadBalancerStrategyConfig config, List<TrackerClientUpdater> trackerClientUpdaters) {
        if (_log.isDebugEnabled()) {
            _log.debug("Strategy updated: newState=" + newState + ", unhealthyClients = " + DegraderLoadBalancerStrategyV2_1.getUnhealthyTrackerClients(trackerClientUpdaters, newState._pointsMap, config) + ", config=" + config + ", HashRing coverage=" + newState.getRing());
        } else if (!DegraderLoadBalancerStrategyV2_1.isOldStateTheSameAsNewState(oldState, newState) || !DegraderLoadBalancerStrategyV2_1.isNewStateHealthy(newState, config, trackerClientUpdaters)) {
            _log.info("Strategy updated: newState=" + newState + ", unhealthyClients = " + DegraderLoadBalancerStrategyV2_1.getUnhealthyTrackerClients(trackerClientUpdaters, newState._pointsMap, config) + ", oldState =" + oldState + ", new state's config=" + config);
        }
    }

    private static List<String> getUnhealthyTrackerClients(List<TrackerClientUpdater> trackerClientUpdaters, Map<URI, Integer> pointsMap, DegraderLoadBalancerStrategyConfig config) {
        ArrayList<String> unhealthyClients = new ArrayList<String>();
        for (TrackerClientUpdater clientUpdater : trackerClientUpdaters) {
            TrackerClient client = clientUpdater.getTrackerClient();
            int perfectHealth = (int)(client.getPartitionWeight(0) * (double)config.getPointsPerWeight());
            Integer point = pointsMap.get(client.getUri());
            if (point >= perfectHealth) continue;
            unhealthyClients.add(client.getUri() + ":" + point + "/" + perfectHealth);
        }
        return unhealthyClients;
    }

    private static DegraderLoadBalancerState doUpdateState(long clusterGenerationId, DegraderLoadBalancerState oldState, DegraderLoadBalancerStrategyConfig config, List<TrackerClientUpdater> trackerClientUpdaters) {
        DegraderLoadBalancerState newState;
        LogUtil.debug(_log, "updating state for: ", trackerClientUpdaters);
        double sumOfClusterLatencies = 0.0;
        double computedClusterDropSum = 0.0;
        double computedClusterWeight = 0.0;
        long totalClusterCallCount = 0L;
        boolean hashRingChanges = false;
        boolean recoveryMapChanges = false;
        DegraderLoadBalancerState.Strategy strategy = oldState.getStrategy();
        Map<TrackerClient, Double> oldRecoveryMap = oldState.getRecoveryMap();
        HashMap<TrackerClient, Double> newRecoveryMap = new HashMap<TrackerClient, Double>(oldRecoveryMap);
        double currentOverrideDropRate = oldState.getCurrentOverrideDropRate();
        double initialRecoveryLevel = config.getInitialRecoveryLevel();
        double ringRampFactor = config.getRingRampFactor();
        int pointsPerWeight = config.getPointsPerWeight();
        for (TrackerClientUpdater clientUpdater : trackerClientUpdaters) {
            TrackerClient client = clientUpdater.getTrackerClient();
            double averageLatency = client.getDegraderControl(0).getLatency();
            long callCount = client.getDegraderControl(0).getCallCount();
            oldState.getPreviousMaxDropRate().put(client, clientUpdater.getMaxDropRate());
            sumOfClusterLatencies += averageLatency * (double)callCount;
            totalClusterCallCount += callCount;
            double clientDropRate = client.getDegraderControl(0).getCurrentComputedDropRate();
            computedClusterDropSum += client.getPartitionWeight(0) * clientDropRate;
            computedClusterWeight += client.getPartitionWeight(0).doubleValue();
            boolean recoveryMapContainsClient = newRecoveryMap.containsKey(client);
            if (callCount == 0L) {
                if (!recoveryMapContainsClient) continue;
                if (strategy == DegraderLoadBalancerState.Strategy.LOAD_BALANCE) {
                    double oldMaxDropRate = clientUpdater.getMaxDropRate();
                    double transmissionRate = 1.0 - oldMaxDropRate;
                    if (transmissionRate <= 0.0) {
                        transmissionRate = initialRecoveryLevel;
                    } else {
                        transmissionRate *= ringRampFactor;
                        transmissionRate = Math.min(transmissionRate, 1.0);
                    }
                    double newMaxDropRate = 1.0 - transmissionRate;
                    clientUpdater.setMaxDropRate(newMaxDropRate);
                }
                recoveryMapChanges = true;
                continue;
            }
            if (!recoveryMapContainsClient) continue;
            clientUpdater.setMaxDropRate((Double)newRecoveryMap.get(client));
            newRecoveryMap.remove(client);
            recoveryMapChanges = true;
        }
        double computedClusterDropRate = computedClusterDropSum / computedClusterWeight;
        LogUtil.debug(_log, "total cluster call count: ", totalClusterCallCount);
        LogUtil.debug(_log, "computed cluster drop rate for ", trackerClientUpdaters.size(), " nodes: ", computedClusterDropRate);
        if (oldState.getClusterGenerationId() == clusterGenerationId && totalClusterCallCount <= 0L && !recoveryMapChanges) {
            LogUtil.debug(_log, "New state is the same as the old state so we're not changing anything. Old state = ", oldState, ", config=", config);
            return new DegraderLoadBalancerState(oldState, clusterGenerationId, config.getUpdateIntervalMs(), config.getClock().currentTimeMillis());
        }
        double newCurrentAvgClusterLatency = -1.0;
        if (totalClusterCallCount > 0L) {
            newCurrentAvgClusterLatency = sumOfClusterLatencies / (double)totalClusterCallCount;
        }
        LogUtil.debug(_log, "average cluster latency: ", newCurrentAvgClusterLatency);
        Map<URI, Integer> points = new HashMap<URI, Integer>();
        Map<URI, Integer> oldPointsMap = oldState.getPointsMap();
        for (TrackerClientUpdater clientUpdater : trackerClientUpdaters) {
            TrackerClient client = clientUpdater.getTrackerClient();
            URI clientUri = client.getUri();
            double dropRate = Math.min(client.getDegraderControl(0).getCurrentComputedDropRate(), clientUpdater.getMaxDropRate());
            double successfulTransmissionWeight = client.getPartitionWeight(0) * (1.0 - dropRate);
            LogUtil.debug(_log, "computed new weight for uri ", clientUri, ": ", successfulTransmissionWeight);
            int newPoints = (int)(successfulTransmissionWeight * (double)pointsPerWeight);
            if (newPoints == 0) {
                Double oldMaxDropRate = clientUpdater.getMaxDropRate();
                newPoints = (int)(initialRecoveryLevel * (double)pointsPerWeight);
                if (!newRecoveryMap.containsKey(client)) {
                    newRecoveryMap.put(client, oldMaxDropRate);
                    clientUpdater.setMaxDropRate(1.0 - initialRecoveryLevel);
                }
            }
            points.put(clientUri, newPoints);
            if (oldPointsMap.containsKey(clientUri) && oldPointsMap.get(clientUri) == newPoints) continue;
            hashRingChanges = true;
        }
        if (strategy == DegraderLoadBalancerState.Strategy.LOAD_BALANCE && hashRingChanges || oldState.getClusterGenerationId() != clusterGenerationId) {
            newState = new DegraderLoadBalancerState(config.getUpdateIntervalMs(), clusterGenerationId, points, config.getClock().currentTimeMillis(), DegraderLoadBalancerState.Strategy.CALL_DROPPING, currentOverrideDropRate, newCurrentAvgClusterLatency, true, newRecoveryMap, oldState.getServiceName(), oldState.getDegraderProperties(), totalClusterCallCount);
            DegraderLoadBalancerStrategyV2_1.logState(oldState, newState, config, trackerClientUpdaters);
        } else {
            double newDropLevel = Math.max(0.0, currentOverrideDropRate);
            if (newCurrentAvgClusterLatency > 0.0 && totalClusterCallCount >= config.getMinClusterCallCountHighWaterMark()) {
                if (newCurrentAvgClusterLatency >= config.getHighWaterMark() && currentOverrideDropRate != 1.0) {
                    newDropLevel = Math.min(1.0, newDropLevel + config.getGlobalStepUp());
                } else if (newCurrentAvgClusterLatency <= config.getLowWaterMark() && currentOverrideDropRate != 0.0) {
                    newDropLevel = Math.max(0.0, newDropLevel - config.getGlobalStepDown());
                }
            } else if (newCurrentAvgClusterLatency > 0.0 && totalClusterCallCount >= config.getMinClusterCallCountLowWaterMark()) {
                if (newCurrentAvgClusterLatency <= config.getLowWaterMark() && currentOverrideDropRate != 0.0) {
                    newDropLevel = Math.max(0.0, newDropLevel - config.getGlobalStepDown());
                }
            } else {
                newDropLevel = Math.max(0.0, newDropLevel - config.getGlobalStepDown());
            }
            if (newDropLevel != currentOverrideDropRate) {
                DegraderLoadBalancerStrategyV2_1.overrideClusterDropRate(newDropLevel, trackerClientUpdaters);
            }
            newState = new DegraderLoadBalancerState(config.getUpdateIntervalMs(), clusterGenerationId, oldPointsMap, config.getClock().currentTimeMillis(), DegraderLoadBalancerState.Strategy.LOAD_BALANCE, newDropLevel, newCurrentAvgClusterLatency, true, oldRecoveryMap, oldState.getServiceName(), oldState.getDegraderProperties(), totalClusterCallCount);
            DegraderLoadBalancerStrategyV2_1.logState(oldState, newState, config, trackerClientUpdaters);
            points = oldPointsMap;
        }
        DegraderLoadBalancerStrategyV2_1.overrideMinCallCount(currentOverrideDropRate, trackerClientUpdaters, points, pointsPerWeight);
        return newState;
    }

    public static void overrideClusterDropRate(double override, List<TrackerClientUpdater> trackerClientUpdaters) {
        LogUtil.warn(_log, "overriding degrader drop rate to ", override, " for clients: ", trackerClientUpdaters);
        for (TrackerClientUpdater clientUpdater : trackerClientUpdaters) {
            clientUpdater.setOverrideDropRate(override);
        }
    }

    public static void overrideMinCallCount(double newOverrideDropRate, List<TrackerClientUpdater> trackerClientUpdaters, Map<URI, Integer> pointsMap, int pointsPerWeight) {
        for (TrackerClientUpdater clientUpdater : trackerClientUpdaters) {
            TrackerClient client = clientUpdater.getTrackerClient();
            int currentOverrideMinCallCount = client.getDegraderControl(0).getOverrideMinCallCount();
            double hashFactor = pointsMap.get(client.getUri()) / pointsPerWeight;
            double transmitFactor = 1.0 - newOverrideDropRate;
            int newOverrideMinCallCount = (int)Math.max(Math.round((double)client.getDegraderControl(0).getMinCallCount() * hashFactor * transmitFactor), 1L);
            if (newOverrideMinCallCount == currentOverrideMinCallCount) continue;
            clientUpdater.setOverrideMinCallCount(newOverrideMinCallCount);
            LogUtil.warn(_log, "overriding Min Call Count to ", newOverrideMinCallCount, " for client: ", client.getUri());
        }
    }

    protected static boolean shouldUpdate(long clusterGenerationId, DegraderLoadBalancerState currentState, DegraderLoadBalancerStrategyConfig config, boolean updateEnabled) {
        return updateEnabled && (currentState.getClusterGenerationId() != clusterGenerationId || config.getClock().currentTimeMillis() - currentState.getLastUpdated() >= config.getUpdateIntervalMs() || currentState.getClusterGenerationId() == -1L);
    }

    public DegraderLoadBalancerState getState() {
        return this._state;
    }

    public DegraderLoadBalancerStrategyConfig getConfig() {
        return this._config;
    }

    public void setConfig(DegraderLoadBalancerStrategyConfig config) {
        this._config = config;
        String hashMethod = this._config.getHashMethod();
        Map<String, Object> hashConfig = this._config.getHashConfig();
        if (hashMethod == null || hashMethod.equals(HASH_METHOD_NONE)) {
            this._hashFunction = new RandomHash();
        } else if (HASH_METHOD_URI_REGEX.equals(hashMethod)) {
            this._hashFunction = new URIRegexHash(hashConfig);
        } else {
            _log.warn("Unknown hash method {}, falling back to random", (Object)hashMethod);
            this._hashFunction = new RandomHash();
        }
    }

    @Override
    public Ring<URI> getRing(long clusterGenerationId, int partitionId, List<TrackerClient> trackerClients) {
        if (partitionId != 0) {
            throw new UnsupportedOperationException("Trying to access partition: " + partitionId + "on an unpartitioned cluster");
        }
        this.checkUpdateState(clusterGenerationId, trackerClients);
        return this._state.getRing();
    }

    public boolean getUpdateEnabled() {
        return this._updateEnabled;
    }

    public void setUpdateEnabled(boolean enabled) {
        this._updateEnabled = enabled;
    }

    void setStrategy(DegraderLoadBalancerState.Strategy strategy) {
        DegraderLoadBalancerState newState;
        this._state = newState = new DegraderLoadBalancerState(this._state.getUpdateIntervalMs(), this._state.getClusterGenerationId(), this._state.getPointsMap(), this._state.getLastUpdated(), strategy, this._state.getCurrentOverrideDropRate(), this._state.getCurrentAvgClusterLatency(), this._state.isInitialized(), this._state.getRecoveryMap(), this._state.getServiceName(), this._state.getDegraderProperties(), this._state.getCurrentClusterCallCount());
    }

    public String toString() {
        return "DegraderLoadBalancerStrategyV2 [_config=" + this._config + ", _state=" + this._state + ", _updateEnabled=" + this._updateEnabled + "]";
    }

    public double getCurrentOverrideDropRate() {
        return this._state.getCurrentOverrideDropRate();
    }

    public static class DegraderLoadBalancerState {
        private final long _lastUpdated;
        private final long _updateIntervalMs;
        private final long _clusterGenerationId;
        private final Ring<URI> _ring;
        private final String _serviceName;
        private final Map<String, String> _degraderProperties;
        private final Map<URI, Integer> _pointsMap;
        private final Map<TrackerClient, Double> _recoveryMap;
        private final Strategy _strategy;
        private final double _currentOverrideDropRate;
        private final double _currentAvgClusterLatency;
        private final long _currentClusterCallCount;
        private final boolean _initialized;
        private final Map<TrackerClient, Double> _previousMaxDropRate;

        public DegraderLoadBalancerState(DegraderLoadBalancerState state, long clusterGenerationId, long updateIntervalMs, long lastUpdated) {
            this._clusterGenerationId = clusterGenerationId;
            this._lastUpdated = lastUpdated;
            this._updateIntervalMs = updateIntervalMs;
            this._strategy = state._strategy;
            this._currentAvgClusterLatency = state._currentAvgClusterLatency;
            this._currentOverrideDropRate = state._currentOverrideDropRate;
            this._initialized = state._initialized;
            this._serviceName = state._serviceName;
            this._ring = state._ring;
            this._pointsMap = state._pointsMap;
            this._recoveryMap = state._recoveryMap;
            this._degraderProperties = state._degraderProperties;
            this._previousMaxDropRate = new HashMap<TrackerClient, Double>();
            this._currentClusterCallCount = state._currentClusterCallCount;
        }

        public DegraderLoadBalancerState(long updateIntervalMs, long clusterGenerationId, Map<URI, Integer> pointsMap, long lastUpdated, Strategy strategy, double currentOverrideDropRate, double currentAvgClusterLatency, boolean initState, Map<TrackerClient, Double> recoveryMap, String serviceName, Map<String, String> degraderProperties, long currentClusterCallCount) {
            this._lastUpdated = lastUpdated;
            this._updateIntervalMs = updateIntervalMs;
            this._clusterGenerationId = clusterGenerationId;
            this._ring = new ConsistentHashRing<URI>(pointsMap);
            this._pointsMap = pointsMap != null ? Collections.unmodifiableMap(new HashMap<URI, Integer>(pointsMap)) : Collections.emptyMap();
            this._strategy = strategy;
            this._currentOverrideDropRate = currentOverrideDropRate;
            this._currentAvgClusterLatency = currentAvgClusterLatency;
            this._initialized = initState;
            this._recoveryMap = recoveryMap != null ? Collections.unmodifiableMap(new HashMap<TrackerClient, Double>(recoveryMap)) : Collections.emptyMap();
            this._serviceName = serviceName;
            this._degraderProperties = degraderProperties != null ? Collections.unmodifiableMap(new HashMap<String, String>(degraderProperties)) : Collections.emptyMap();
            this._previousMaxDropRate = new HashMap<TrackerClient, Double>();
            this._currentClusterCallCount = currentClusterCallCount;
        }

        public Map<String, String> getDegraderProperties() {
            return this._degraderProperties;
        }

        private String getServiceName() {
            return this._serviceName;
        }

        public long getLastUpdated() {
            return this._lastUpdated;
        }

        public long getCurrentClusterCallCount() {
            return this._currentClusterCallCount;
        }

        public long getUpdateIntervalMs() {
            return this._updateIntervalMs;
        }

        public long getClusterGenerationId() {
            return this._clusterGenerationId;
        }

        public Ring<URI> getRing() {
            return this._ring;
        }

        public Map<URI, Integer> getPointsMap() {
            return this._pointsMap;
        }

        public Strategy getStrategy() {
            return this._strategy;
        }

        public Map<TrackerClient, Double> getRecoveryMap() {
            return this._recoveryMap;
        }

        public double getCurrentOverrideDropRate() {
            return this._currentOverrideDropRate;
        }

        public double getCurrentAvgClusterLatency() {
            return this._currentAvgClusterLatency;
        }

        public boolean isInitialized() {
            return this._initialized;
        }

        public Map<TrackerClient, Double> getPreviousMaxDropRate() {
            return this._previousMaxDropRate;
        }

        public String toString() {
            return "DegraderLoadBalancerState [_serviceName=" + this._serviceName + ", _currentClusterCallCount=" + this._currentClusterCallCount + ", _currentAvgClusterLatency=" + this._currentAvgClusterLatency + ", _currentOverrideDropRate=" + this._currentOverrideDropRate + ", _clusterGenerationId=" + this._clusterGenerationId + ", _updateIntervalMs=" + this._updateIntervalMs + ", _lastUpdated=" + this._lastUpdated + ", _strategy=" + (Object)((Object)this._strategy) + ", _recoveryMap=" + this._recoveryMap + "]";
        }

        public static enum Strategy {
            LOAD_BALANCE,
            CALL_DROPPING;

        }
    }
}

