/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util.partitions;

import com.linkedin.d2.balancer.util.partitions.PartitionAccessException;
import com.linkedin.d2.balancer.util.partitions.PartitionAccessor;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractPartitionAccessor
implements PartitionAccessor {
    private final Pattern _pattern;
    private final int _maxPartitionId;

    public AbstractPartitionAccessor(String pattenStr, int maxPartitionId) {
        this._pattern = Pattern.compile(pattenStr);
        this._maxPartitionId = maxPartitionId;
    }

    @Override
    public int getPartitionId(URI uri) throws PartitionAccessException {
        String uriString = uri.toString();
        Matcher matcher = this._pattern.matcher(uriString);
        if (matcher.find()) {
            String key = matcher.group(matcher.groupCount());
            return this.getPartitionId(key);
        }
        throw new PartitionAccessException("Pattern: " + this._pattern.toString() + " does not match anything in request URI: " + uriString);
    }

    @Override
    public int getMaxPartitionId() {
        return this._maxPartitionId;
    }
}

