/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import parquet.Log;
import parquet.filter.UnboundRecordFilter;
import parquet.hadoop.InternalParquetRecordReader;
import parquet.hadoop.ParquetInputSplit;
import parquet.hadoop.api.ReadSupport;
import parquet.hadoop.util.ContextUtil;
import parquet.hadoop.util.counters.BenchmarkCounter;
import parquet.schema.MessageTypeParser;

public class ParquetRecordReader<T>
extends RecordReader<Void, T> {
    private static final Log LOG = Log.getLog(ParquetRecordReader.class);
    private InternalParquetRecordReader<T> internalReader;

    public ParquetRecordReader(ReadSupport<T> readSupport) {
        this(readSupport, null);
    }

    public ParquetRecordReader(ReadSupport<T> readSupport, UnboundRecordFilter filter) {
        this.internalReader = new InternalParquetRecordReader<T>(readSupport, filter);
    }

    public void close() throws IOException {
        this.internalReader.close();
    }

    public Void getCurrentKey() throws IOException, InterruptedException {
        return null;
    }

    public T getCurrentValue() throws IOException, InterruptedException {
        return this.internalReader.getCurrentValue();
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.internalReader.getProgress();
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        if (context instanceof TaskInputOutputContext) {
            BenchmarkCounter.initCounterFromContext((TaskInputOutputContext)context);
        } else {
            LOG.error("Can not initialize counter due to context is not a instance of TaskInputOutputContext, but is " + context.getClass().getCanonicalName());
        }
        this.initializeInternalReader((ParquetInputSplit)inputSplit, ContextUtil.getConfiguration((JobContext)context));
    }

    public void initialize(InputSplit inputSplit, Configuration configuration, Reporter reporter) throws IOException, InterruptedException {
        BenchmarkCounter.initCounterFromReporter(reporter, configuration);
        this.initializeInternalReader((ParquetInputSplit)inputSplit, configuration);
    }

    private void initializeInternalReader(ParquetInputSplit split, Configuration configuration) throws IOException {
        this.internalReader.initialize(MessageTypeParser.parseMessageType(split.getRequestedSchema()), MessageTypeParser.parseMessageType(split.getFileSchema()), split.getExtraMetadata(), split.getReadSupportMetadata(), split.getPath(), split.getBlocks(), configuration);
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        return this.internalReader.nextKeyValue();
    }
}

