/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.instrumented.fork;

import com.google.common.base.Optional;
import java.util.List;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.fork.ForkOperator;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.instrumented.fork.InstrumentedForkOperatorBase;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.util.Decorator;
import org.apache.gobblin.util.DecoratorUtils;

public class InstrumentedForkOperatorDecorator<S, D>
extends InstrumentedForkOperatorBase<S, D>
implements Decorator {
    private ForkOperator<S, D> embeddedForkOperator;
    private boolean isEmbeddedInstrumented;

    public InstrumentedForkOperatorDecorator(ForkOperator<S, D> forkOperator) {
        super(Optional.of(DecoratorUtils.resolveUnderlyingObject(forkOperator).getClass()));
        this.embeddedForkOperator = (ForkOperator)this.closer.register(forkOperator);
        this.isEmbeddedInstrumented = Instrumented.isLineageInstrumented(forkOperator);
    }

    @Override
    public void init(WorkUnitState workUnitState) throws Exception {
        this.embeddedForkOperator.init(workUnitState);
        super.init(workUnitState, DecoratorUtils.resolveUnderlyingObject((Object)this).getClass());
    }

    @Override
    public MetricContext getMetricContext() {
        return this.isEmbeddedInstrumented ? ((InstrumentedForkOperatorBase)this.embeddedForkOperator).getMetricContext() : super.getMetricContext();
    }

    @Override
    public List<Boolean> forkDataRecord(WorkUnitState workUnitState, D input) {
        return this.isEmbeddedInstrumented ? this.forkDataRecordImpl(workUnitState, input) : super.forkDataRecord(workUnitState, input);
    }

    @Override
    public List<Boolean> forkDataRecordImpl(WorkUnitState workUnitState, D input) {
        return this.embeddedForkOperator.forkDataRecord(workUnitState, input);
    }

    public int getBranches(WorkUnitState workUnitState) {
        return this.embeddedForkOperator.getBranches(workUnitState);
    }

    public List<Boolean> forkSchema(WorkUnitState workUnitState, S input) {
        return this.embeddedForkOperator.forkSchema(workUnitState, input);
    }

    public Object getDecoratedObject() {
        return this.embeddedForkOperator;
    }
}

