/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import com.google.common.base.Optional;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.gobblin.source.extractor.CheckpointableWatermark;
import org.apache.gobblin.writer.WatermarkTracker;

public class MultiWriterWatermarkTracker
implements WatermarkTracker {
    private final ConcurrentHashMap<String, Set<CheckpointableWatermark>> candidateCommittables = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Set<CheckpointableWatermark>> unacknowledgedWatermarks = new ConcurrentHashMap();

    @Override
    public synchronized void reset() {
        this.candidateCommittables.clear();
        this.unacknowledgedWatermarks.clear();
    }

    private synchronized Set<CheckpointableWatermark> getOrCreate(Map<String, Set<CheckpointableWatermark>> map, String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        TreeSet<CheckpointableWatermark> set = new TreeSet<CheckpointableWatermark>();
        map.put(key, set);
        return set;
    }

    @Override
    public void committedWatermarks(Map<String, CheckpointableWatermark> committedMap) {
        this.committedWatermarks(committedMap.values());
    }

    public void committedWatermarks(Iterable<CheckpointableWatermark> committedStream) {
        for (CheckpointableWatermark committed : committedStream) {
            this.committedWatermark(committed);
        }
    }

    @Override
    public void committedWatermark(CheckpointableWatermark committed) {
        this.getOrCreate(this.candidateCommittables, committed.getSource()).add(committed);
    }

    @Override
    public void unacknowledgedWatermark(CheckpointableWatermark unacked) {
        this.getOrCreate(this.unacknowledgedWatermarks, unacked.getSource()).add(unacked);
    }

    @Override
    public void unacknowledgedWatermarks(Map<String, CheckpointableWatermark> unackedMap) {
        for (CheckpointableWatermark unacked : unackedMap.values()) {
            this.unacknowledgedWatermark(unacked);
        }
    }

    @Override
    public Map<String, CheckpointableWatermark> getAllCommitableWatermarks() {
        HashMap<String, CheckpointableWatermark> commitables = new HashMap<String, CheckpointableWatermark>(this.candidateCommittables.size());
        for (String source : this.candidateCommittables.keySet()) {
            Optional<CheckpointableWatermark> commitable = this.getCommittableWatermark(source);
            if (!commitable.isPresent()) continue;
            commitables.put(((CheckpointableWatermark)commitable.get()).getSource(), (CheckpointableWatermark)commitable.get());
        }
        return commitables;
    }

    @Override
    public Map<String, CheckpointableWatermark> getAllUnacknowledgedWatermarks() {
        HashMap<String, CheckpointableWatermark> unackedMap = new HashMap<String, CheckpointableWatermark>(this.unacknowledgedWatermarks.size());
        for (String source : this.unacknowledgedWatermarks.keySet()) {
            Optional<CheckpointableWatermark> unacked = this.getUnacknowledgedWatermark(source);
            if (!unacked.isPresent()) continue;
            unackedMap.put(((CheckpointableWatermark)unacked.get()).getSource(), (CheckpointableWatermark)unacked.get());
        }
        return unackedMap;
    }

    public Optional<CheckpointableWatermark> getCommittableWatermark(String source) {
        Set<CheckpointableWatermark> unacked = this.unacknowledgedWatermarks.get(source);
        CheckpointableWatermark minUnacknowledgedWatermark = unacked == null || unacked.isEmpty() ? null : unacked.iterator().next();
        CheckpointableWatermark highestCommitableWatermark = null;
        for (CheckpointableWatermark commitableWatermark : this.candidateCommittables.get(source)) {
            if (minUnacknowledgedWatermark != null && commitableWatermark.compareTo((Object)minUnacknowledgedWatermark) >= 0) continue;
            highestCommitableWatermark = commitableWatermark;
        }
        if (highestCommitableWatermark == null) {
            return Optional.absent();
        }
        return Optional.of(highestCommitableWatermark);
    }

    public Optional<CheckpointableWatermark> getUnacknowledgedWatermark(String source) {
        Set<CheckpointableWatermark> unacked = this.unacknowledgedWatermarks.get(source);
        if (unacked.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of((Object)unacked.iterator().next());
    }
}

