/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.executor.ExecutableFlowBase;
import azkaban.executor.ExecutionOptions;
import azkaban.executor.Status;
import azkaban.flow.Flow;
import azkaban.project.Project;
import azkaban.utils.TypedMapWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExecutableFlow
extends ExecutableFlowBase {
    public static final String EXECUTIONID_PARAM = "executionId";
    public static final String EXECUTIONPATH_PARAM = "executionPath";
    public static final String EXECUTIONOPTIONS_PARAM = "executionOptions";
    public static final String PROJECTID_PARAM = "projectId";
    public static final String SCHEDULEID_PARAM = "scheduleId";
    public static final String SUBMITUSER_PARAM = "submitUser";
    public static final String SUBMITTIME_PARAM = "submitTime";
    public static final String VERSION_PARAM = "version";
    public static final String PROXYUSERS_PARAM = "proxyUsers";
    private int executionId = -1;
    private int scheduleId = -1;
    private int projectId;
    private int version;
    private long submitTime = -1L;
    private String submitUser;
    private String executionPath;
    private HashSet<String> proxyUsers = new HashSet();
    private ExecutionOptions executionOptions;

    public ExecutableFlow(Project project, Flow flow) {
        this.projectId = project.getId();
        this.version = project.getVersion();
        this.scheduleId = -1;
        this.setFlow(project, flow);
    }

    public ExecutableFlow() {
    }

    @Override
    public String getId() {
        return this.getFlowId();
    }

    @Override
    public ExecutableFlow getExecutableFlow() {
        return this;
    }

    public void addAllProxyUsers(Collection<String> proxyUsers) {
        this.proxyUsers.addAll(proxyUsers);
    }

    public Set<String> getProxyUsers() {
        return new HashSet<String>(this.proxyUsers);
    }

    public void setExecutionOptions(ExecutionOptions options) {
        this.executionOptions = options;
    }

    public ExecutionOptions getExecutionOptions() {
        return this.executionOptions;
    }

    @Override
    protected void setFlow(Project project, Flow flow) {
        super.setFlow(project, flow);
        this.executionOptions = new ExecutionOptions();
        this.executionOptions.setMailCreator(flow.getMailCreator());
        if (flow.getSuccessEmails() != null) {
            this.executionOptions.setSuccessEmails(flow.getSuccessEmails());
        }
        if (flow.getFailureEmails() != null) {
            this.executionOptions.setFailureEmails(flow.getFailureEmails());
        }
    }

    @Override
    public int getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(int executionId) {
        this.executionId = executionId;
    }

    @Override
    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public int getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(int scheduleId) {
        this.scheduleId = scheduleId;
    }

    public String getExecutionPath() {
        return this.executionPath;
    }

    public void setExecutionPath(String executionPath) {
        this.executionPath = executionPath;
    }

    public String getSubmitUser() {
        return this.submitUser;
    }

    public void setSubmitUser(String submitUser) {
        this.submitUser = submitUser;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public long getSubmitTime() {
        return this.submitTime;
    }

    public void setSubmitTime(long submitTime) {
        this.submitTime = submitTime;
    }

    @Override
    public Map<String, Object> toObject() {
        HashMap<String, Object> flowObj = new HashMap<String, Object>();
        this.fillMapFromExecutable(flowObj);
        flowObj.put(EXECUTIONID_PARAM, this.executionId);
        flowObj.put(EXECUTIONPATH_PARAM, this.executionPath);
        flowObj.put(PROJECTID_PARAM, this.projectId);
        if (this.scheduleId >= 0) {
            flowObj.put(SCHEDULEID_PARAM, this.scheduleId);
        }
        flowObj.put(SUBMITUSER_PARAM, this.submitUser);
        flowObj.put(VERSION_PARAM, this.version);
        flowObj.put(EXECUTIONOPTIONS_PARAM, this.executionOptions.toObject());
        flowObj.put(VERSION_PARAM, this.version);
        ArrayList<String> proxyUserList = new ArrayList<String>(this.proxyUsers);
        flowObj.put(PROXYUSERS_PARAM, proxyUserList);
        flowObj.put(SUBMITTIME_PARAM, this.submitTime);
        return flowObj;
    }

    public static ExecutableFlow createExecutableFlowFromObject(Object obj) {
        ExecutableFlow exFlow = new ExecutableFlow();
        HashMap flowObj = (HashMap)obj;
        exFlow.fillExecutableFromMapObject(flowObj);
        return exFlow;
    }

    @Override
    public void fillExecutableFromMapObject(TypedMapWrapper<String, Object> flowObj) {
        super.fillExecutableFromMapObject(flowObj);
        this.executionId = flowObj.getInt(EXECUTIONID_PARAM);
        this.executionPath = flowObj.getString(EXECUTIONPATH_PARAM);
        this.projectId = flowObj.getInt(PROJECTID_PARAM);
        this.scheduleId = flowObj.getInt(SCHEDULEID_PARAM);
        this.submitUser = flowObj.getString(SUBMITUSER_PARAM);
        this.version = flowObj.getInt(VERSION_PARAM);
        this.submitTime = flowObj.getLong(SUBMITTIME_PARAM);
        this.executionOptions = flowObj.containsKey(EXECUTIONOPTIONS_PARAM) ? ExecutionOptions.createFromObject(flowObj.getObject(EXECUTIONOPTIONS_PARAM)) : ExecutionOptions.createFromObject(flowObj);
        if (flowObj.containsKey(PROXYUSERS_PARAM)) {
            List<String> proxyUserList = flowObj.getList(PROXYUSERS_PARAM);
            this.addAllProxyUsers(proxyUserList);
        }
    }

    @Override
    public Map<String, Object> toUpdateObject(long lastUpdateTime) {
        Map<String, Object> updateData = super.toUpdateObject(lastUpdateTime);
        updateData.put(EXECUTIONID_PARAM, this.executionId);
        return updateData;
    }

    @Override
    public void resetForRetry() {
        super.resetForRetry();
        this.setStatus(Status.RUNNING);
    }
}

