/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.api.config;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectReader;
import org.codehaus.jackson.map.ObjectWriter;

public class StateTransitionThrottleConfig {
    private static final Logger logger = Logger.getLogger((String)StateTransitionThrottleConfig.class.getName());
    RebalanceType _rebalanceType;
    ThrottleScope _throttleScope;
    Long _maxPartitionInTransition;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public StateTransitionThrottleConfig(RebalanceType rebalanceType, ThrottleScope throttleScope, long maxPartitionInTransition) {
        this._rebalanceType = rebalanceType;
        this._throttleScope = throttleScope;
        this._maxPartitionInTransition = maxPartitionInTransition;
    }

    public RebalanceType getRebalanceType() {
        return this._rebalanceType;
    }

    public ThrottleScope getThrottleScope() {
        return this._throttleScope;
    }

    public Long getMaxPartitionInTransition() {
        return this._maxPartitionInTransition;
    }

    public String toJSON() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put(ConfigProperty.REBALANCE_TYPE.name(), this._rebalanceType.name());
        configMap.put(ConfigProperty.THROTTLE_SCOPE.name(), this._throttleScope.name());
        configMap.put(ConfigProperty.MAX_PARTITION_IN_TRANSITION.name(), String.valueOf(this._maxPartitionInTransition));
        String jsonStr = null;
        try {
            ObjectWriter objectWriter = OBJECT_MAPPER.writer();
            jsonStr = objectWriter.writeValueAsString(configMap);
        }
        catch (IOException e) {
            logger.error((Object)("Failed to convert config map to JSON object! " + configMap));
        }
        return jsonStr;
    }

    public static StateTransitionThrottleConfig fromJSON(String configJsonStr) {
        StateTransitionThrottleConfig throttleConfig = null;
        try {
            ObjectReader objectReader = OBJECT_MAPPER.reader(Map.class);
            Map configsMap = (Map)objectReader.readValue(configJsonStr);
            throttleConfig = StateTransitionThrottleConfig.fromConfigMap(configsMap);
        }
        catch (IOException e) {
            logger.error((Object)("Failed to convert JSON string to config map! " + configJsonStr));
        }
        return throttleConfig;
    }

    public static StateTransitionThrottleConfig fromConfigMap(Map<String, String> configsMap) {
        StateTransitionThrottleConfig config;
        if (!configsMap.containsKey(ConfigProperty.REBALANCE_TYPE.name()) || !configsMap.containsKey(ConfigProperty.THROTTLE_SCOPE.name())) {
            return null;
        }
        try {
            RebalanceType rebalanceType = RebalanceType.valueOf(configsMap.get(ConfigProperty.REBALANCE_TYPE.name()));
            ThrottleScope throttleScope = ThrottleScope.valueOf(configsMap.get(ConfigProperty.THROTTLE_SCOPE.name()));
            Long maxPartition = Long.valueOf(configsMap.get(ConfigProperty.MAX_PARTITION_IN_TRANSITION.name()));
            config = new StateTransitionThrottleConfig(rebalanceType, throttleScope, maxPartition);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        return config;
    }

    public static enum RebalanceType {
        LOAD_BALANCE,
        RECOVERY_BALANCE;

    }

    public static enum ThrottleScope {
        CLUSTER,
        RESOURCE,
        INSTANCE;

    }

    private static enum ConfigProperty {
        CONFIG_TYPE,
        REBALANCE_TYPE,
        THROTTLE_SCOPE,
        MAX_PARTITION_IN_TRANSITION;

    }
}

