/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.controller.rebalancer.Rebalancer;
import org.apache.helix.controller.rebalancer.internal.MappingCalculator;
import org.apache.helix.controller.rebalancer.strategy.AutoRebalanceStrategy;
import org.apache.helix.controller.rebalancer.strategy.RebalanceStrategy;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.util.HelixUtil;
import org.apache.log4j.Logger;

public abstract class AbstractRebalancer
implements Rebalancer,
MappingCalculator {
    protected HelixManager _manager;
    protected RebalanceStrategy _rebalanceStrategy;
    private static final Logger LOG = Logger.getLogger(AbstractRebalancer.class);

    @Override
    public void init(HelixManager manager) {
        this._manager = manager;
        this._rebalanceStrategy = null;
    }

    @Override
    public abstract IdealState computeNewIdealState(String var1, IdealState var2, CurrentStateOutput var3, ClusterDataCache var4);

    @Override
    public ResourceAssignment computeBestPossiblePartitionState(ClusterDataCache cache, IdealState idealState, Resource resource, CurrentStateOutput currentStateOutput) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing resource:" + resource.getResourceName()));
        }
        String stateModelDefName = idealState.getStateModelDefRef();
        StateModelDefinition stateModelDef = cache.getStateModelDef(stateModelDefName);
        ResourceAssignment partitionMapping = new ResourceAssignment(resource.getResourceName());
        for (Partition partition : resource.getPartitions()) {
            Map<String, String> currentStateMap = currentStateOutput.getCurrentStateMap(resource.getResourceName(), partition);
            Set<String> disabledInstancesForPartition = cache.getDisabledInstancesForPartition(resource.getResourceName(), partition.toString());
            List<String> preferenceList = AbstractRebalancer.getPreferenceList(partition, idealState, Collections.unmodifiableSet(cache.getLiveInstances().keySet()));
            Map<String, String> bestStateForPartition = this.computeAutoBestStateForPartition(cache, stateModelDef, preferenceList, currentStateMap, disabledInstancesForPartition, idealState.isEnabled());
            partitionMapping.addReplicaMap(partition, bestStateForPartition);
        }
        return partitionMapping;
    }

    protected Map<String, Map<String, String>> currentMapping(CurrentStateOutput currentStateOutput, String resourceName, List<String> partitions, Map<String, Integer> stateCountMap) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        for (String partition : partitions) {
            Map<String, String> curStateMap = currentStateOutput.getCurrentStateMap(resourceName, new Partition(partition));
            map.put(partition, new HashMap());
            for (String node : curStateMap.keySet()) {
                String state = curStateMap.get(node);
                ((Map)map.get(partition)).put(node, state);
            }
            Map<String, String> pendingStateMap = currentStateOutput.getPendingStateMap(resourceName, new Partition(partition));
            for (String node : pendingStateMap.keySet()) {
                String state = pendingStateMap.get(node);
                ((Map)map.get(partition)).put(node, state);
            }
        }
        return map;
    }

    protected RebalanceStrategy getRebalanceStrategy(String rebalanceStrategyName, List<String> partitions, String resourceName, LinkedHashMap<String, Integer> stateCountMap, int maxPartition) {
        RebalanceStrategy rebalanceStrategy;
        if (rebalanceStrategyName == null || rebalanceStrategyName.equalsIgnoreCase("DEFAULT")) {
            rebalanceStrategy = new AutoRebalanceStrategy(resourceName, partitions, stateCountMap, maxPartition);
        } else {
            try {
                rebalanceStrategy = (RebalanceStrategy)RebalanceStrategy.class.cast(HelixUtil.loadClass(this.getClass(), rebalanceStrategyName).newInstance());
                rebalanceStrategy.init(resourceName, partitions, stateCountMap, maxPartition);
            }
            catch (ClassNotFoundException ex) {
                throw new HelixException("Exception while invoking custom rebalance strategy class: " + rebalanceStrategyName, ex);
            }
            catch (InstantiationException ex) {
                throw new HelixException("Exception while invoking custom rebalance strategy class: " + rebalanceStrategyName, ex);
            }
            catch (IllegalAccessException ex) {
                throw new HelixException("Exception while invoking custom rebalance strategy class: " + rebalanceStrategyName, ex);
            }
        }
        return rebalanceStrategy;
    }

    public Map<String, String> computeAutoBestStateForPartition(ClusterDataCache cache, StateModelDefinition stateModelDef, List<String> instancePreferenceList, Map<String, String> currentStateMap, Set<String> disabledInstancesForPartition, boolean isResourceEnabled) {
        HashMap<String, String> instanceStateMap = new HashMap<String, String>();
        if (currentStateMap != null) {
            for (String instance : currentStateMap.keySet()) {
                if (instancePreferenceList == null || !instancePreferenceList.contains(instance)) {
                    instanceStateMap.put(instance, HelixDefinedState.DROPPED.toString());
                    continue;
                }
                if (!disabledInstancesForPartition.contains(instance) && isResourceEnabled || currentStateMap.get(instance) != null && currentStateMap.get(instance).equals(HelixDefinedState.ERROR.name())) continue;
                instanceStateMap.put(instance, stateModelDef.getInitialState());
            }
        }
        if (instancePreferenceList == null) {
            return instanceStateMap;
        }
        List<String> statesPriorityList = stateModelDef.getStatesPriorityList();
        boolean[] assigned = new boolean[instancePreferenceList.size()];
        Map<String, LiveInstance> liveInstancesMap = cache.getLiveInstances();
        block3: for (String state : statesPriorityList) {
            String num = stateModelDef.getNumInstancesPerState(state);
            int stateCount = -1;
            if ("N".equals(num)) {
                HashSet<String> liveAndEnabled = new HashSet<String>(liveInstancesMap.keySet());
                liveAndEnabled.removeAll(disabledInstancesForPartition);
                stateCount = isResourceEnabled ? liveAndEnabled.size() : 0;
            } else if ("R".equals(num)) {
                stateCount = instancePreferenceList.size();
            } else {
                try {
                    stateCount = Integer.parseInt(num);
                }
                catch (Exception e) {
                    LOG.error((Object)("Invalid count for state:" + state + " ,count=" + num));
                }
            }
            if (stateCount <= -1) continue;
            int count = 0;
            for (int i = 0; i < instancePreferenceList.size(); ++i) {
                boolean enabled;
                String instanceName = instancePreferenceList.get(i);
                boolean notInErrorState = currentStateMap == null || currentStateMap.get(instanceName) == null || !currentStateMap.get(instanceName).equals(HelixDefinedState.ERROR.toString());
                boolean bl = enabled = !disabledInstancesForPartition.contains(instanceName) && isResourceEnabled;
                if (!liveInstancesMap.containsKey(instanceName) || assigned[i] || !notInErrorState || !enabled) continue;
                instanceStateMap.put(instanceName, state);
                assigned[i] = true;
                if (++count == stateCount) continue block3;
            }
        }
        return instanceStateMap;
    }

    public static List<String> getPreferenceList(Partition partition, IdealState idealState, Set<String> eligibleInstances) {
        List<String> listField = idealState.getPreferenceList(partition.getPartitionName());
        if (listField != null && listField.size() == 1 && IdealState.IdealStateConstants.ANY_LIVEINSTANCE.toString().equals(listField.get(0))) {
            ArrayList<String> prefList = new ArrayList<String>(eligibleInstances);
            Collections.sort(prefList);
            return prefList;
        }
        return listField;
    }
}

