/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.I0Itec.zkclient.DataUpdater;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.ZNRecord;
import org.apache.helix.controller.common.PartitionStateMap;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.BestPossibleStateOutput;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.IntermediateStateOutput;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.log4j.Logger;

public class PersistAssignmentStage
extends AbstractBaseStage {
    private static final Logger LOG = Logger.getLogger(PersistAssignmentStage.class);

    @Override
    public void process(ClusterEvent event) throws Exception {
        LOG.info((Object)"START PersistAssignmentStage.process()");
        long startTime = System.currentTimeMillis();
        ClusterDataCache cache = (ClusterDataCache)event.getAttribute("ClusterDataCache");
        ClusterConfig clusterConfig = cache.getClusterConfig();
        if (!clusterConfig.isPersistBestPossibleAssignment().booleanValue() && !clusterConfig.isPersistIntermediateAssignment().booleanValue()) {
            return;
        }
        BestPossibleStateOutput bestPossibleAssignment = (BestPossibleStateOutput)event.getAttribute(AttributeName.BEST_POSSIBLE_STATE.name());
        HelixManager helixManager = (HelixManager)event.getAttribute("helixmanager");
        HelixDataAccessor accessor = helixManager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES.name());
        for (String resourceId : bestPossibleAssignment.resourceSet()) {
            Map<Partition, Map<String, String>> assignmentToPersist;
            Map<String, List<String>> newLists;
            Resource resource = (Resource)resourceMap.get(resourceId);
            if (resource == null) continue;
            final IdealState idealState = cache.getIdealState(resourceId);
            if (idealState == null) {
                LOG.warn((Object)("IdealState not found for resource " + resourceId));
                continue;
            }
            IdealState.RebalanceMode mode = idealState.getRebalanceMode();
            if (!mode.equals((Object)IdealState.RebalanceMode.SEMI_AUTO) && !mode.equals((Object)IdealState.RebalanceMode.FULL_AUTO)) continue;
            boolean needPersist = false;
            if (mode.equals((Object)IdealState.RebalanceMode.FULL_AUTO) && (newLists = bestPossibleAssignment.getPreferenceLists(resourceId)) != null && this.hasPreferenceListChanged(newLists, idealState)) {
                idealState.setPreferenceLists(newLists);
                needPersist = true;
            }
            PartitionStateMap partitionStateMap = bestPossibleAssignment.getPartitionStateMap(resourceId);
            if (clusterConfig.isPersistIntermediateAssignment().booleanValue()) {
                IntermediateStateOutput intermediateAssignment = (IntermediateStateOutput)event.getAttribute(AttributeName.INTERMEDIATE_STATE.name());
                partitionStateMap = intermediateAssignment.getPartitionStateMap(resourceId);
            }
            if ((assignmentToPersist = partitionStateMap.getStateMap()) != null && this.hasInstanceMapChanged(assignmentToPersist, idealState)) {
                for (Partition partition : assignmentToPersist.keySet()) {
                    Map<String, String> instanceMap = assignmentToPersist.get(partition);
                    idealState.setInstanceStateMap(partition.getPartitionName(), instanceMap);
                }
                needPersist = true;
            }
            if (!needPersist) continue;
            accessor.updateProperty(keyBuilder.idealStates(resourceId), new DataUpdater<ZNRecord>(){

                public ZNRecord update(ZNRecord current) {
                    if (current != null) {
                        current.getMapFields().putAll(idealState.getRecord().getMapFields());
                        current.getListFields().putAll(idealState.getRecord().getListFields());
                    }
                    return current;
                }
            }, idealState);
        }
        long endTime = System.currentTimeMillis();
        LOG.info((Object)("END PersistAssignmentStage.process() took " + (endTime - startTime) + " ms"));
    }

    private boolean hasPreferenceListChanged(Map<String, List<String>> newLists, IdealState idealState) {
        Map<String, List<String>> existLists = idealState.getPreferenceLists();
        HashSet<String> partitions = new HashSet<String>(newLists.keySet());
        partitions.addAll(existLists.keySet());
        for (String partition : partitions) {
            List<String> assignedInstances = newLists.get(partition);
            List<String> existingInstances = existLists.get(partition);
            if (assignedInstances == null && existingInstances == null || assignedInstances != null && existingInstances != null && assignedInstances.equals(existingInstances)) continue;
            return true;
        }
        return false;
    }

    private boolean hasInstanceMapChanged(Map<Partition, Map<String, String>> newAssiments, IdealState idealState) {
        HashSet<Partition> partitions = new HashSet<Partition>(newAssiments.keySet());
        for (String p : idealState.getPartitionSet()) {
            partitions.add(new Partition(p));
        }
        for (Partition partition : partitions) {
            Map<String, String> instanceMap = newAssiments.get(partition);
            Map<String, String> existInstanceMap = idealState.getInstanceStateMap(partition.getPartitionName());
            if (instanceMap == null && existInstanceMap == null || instanceMap != null && existInstanceMap != null && instanceMap.equals(existInstanceMap)) continue;
            return true;
        }
        return false;
    }
}

