/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.messaging.handling;

import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixRollbackException;
import org.apache.helix.InstanceType;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.messaging.handling.HelixTaskExecutor;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.messaging.handling.MessageTask;
import org.apache.helix.model.Message;
import org.apache.helix.monitoring.StateTransitionContext;
import org.apache.helix.monitoring.StateTransitionDataPoint;
import org.apache.helix.monitoring.mbeans.ParticipantMessageMonitor;
import org.apache.helix.util.StatusUpdateUtil;
import org.apache.log4j.Logger;

public class HelixTask
implements MessageTask {
    private static Logger logger = Logger.getLogger(HelixTask.class);
    private final Message _message;
    private final MessageHandler _handler;
    private final NotificationContext _notificationContext;
    private final HelixManager _manager;
    StatusUpdateUtil _statusUpdateUtil;
    HelixTaskExecutor _executor;
    volatile boolean _isTimeout = false;
    volatile boolean _isStarted = false;
    volatile boolean _isCancelled = false;

    public HelixTask(Message message, NotificationContext notificationContext, MessageHandler handler, HelixTaskExecutor executor) {
        this._notificationContext = notificationContext;
        this._message = message;
        this._handler = handler;
        this._manager = notificationContext.getManager();
        this._statusUpdateUtil = new StatusUpdateUtil();
        this._executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HelixTaskResult call() {
        HelixTaskResult taskResult = null;
        MessageHandler.ErrorType type = null;
        MessageHandler.ErrorCode code = null;
        long start = System.currentTimeMillis();
        logger.info((Object)("handling task: " + this.getTaskId() + " begin, at: " + start));
        HelixDataAccessor accessor = this._manager.getHelixDataAccessor();
        this._statusUpdateUtil.logInfo(this._message, HelixTask.class, "Message handling task begin execute", accessor);
        this._message.setExecuteStartTimeStamp(new Date().getTime());
        if (this._message.getBatchMessageMode()) {
            this._notificationContext.add(NotificationContext.MapKey.CURRENT_STATE_UPDATE.toString(), new ConcurrentHashMap());
        }
        try {
            this.setStarted();
            taskResult = this._handler.handleMessage();
        }
        catch (InterruptedException e) {
            taskResult = new HelixTaskResult();
            taskResult.setException(e);
            taskResult.setInterrupted(true);
            this._statusUpdateUtil.logError(this._message, HelixTask.class, e, "State transition interrupted, timeout:" + this._isTimeout, accessor);
            logger.info((Object)("Message " + this._message.getMsgId() + " is interrupted"));
        }
        catch (Exception e) {
            taskResult = new HelixTaskResult();
            taskResult.setException(e);
            taskResult.setMessage(e.getMessage());
            String errorMessage = "Exception while executing a message. " + e + " msgId: " + this._message.getMsgId() + " type: " + this._message.getMsgType();
            logger.error((Object)errorMessage, (Throwable)e);
            this._statusUpdateUtil.logError(this._message, HelixTask.class, e, errorMessage, accessor);
            this._executor.getParticipantMonitor().reportProcessedMessage(this._message, ParticipantMessageMonitor.ProcessedMessageState.FAILED);
        }
        this._executor.cancelTimeoutTask(this);
        Exception exception = null;
        try {
            if (taskResult.isSuccess()) {
                this._statusUpdateUtil.logInfo(this._message, this._handler.getClass(), "Message handling task completed successfully", accessor);
                logger.info((Object)("Message " + this._message.getMsgId() + " completed."));
                this._executor.getParticipantMonitor().reportProcessedMessage(this._message, ParticipantMessageMonitor.ProcessedMessageState.COMPLETED);
            } else {
                type = MessageHandler.ErrorType.INTERNAL;
                if (taskResult.isInterrupted()) {
                    logger.info((Object)("Message " + this._message.getMsgId() + " is interrupted"));
                    MessageHandler.ErrorCode errorCode = code = this._isTimeout ? MessageHandler.ErrorCode.TIMEOUT : MessageHandler.ErrorCode.CANCEL;
                    if (this._isTimeout) {
                        int retryCount = this._message.getRetryCount();
                        logger.info((Object)("Message timeout, retry count: " + retryCount + " msgId:" + this._message.getMsgId()));
                        this._statusUpdateUtil.logInfo(this._message, this._handler.getClass(), "Message handling task timeout, retryCount:" + retryCount, accessor);
                        if (retryCount > 0) {
                            this._message.setRetryCount(retryCount - 1);
                            HelixTask task = new HelixTask(this._message, this._notificationContext, this._handler, this._executor);
                            this._executor.scheduleTask(task);
                            HelixTaskResult helixTaskResult = taskResult;
                            return helixTaskResult;
                        }
                    }
                } else if (taskResult.isCancelled()) {
                    type = null;
                    this._statusUpdateUtil.logInfo(this._message, this._handler.getClass(), "Cancellation completed successfully", accessor);
                    this._executor.getParticipantMonitor().reportProcessedMessage(this._message, ParticipantMessageMonitor.ProcessedMessageState.COMPLETED);
                } else {
                    code = MessageHandler.ErrorCode.ERROR;
                    String errorMsg = "Message execution failed. msgId: " + this.getTaskId() + ", errorMsg: " + taskResult.getMessage();
                    logger.error((Object)errorMsg);
                    this._statusUpdateUtil.logError(this._message, this._handler.getClass(), errorMsg, accessor);
                }
                this._executor.getParticipantMonitor().reportProcessedMessage(this._message, ParticipantMessageMonitor.ProcessedMessageState.FAILED);
            }
            if (this._message.getAttribute(Message.Attributes.PARENT_MSG_ID) == null) {
                this.removeMessageFromZk(accessor, this._message);
                this.reportMessageStat(this._manager, this._message, taskResult);
                this.sendReply(accessor, this._message, taskResult);
                this._executor.finishTask(this);
            }
        }
        catch (Exception e) {
            exception = e;
            type = MessageHandler.ErrorType.FRAMEWORK;
            code = MessageHandler.ErrorCode.ERROR;
            String errorMessage = "Exception after executing a message, msgId: " + this._message.getMsgId() + e;
            logger.error((Object)errorMessage, (Throwable)e);
            this._statusUpdateUtil.logError(this._message, HelixTask.class, errorMessage, accessor);
            this._executor.getParticipantMonitor().reportProcessedMessage(this._message, ParticipantMessageMonitor.ProcessedMessageState.FAILED);
        }
        finally {
            long end = System.currentTimeMillis();
            logger.info((Object)("msg: " + this._message.getMsgId() + " handling task completed, results:" + taskResult.isSuccess() + ", at: " + end + ", took:" + (end - start)));
            if (type == MessageHandler.ErrorType.INTERNAL) {
                this._handler.onError(taskResult.getException(), code, type);
            } else if (type == MessageHandler.ErrorType.FRAMEWORK) {
                this._handler.onError(exception, code, type);
            }
        }
        return taskResult;
    }

    private void removeMessageFromZk(HelixDataAccessor accessor, Message message) {
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        if (message.getTgtName().equalsIgnoreCase("controller")) {
            accessor.removeProperty(keyBuilder.controllerMessage(message.getMsgId()));
        } else {
            accessor.removeProperty(keyBuilder.message(this._manager.getInstanceName(), message.getMsgId()));
        }
    }

    private void sendReply(HelixDataAccessor accessor, Message message, HelixTaskResult taskResult) {
        if (this._message.getCorrelationId() != null && !message.getMsgType().equals(Message.MessageType.TASK_REPLY.name())) {
            logger.info((Object)("Sending reply for message " + message.getCorrelationId()));
            this._statusUpdateUtil.logInfo(message, HelixTask.class, "Sending reply", accessor);
            taskResult.getTaskResultMap().put("SUCCESS", "" + taskResult.isSuccess());
            taskResult.getTaskResultMap().put("INTERRUPTED", "" + taskResult.isInterrupted());
            if (!taskResult.isSuccess()) {
                taskResult.getTaskResultMap().put("ERRORINFO", taskResult.getMessage());
            }
            Message replyMessage = Message.createReplyMessage(this._message, this._manager.getInstanceName(), taskResult.getTaskResultMap());
            replyMessage.setSrcInstanceType(this._manager.getInstanceType());
            if (message.getSrcInstanceType() == InstanceType.PARTICIPANT) {
                PropertyKey.Builder keyBuilder = accessor.keyBuilder();
                accessor.setProperty(keyBuilder.message(message.getMsgSrc(), replyMessage.getMsgId()), replyMessage);
            } else if (message.getSrcInstanceType() == InstanceType.CONTROLLER) {
                PropertyKey.Builder keyBuilder = accessor.keyBuilder();
                accessor.setProperty(keyBuilder.controllerMessage(replyMessage.getMsgId()), replyMessage);
            }
            this._statusUpdateUtil.logInfo(message, HelixTask.class, "1 msg replied to " + replyMessage.getTgtName(), accessor);
        }
    }

    private void reportMessageStat(HelixManager manager, Message message, HelixTaskResult taskResult) {
        if (!message.getMsgType().equals(Message.MessageType.STATE_TRANSITION.name())) {
            return;
        }
        long now = new Date().getTime();
        long msgReadTime = message.getReadTimeStamp();
        long msgExecutionStartTime = message.getExecuteStartTimeStamp();
        if (msgReadTime != 0L && msgExecutionStartTime != 0L) {
            long totalDelay = now - msgReadTime;
            long executionDelay = now - msgExecutionStartTime;
            if (totalDelay > 0L && executionDelay > 0L) {
                String fromState = message.getFromState();
                String toState = message.getToState();
                String transition = fromState + "--" + toState;
                StateTransitionContext cxt = new StateTransitionContext(manager.getClusterName(), manager.getInstanceName(), message.getResourceName(), transition);
                StateTransitionDataPoint data = new StateTransitionDataPoint(totalDelay, executionDelay, taskResult.isSuccess());
                this._executor.getParticipantMonitor().reportTransitionStat(cxt, data);
            }
        } else {
            logger.warn((Object)"message read time and start execution time not recorded.");
        }
    }

    @Override
    public String getTaskId() {
        return this._message.getId();
    }

    @Override
    public Message getMessage() {
        return this._message;
    }

    @Override
    public NotificationContext getNotificationContext() {
        return this._notificationContext;
    }

    @Override
    public void onTimeout() {
        this._isTimeout = true;
        this._handler.onTimeout();
    }

    @Override
    public synchronized boolean cancel() {
        if (!this._isStarted) {
            this._isCancelled = true;
            this._handler.cancel();
            return true;
        }
        return false;
    }

    private synchronized void setStarted() {
        if (this._isCancelled) {
            throw new HelixRollbackException("Task has already been cancelled");
        }
        this._isStarted = true;
    }
}

