/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import org.apache.helix.monitoring.mbeans.ParticipantMessageMonitorMBean;

public class ParticipantMessageMonitor
implements ParticipantMessageMonitorMBean {
    private static final String PARTICIPANT_KEY = "ParticipantName";
    private static final String PARTICIPANT_STATUS_KEY = "ParticipantMessageStatus";
    private final String _participantName;
    private long _receivedMessages = 0L;
    private long _discardedMessages = 0L;
    private long _completedMessages = 0L;
    private long _failedMessages = 0L;
    private long _pendingMessages = 0L;

    public ParticipantMessageMonitor(String participantName) {
        this._participantName = participantName;
    }

    public String getParticipantBeanName() {
        return String.format("%s=%s", PARTICIPANT_KEY, this._participantName);
    }

    public void incrementReceivedMessages(int count) {
        this._receivedMessages += (long)count;
    }

    public void incrementDiscardedMessages(int count) {
        this._discardedMessages += (long)count;
    }

    public void incrementCompletedMessages(int count) {
        this._completedMessages += (long)count;
    }

    public void incrementFailedMessages(int count) {
        this._failedMessages += (long)count;
    }

    public void incrementPendingMessages(int count) {
        this._pendingMessages += (long)count;
    }

    public void decrementPendingMessages(int count) {
        this._pendingMessages -= (long)count;
    }

    @Override
    public long getReceivedMessages() {
        return this._receivedMessages;
    }

    @Override
    public long getDiscardedMessages() {
        return this._discardedMessages;
    }

    @Override
    public long getCompletedMessages() {
        return this._completedMessages;
    }

    @Override
    public long getFailedMessages() {
        return this._failedMessages;
    }

    @Override
    public long getPendingMessages() {
        return this._pendingMessages;
    }

    @Override
    public String getSensorName() {
        return "ParticipantMessageStatus._participantName";
    }

    public static enum ProcessedMessageState {
        DISCARDED,
        FAILED,
        COMPLETED;

    }
}

