/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.I0Itec.zkclient.DataUpdater;
import org.apache.helix.AccessOption;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyPathBuilder;
import org.apache.helix.ZNRecord;
import org.apache.helix.controller.rebalancer.util.RebalanceScheduler;
import org.apache.helix.manager.zk.ZKHelixAdmin;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.builder.CustomModeISBuilder;
import org.apache.helix.store.HelixPropertyStore;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.JobDag;
import org.apache.helix.task.JobQueue;
import org.apache.helix.task.TargetState;
import org.apache.helix.task.TaskState;
import org.apache.helix.task.TaskUtil;
import org.apache.helix.task.Workflow;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.apache.helix.task.WorkflowRebalancer;
import org.apache.log4j.Logger;

public class TaskDriver {
    private static final Logger LOG = Logger.getLogger(TaskDriver.class);
    private static final int _defaultTimeout = 180000;
    private final HelixDataAccessor _accessor;
    private final HelixPropertyStore<ZNRecord> _propertyStore;
    private final HelixAdmin _admin;
    private final String _clusterName;

    public TaskDriver(HelixManager manager) {
        this(manager.getClusterManagmentTool(), manager.getHelixDataAccessor(), manager.getHelixPropertyStore(), manager.getClusterName());
    }

    public TaskDriver(ZkClient client, String clusterName) {
        this(client, new ZkBaseDataAccessor<ZNRecord>(client), clusterName);
    }

    public TaskDriver(ZkClient client, ZkBaseDataAccessor<ZNRecord> baseAccessor, String clusterName) {
        this(new ZKHelixAdmin(client), new ZKHelixDataAccessor(clusterName, baseAccessor), new ZkHelixPropertyStore<ZNRecord>(baseAccessor, PropertyPathBuilder.propertyStore(clusterName), null), clusterName);
    }

    @Deprecated
    public TaskDriver(HelixAdmin admin, HelixDataAccessor accessor, ConfigAccessor cfgAccessor, HelixPropertyStore<ZNRecord> propertyStore, String clusterName) {
        this(admin, accessor, propertyStore, clusterName);
    }

    public TaskDriver(HelixAdmin admin, HelixDataAccessor accessor, HelixPropertyStore<ZNRecord> propertyStore, String clusterName) {
        this._admin = admin;
        this._accessor = accessor;
        this._propertyStore = propertyStore;
        this._clusterName = clusterName;
    }

    public void start(Workflow flow) {
        LOG.info((Object)("Starting workflow " + flow.getName()));
        flow.validate();
        WorkflowConfig newWorkflowConfig = new WorkflowConfig.Builder(flow.getWorkflowConfig()).setWorkflowId(flow.getName()).build();
        HashMap<String, String> jobTypes = new HashMap<String, String>();
        for (String job : flow.getJobConfigs().keySet()) {
            JobConfig jobCfg;
            JobConfig.Builder jobCfgBuilder = JobConfig.Builder.fromMap(flow.getJobConfigs().get(job));
            if (flow.getTaskConfigs() != null && flow.getTaskConfigs().containsKey(job)) {
                jobCfgBuilder.addTaskConfigs(flow.getTaskConfigs().get(job));
            }
            if ((jobCfg = jobCfgBuilder.build()).getJobType() != null) {
                jobTypes.put(job, jobCfg.getJobType());
            }
            this.addJobConfig(job, jobCfg);
        }
        newWorkflowConfig.setJobTypes(jobTypes);
        if (!TaskUtil.setWorkflowConfig(this._accessor, flow.getName(), newWorkflowConfig)) {
            LOG.error((Object)("Failed to add workflow configuration for workflow " + flow.getName()));
        }
        this.addWorkflowResource(flow.getName());
    }

    public void updateWorkflow(String workflow, WorkflowConfig newWorkflowConfig) {
        WorkflowConfig currentConfig = TaskUtil.getWorkflowConfig(this._accessor, workflow);
        if (currentConfig == null) {
            throw new HelixException("Workflow " + workflow + " does not exist!");
        }
        if (currentConfig.isTerminable()) {
            throw new HelixException("Workflow " + workflow + " is terminable, not allow to change its configuration!");
        }
        newWorkflowConfig.setJobDag(currentConfig.getJobDag());
        if (!TaskUtil.setWorkflowConfig(this._accessor, workflow, newWorkflowConfig)) {
            LOG.error((Object)("Failed to update workflow configuration for workflow " + workflow));
        }
        RebalanceScheduler.invokeRebalance(this._accessor, workflow);
    }

    public void createQueue(JobQueue queue) {
        this.start(queue);
    }

    public void flushQueue(String queue) {
        this.cleanupQueue(queue);
    }

    public void deleteJob(String queue, String job) {
        boolean isRecurringWorkflow;
        WorkflowConfig workflowCfg = TaskUtil.getWorkflowConfig(this._accessor, queue);
        if (workflowCfg == null) {
            throw new IllegalArgumentException("Queue " + queue + " does not yet exist!");
        }
        if (workflowCfg.isTerminable()) {
            throw new IllegalArgumentException(queue + " is not a queue!");
        }
        boolean bl = isRecurringWorkflow = workflowCfg.getScheduleConfig() != null && workflowCfg.getScheduleConfig().isRecurring();
        if (isRecurringWorkflow) {
            WorkflowConfig lastWorkflowCfg;
            WorkflowContext wCtx = TaskUtil.getWorkflowContext(this._propertyStore, queue);
            String lastScheduledQueue = null;
            if (wCtx != null) {
                lastScheduledQueue = wCtx.getLastScheduledSingleWorkflow();
            }
            if (lastScheduledQueue != null && (lastWorkflowCfg = TaskUtil.getWorkflowConfig(this._accessor, lastScheduledQueue)) != null) {
                this.deleteJobFromQueue(lastScheduledQueue, job);
            }
        }
        this.deleteJobFromQueue(queue, job);
    }

    private void deleteJobFromQueue(String queue, String job) {
        String workflowState;
        WorkflowContext workflowCtx = TaskUtil.getWorkflowContext(this._propertyStore, queue);
        String string = workflowState = workflowCtx != null ? workflowCtx.getWorkflowState().name() : TaskState.NOT_STARTED.name();
        if (workflowState.equals(TaskState.IN_PROGRESS.name())) {
            throw new IllegalStateException("Queue " + queue + " is still running!");
        }
        if (workflowState.equals(TaskState.COMPLETED.name()) || workflowState.equals(TaskState.FAILED.name()) || workflowState.equals(TaskState.ABORTED.name())) {
            LOG.warn((Object)("Queue " + queue + " has already reached its final state, skip deleting job from it."));
            return;
        }
        String namespacedJobName = TaskUtil.getNamespacedJobName(queue, job);
        HashSet<String> jobs = new HashSet<String>(Arrays.asList(namespacedJobName));
        if (!TaskUtil.removeJobsFromWorkflow(this._accessor, this._propertyStore, queue, jobs, true)) {
            LOG.error((Object)("Failed to delete job " + job + " from queue " + queue));
            throw new HelixException("Failed to delete job " + job + " from queue " + queue);
        }
    }

    public void enqueueJob(final String queue, final String job, JobConfig.Builder jobBuilder) {
        WorkflowConfig workflowConfig = TaskUtil.getWorkflowConfig(this._accessor, queue);
        if (workflowConfig == null) {
            throw new IllegalArgumentException("Queue " + queue + " config does not yet exist!");
        }
        if (workflowConfig.isTerminable()) {
            throw new IllegalArgumentException(queue + " is not a queue!");
        }
        final int capacity = workflowConfig.getCapacity();
        int queueSize = workflowConfig.getJobDag().size();
        if (capacity > 0 && queueSize >= capacity) {
            Set<String> expiredJobs;
            WorkflowContext workflowContext = TaskUtil.getWorkflowContext(this._propertyStore, queue);
            if (workflowContext != null && !TaskUtil.removeJobsFromWorkflow(this._accessor, this._propertyStore, queue, expiredJobs = TaskUtil.getExpiredJobs(this._accessor, this._propertyStore, workflowConfig, workflowContext), true)) {
                LOG.warn((Object)("Failed to clean up expired and completed jobs from queue " + queue));
            }
            if ((workflowConfig = TaskUtil.getWorkflowConfig(this._accessor, queue)).getJobDag().size() >= capacity) {
                throw new HelixException("Failed to enqueue a job, queue is full.");
            }
        }
        JobConfig jobConfig = jobBuilder.setWorkflow(queue).build();
        final String namespacedJobName = TaskUtil.getNamespacedJobName(queue, job);
        this.addJobConfig(namespacedJobName, jobConfig);
        final String jobType = jobConfig.getJobType();
        DataUpdater<ZNRecord> updater = new DataUpdater<ZNRecord>(){

            public ZNRecord update(ZNRecord currentData) {
                JobDag jobDag = JobDag.fromJson(currentData.getSimpleField(WorkflowConfig.WorkflowConfigProperty.Dag.name()));
                Set<String> allNodes = jobDag.getAllNodes();
                if (capacity > 0 && allNodes.size() >= capacity) {
                    throw new IllegalStateException("Queue " + queue + " already reaches its max capacity, failed to add " + job);
                }
                if (allNodes.contains(namespacedJobName)) {
                    throw new IllegalStateException("Could not add to queue " + queue + ", job " + job + " already exists");
                }
                jobDag.addNode(namespacedJobName);
                String candidate = null;
                for (String node : allNodes) {
                    if (node.equals(namespacedJobName) || !jobDag.getDirectChildren(node).isEmpty()) continue;
                    candidate = node;
                    break;
                }
                if (candidate != null) {
                    jobDag.addParentToChild(candidate, namespacedJobName);
                }
                if (jobType != null) {
                    Map<String, String> jobTypes = currentData.getMapField(WorkflowConfig.WorkflowConfigProperty.JobTypes.name());
                    if (jobTypes == null) {
                        jobTypes = new HashMap<String, String>();
                    }
                    jobTypes.put(queue, jobType);
                    currentData.setMapField(WorkflowConfig.WorkflowConfigProperty.JobTypes.name(), jobTypes);
                }
                try {
                    currentData.setSimpleField(WorkflowConfig.WorkflowConfigProperty.Dag.name(), jobDag.toJson());
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not add job " + job + " to queue " + queue, e);
                }
                return currentData;
            }
        };
        String path = this._accessor.keyBuilder().resourceConfig(queue).getPath();
        boolean status = this._accessor.getBaseDataAccessor().update(path, updater, AccessOption.PERSISTENT);
        if (!status) {
            throw new HelixException("Failed to enqueue job");
        }
        this.addWorkflowResourceIfNecessary(queue);
        RebalanceScheduler.invokeRebalance(this._accessor, queue);
    }

    public void cleanupQueue(String queue) {
        WorkflowConfig workflowConfig = TaskUtil.getWorkflowConfig(this._accessor, queue);
        if (workflowConfig == null) {
            throw new IllegalArgumentException("Queue " + queue + " does not yet exist!");
        }
        boolean isTerminable = workflowConfig.isTerminable();
        if (isTerminable) {
            throw new IllegalArgumentException(queue + " is not a queue!");
        }
        WorkflowContext wCtx = TaskUtil.getWorkflowContext(this._propertyStore, queue);
        if (wCtx == null || wCtx.getWorkflowState() == null) {
            throw new IllegalStateException("Queue " + queue + " does not have a valid work state!");
        }
        HashSet<String> jobs = new HashSet<String>();
        for (String jobNode : workflowConfig.getJobDag().getAllNodes()) {
            TaskState curState = wCtx.getJobState(jobNode);
            if (curState == null || curState != TaskState.ABORTED && curState != TaskState.COMPLETED && curState != TaskState.FAILED) continue;
            jobs.add(jobNode);
        }
        TaskUtil.removeJobsFromWorkflow(this._accessor, this._propertyStore, queue, jobs, true);
    }

    private void addWorkflowResource(String workflow) {
        this._admin.addResource(this._clusterName, workflow, 1, "Task");
        IdealState is = this.buildWorkflowIdealState(workflow);
        TaskUtil.createUserContent(this._propertyStore, workflow, new ZNRecord("UserContent"));
        this._admin.setResourceIdealState(this._clusterName, workflow, is);
    }

    private void addWorkflowResourceIfNecessary(String workflow) {
        IdealState is = this._admin.getResourceIdealState(this._clusterName, workflow);
        if (is == null) {
            this.addWorkflowResource(workflow);
        }
    }

    private IdealState buildWorkflowIdealState(String workflow) {
        CustomModeISBuilder IsBuilder = new CustomModeISBuilder(workflow);
        IsBuilder.setRebalancerMode(IdealState.RebalanceMode.TASK).setNumReplica(1).setNumPartitions(1).setStateModel("Task").setDisableExternalView(true);
        IdealState is = IsBuilder.build();
        is.getRecord().setListField(workflow, new ArrayList<String>());
        is.getRecord().setMapField(workflow, new HashMap<String, String>());
        is.setRebalancerClassName(WorkflowRebalancer.class.getName());
        return is;
    }

    private void addJobConfig(String job, JobConfig jobConfig) {
        LOG.info((Object)("Add job configuration " + job));
        JobConfig newJobCfg = new JobConfig(job, jobConfig);
        if (!TaskUtil.setJobConfig(this._accessor, job, newJobCfg)) {
            throw new HelixException("Failed to add job configuration for job " + job);
        }
    }

    public void resume(String workflow) {
        this.setWorkflowTargetState(workflow, TargetState.START);
    }

    public void stop(String workflow) throws InterruptedException {
        this.setWorkflowTargetState(workflow, TargetState.STOP);
    }

    public void waitToStop(String workflow, long timeout) throws InterruptedException {
        this.setWorkflowTargetState(workflow, TargetState.STOP);
        long endTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() <= endTime) {
            WorkflowContext workflowContext = this.getWorkflowContext(workflow);
            if (workflowContext == null || !workflowContext.getWorkflowState().equals((Object)TaskState.STOPPED)) {
                Thread.sleep(1000L);
                continue;
            }
            return;
        }
        throw new HelixException(String.format("Fail to stop the workflow/queue %s with in %d milliseconds.", workflow, timeout));
    }

    public void delete(String workflow) {
        WorkflowContext wCtx = TaskUtil.getWorkflowContext(this._propertyStore, workflow);
        this.setWorkflowTargetState(workflow, TargetState.DELETE);
        if (wCtx != null && wCtx.getScheduledWorkflows() != null) {
            for (String scheduledWorkflow : wCtx.getScheduledWorkflows()) {
                WorkflowContext scheduledWorkflowCtx = TaskUtil.getWorkflowContext(this._propertyStore, scheduledWorkflow);
                if (scheduledWorkflowCtx == null || scheduledWorkflowCtx.getFinishTime() == -1L) continue;
                this.setWorkflowTargetState(scheduledWorkflow, TargetState.DELETE);
            }
        }
    }

    private void setWorkflowTargetState(String workflow, TargetState state) {
        String lastScheduledWorkflow;
        this.setSingleWorkflowTargetState(workflow, state);
        WorkflowContext wCtx = TaskUtil.getWorkflowContext(this._propertyStore, workflow);
        if (wCtx != null && (lastScheduledWorkflow = wCtx.getLastScheduledSingleWorkflow()) != null) {
            this.setSingleWorkflowTargetState(lastScheduledWorkflow, state);
        }
    }

    private void setSingleWorkflowTargetState(String workflow, final TargetState state) {
        LOG.info((Object)("Set " + workflow + " to target state " + (Object)((Object)state)));
        WorkflowConfig workflowConfig = TaskUtil.getWorkflowConfig(this._accessor, workflow);
        if (workflowConfig == null) {
            LOG.warn((Object)("WorkflowConfig for " + workflow + " not found!"));
            return;
        }
        WorkflowContext workflowContext = TaskUtil.getWorkflowContext(this._propertyStore, workflow);
        if (state != TargetState.DELETE && workflowContext != null && (workflowContext.getFinishTime() != -1L || workflowContext.getWorkflowState() == TaskState.COMPLETED || workflowContext.getWorkflowState() == TaskState.FAILED)) {
            LOG.info((Object)("Workflow " + workflow + " is already completed, skip to update its target state " + (Object)((Object)state)));
            return;
        }
        DataUpdater<ZNRecord> updater = new DataUpdater<ZNRecord>(){

            public ZNRecord update(ZNRecord currentData) {
                if (currentData != null) {
                    currentData.setSimpleField(WorkflowConfig.WorkflowConfigProperty.TargetState.name(), state.name());
                } else {
                    LOG.warn((Object)("TargetState DataUpdater: Fails to update target state. CurrentData is " + currentData));
                }
                return currentData;
            }
        };
        PropertyKey workflowConfigKey = TaskUtil.getWorkflowConfigKey(this._accessor, workflow);
        this._accessor.getBaseDataAccessor().update(workflowConfigKey.getPath(), updater, AccessOption.PERSISTENT);
        RebalanceScheduler.invokeRebalance(this._accessor, workflow);
    }

    public WorkflowConfig getWorkflowConfig(String workflow) {
        return TaskUtil.getWorkflowConfig(this._accessor, workflow);
    }

    public WorkflowContext getWorkflowContext(String workflow) {
        return TaskUtil.getWorkflowContext(this._propertyStore, workflow);
    }

    public JobConfig getJobConfig(String job) {
        return TaskUtil.getJobConfig(this._accessor, job);
    }

    public JobContext getJobContext(String job) {
        return TaskUtil.getJobContext(this._propertyStore, job);
    }

    public static JobContext getJobContext(HelixManager manager, String job) {
        return TaskUtil.getJobContext(manager, job);
    }

    public static WorkflowConfig getWorkflowConfig(HelixManager manager, String workflow) {
        return TaskUtil.getWorkflowConfig(manager, workflow);
    }

    public static WorkflowContext getWorkflowContext(HelixManager manager, String workflow) {
        return TaskUtil.getWorkflowContext(manager, workflow);
    }

    public static JobConfig getJobConfig(HelixManager manager, String job) {
        return TaskUtil.getJobConfig(manager, job);
    }

    public Map<String, WorkflowConfig> getWorkflows() {
        HashMap<String, WorkflowConfig> workflowConfigMap = new HashMap<String, WorkflowConfig>();
        Map resourceConfigMap = this._accessor.getChildValuesMap(this._accessor.keyBuilder().resourceConfigs());
        for (Map.Entry resource : resourceConfigMap.entrySet()) {
            try {
                WorkflowConfig config = WorkflowConfig.fromHelixProperty((HelixProperty)resource.getValue());
                workflowConfigMap.put(resource.getKey(), config);
            }
            catch (IllegalArgumentException ex) {}
        }
        return workflowConfigMap;
    }

    public TaskState pollForWorkflowState(String workflowName, long timeout, TaskState ... targetStates) throws InterruptedException {
        WorkflowContext ctx;
        long st = System.currentTimeMillis();
        HashSet<TaskState> allowedStates = new HashSet<TaskState>(Arrays.asList(targetStates));
        long timeToSleep = timeout > 100L ? 100L : timeout;
        do {
            Thread.sleep(timeToSleep);
        } while (((ctx = this.getWorkflowContext(workflowName)) == null || ctx.getWorkflowState() == null || !allowedStates.contains((Object)ctx.getWorkflowState())) && System.currentTimeMillis() < st + timeout);
        if (ctx == null || !allowedStates.contains((Object)ctx.getWorkflowState())) {
            throw new HelixException(String.format("Workflow \"%s\" context is empty or not in states: \"%s\"", new Object[]{workflowName, targetStates}));
        }
        return ctx.getWorkflowState();
    }

    public TaskState pollForWorkflowState(String workflowName, TaskState ... targetStates) throws InterruptedException {
        return this.pollForWorkflowState(workflowName, 180000L, targetStates);
    }

    public TaskState pollForJobState(String workflowName, String jobName, long timeout, TaskState ... states) throws InterruptedException {
        WorkflowContext ctx;
        long timeToSleep;
        WorkflowConfig workflowConfig = this.getWorkflowConfig(workflowName);
        if (workflowConfig == null) {
            throw new HelixException(String.format("Workflow \"%s\" does not exists!", workflowName));
        }
        long l = timeToSleep = timeout > 100L ? 100L : timeout;
        if (workflowConfig.isRecurring()) {
            do {
                Thread.sleep(timeToSleep);
            } while ((ctx = this.getWorkflowContext(workflowName)) == null || ctx.getLastScheduledSingleWorkflow() == null);
            jobName = jobName.substring(workflowName.length() + 1);
            workflowName = ctx.getLastScheduledSingleWorkflow();
            jobName = TaskUtil.getNamespacedJobName(workflowName, jobName);
        }
        HashSet<TaskState> allowedStates = new HashSet<TaskState>(Arrays.asList(states));
        long st = System.currentTimeMillis();
        do {
            Thread.sleep(timeToSleep);
        } while (((ctx = this.getWorkflowContext(workflowName)) == null || ctx.getJobState(jobName) == null || !allowedStates.contains((Object)ctx.getJobState(jobName))) && System.currentTimeMillis() < st + timeout);
        if (ctx == null || !allowedStates.contains((Object)ctx.getJobState(jobName))) {
            throw new HelixException(String.format("Job \"%s\" context is null or not in states: \"%s\"", new Object[]{jobName, states}));
        }
        return ctx.getJobState(jobName);
    }

    public TaskState pollForJobState(String workflowName, String jobName, TaskState ... states) throws InterruptedException {
        return this.pollForJobState(workflowName, jobName, 180000L, states);
    }

    public static enum DriverCommand {
        start,
        stop,
        delete,
        resume,
        list,
        flush,
        clean;

    }
}

