/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools.ClusterVerifiers;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyPathBuilder;
import org.apache.helix.PropertyType;
import org.apache.helix.ZNRecord;
import org.apache.helix.controller.pipeline.Stage;
import org.apache.helix.controller.pipeline.StageContext;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.BestPossibleStateCalcStage;
import org.apache.helix.controller.stages.BestPossibleStateOutput;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.CurrentStateComputationStage;
import org.apache.helix.controller.stages.ResourceComputationStage;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Partition;
import org.apache.helix.tools.ClusterSetup;
import org.apache.helix.util.ZKClientPool;
import org.apache.log4j.Logger;

@Deprecated
public class ClusterStateVerifier {
    public static String cluster = "cluster";
    public static String zkServerAddress = "zkSvr";
    public static String help = "help";
    public static String timeout = "timeout";
    public static String period = "period";
    public static String resources = "resources";
    private static Logger LOG = Logger.getLogger(ClusterStateVerifier.class);

    private static ZkClient validateAndGetClient(String zkAddr, String clusterName) {
        if (zkAddr == null || clusterName == null) {
            throw new IllegalArgumentException("requires zkAddr|clusterName");
        }
        return ZKClientPool.getZkClient(zkAddr);
    }

    public static boolean verifyByPolling(Verifier verifier) {
        return ClusterStateVerifier.verifyByPolling(verifier, 30000L);
    }

    public static boolean verifyByPolling(Verifier verifier, long timeout) {
        return ClusterStateVerifier.verifyByPolling(verifier, timeout, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifyByPolling(Verifier verifier, long timeout, long period) {
        long startTime = System.currentTimeMillis();
        boolean result = false;
        try {
            long curTime;
            do {
                Thread.sleep(period);
            } while (!(result = verifier.verify()) && (curTime = System.currentTimeMillis()) <= startTime + timeout);
            boolean bl = result;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            long endTime = System.currentTimeMillis();
            System.err.println(result + ": " + verifier + ": wait " + (endTime - startTime) + "ms to verify");
        }
        return false;
    }

    public static boolean verifyByZkCallback(ZkVerifier verifier) {
        return ClusterStateVerifier.verifyByZkCallback(verifier, 30000L);
    }

    public static boolean verifyByZkCallback(ZkVerifier verifier, long timeout) {
        long startTime = System.currentTimeMillis();
        CountDownLatch countDown = new CountDownLatch(1);
        ZkClient zkClient = verifier.getZkClient();
        String clusterName = verifier.getClusterName();
        try {
            zkClient.createEphemeral("/" + clusterName + "/CONFIGS/CLUSTER/verify");
        }
        catch (ZkNodeExistsException ex) {
            LOG.error((Object)"There is already a verification in progress", (Throwable)ex);
            throw ex;
        }
        ExtViewVeriferZkListener listener = new ExtViewVeriferZkListener(countDown, zkClient, verifier);
        String extViewPath = PropertyPathBuilder.getPath(PropertyType.EXTERNALVIEW, clusterName, new String[0]);
        zkClient.subscribeChildChanges(extViewPath, listener);
        for (String child : zkClient.getChildren(extViewPath)) {
            String childPath = extViewPath.equals("/") ? extViewPath + child : extViewPath + "/" + child;
            zkClient.subscribeDataChanges(childPath, listener);
        }
        boolean result = verifier.verify();
        if (!result) {
            try {
                result = countDown.await(timeout, TimeUnit.MILLISECONDS);
                if (!result) {
                    result = verifier.verify();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        zkClient.unsubscribeChildChanges(extViewPath, listener);
        for (String child : zkClient.getChildren(extViewPath)) {
            String childPath = extViewPath.equals("/") ? extViewPath + child : extViewPath + "/" + child;
            zkClient.unsubscribeDataChanges(childPath, listener);
        }
        long endTime = System.currentTimeMillis();
        zkClient.delete("/" + clusterName + "/CONFIGS/CLUSTER/verify");
        System.err.println(result + ": wait " + (endTime - startTime) + "ms, " + verifier);
        return result;
    }

    private static Options constructCommandLineOptions() {
        OptionBuilder.withLongOpt((String)help);
        OptionBuilder.withDescription((String)"Prints command-line options info");
        Option helpOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)zkServerAddress);
        OptionBuilder.withDescription((String)"Provide zookeeper address");
        Option zkServerOption = OptionBuilder.create();
        zkServerOption.setArgs(1);
        zkServerOption.setRequired(true);
        zkServerOption.setArgName("ZookeeperServerAddress(Required)");
        OptionBuilder.withLongOpt((String)cluster);
        OptionBuilder.withDescription((String)"Provide cluster name");
        Option clusterOption = OptionBuilder.create();
        clusterOption.setArgs(1);
        clusterOption.setRequired(true);
        clusterOption.setArgName("Cluster name (Required)");
        OptionBuilder.withLongOpt((String)timeout);
        OptionBuilder.withDescription((String)"Timeout value for verification");
        Option timeoutOption = OptionBuilder.create();
        timeoutOption.setArgs(1);
        timeoutOption.setArgName("Timeout value (Optional), default=30s");
        OptionBuilder.withLongOpt((String)period);
        OptionBuilder.withDescription((String)"Polling period for verification");
        Option sleepIntervalOption = OptionBuilder.create();
        sleepIntervalOption.setArgs(1);
        sleepIntervalOption.setArgName("Polling period value (Optional), default=1s");
        OptionBuilder.withLongOpt((String)resources);
        OptionBuilder.withDescription((String)"Specific set of resources to verify");
        Option resourcesOption = OptionBuilder.create();
        resourcesOption.setArgs(1);
        resourcesOption.setArgName("Comma-separated resource names, default is all resources");
        Options options = new Options();
        options.addOption(helpOption);
        options.addOption(zkServerOption);
        options.addOption(clusterOption);
        options.addOption(timeoutOption);
        options.addOption(sleepIntervalOption);
        options.addOption(resourcesOption);
        return options;
    }

    public static void printUsage(Options cliOptions) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setWidth(1000);
        helpFormatter.printHelp("java " + ClusterSetup.class.getName(), cliOptions);
    }

    public static CommandLine processCommandLineArgs(String[] cliArgs) {
        GnuParser cliParser = new GnuParser();
        Options cliOptions = ClusterStateVerifier.constructCommandLineOptions();
        try {
            return cliParser.parse(cliOptions, cliArgs);
        }
        catch (ParseException pe) {
            System.err.println("CommandLineClient: failed to parse command-line options: " + pe.toString());
            ClusterStateVerifier.printUsage(cliOptions);
            System.exit(1);
            return null;
        }
    }

    public static boolean verifyState(String[] args) {
        String clusterName = "storage-cluster";
        String zkServer = "localhost:2181";
        long timeoutValue = 0L;
        long periodValue = 1000L;
        HashSet resourceSet = null;
        if (args.length > 0) {
            CommandLine cmd = ClusterStateVerifier.processCommandLineArgs(args);
            zkServer = cmd.getOptionValue(zkServerAddress);
            clusterName = cmd.getOptionValue(cluster);
            String timeoutStr = cmd.getOptionValue(timeout);
            String periodStr = cmd.getOptionValue(period);
            String resourceStr = cmd.getOptionValue(resources);
            if (timeoutStr != null) {
                try {
                    timeoutValue = Long.parseLong(timeoutStr);
                }
                catch (Exception e) {
                    System.err.println("Exception in converting " + timeoutStr + " to long. Use default (0)");
                }
            }
            if (periodStr != null) {
                try {
                    periodValue = Long.parseLong(periodStr);
                }
                catch (Exception e) {
                    System.err.println("Exception in converting " + periodStr + " to long. Use default (1000)");
                }
            }
            if (resourceStr != null) {
                Object[] resources = resourceStr.split("[\\s,]");
                resourceSet = Sets.newHashSet((Object[])resources);
            }
        }
        BestPossAndExtViewZkVerifier verifier = resourceSet == null ? new BestPossAndExtViewZkVerifier(zkServer, clusterName) : new BestPossAndExtViewZkVerifier(zkServer, clusterName, null, resourceSet);
        return ClusterStateVerifier.verifyByZkCallback(verifier, timeoutValue);
    }

    public static void main(String[] args) {
        boolean result = ClusterStateVerifier.verifyState(args);
        System.out.println(result ? "Successful" : "failed");
        System.exit(1);
    }

    public static class MasterNbInExtViewVerifier
    implements ZkVerifier {
        private final String clusterName;
        private final ZkClient zkClient;

        public MasterNbInExtViewVerifier(String zkAddr, String clusterName) {
            this(ClusterStateVerifier.validateAndGetClient(zkAddr, clusterName), clusterName);
        }

        public MasterNbInExtViewVerifier(ZkClient zkClient, String clusterName) {
            if (zkClient == null || clusterName == null) {
                throw new IllegalArgumentException("requires zkClient|clusterName");
            }
            this.clusterName = clusterName;
            this.zkClient = zkClient;
        }

        @Override
        public boolean verify() {
            try {
                ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(this.clusterName, new ZkBaseDataAccessor<ZNRecord>(this.zkClient));
                return this.verifyMasterNbInExtView(accessor);
            }
            catch (Exception e) {
                LOG.error((Object)"exception in verification", (Throwable)e);
                return false;
            }
        }

        @Override
        public ZkClient getZkClient() {
            return this.zkClient;
        }

        @Override
        public String getClusterName() {
            return this.clusterName;
        }

        private boolean verifyMasterNbInExtView(HelixDataAccessor accessor) {
            PropertyKey.Builder keyBuilder = accessor.keyBuilder();
            Map idealStates = accessor.getChildValuesMap(keyBuilder.idealStates());
            if (idealStates == null || idealStates.size() == 0) {
                LOG.info((Object)"No resource idealState");
                return true;
            }
            Map extViews = accessor.getChildValuesMap(keyBuilder.externalViews());
            if (extViews == null || extViews.size() < idealStates.size()) {
                LOG.info((Object)"No externalViews | externalView.size() < idealState.size()");
                return false;
            }
            for (String resource : extViews.keySet()) {
                int partitions = ((IdealState)idealStates.get(resource)).getNumPartitions();
                Map<String, Map<String, String>> instanceStateMap = ((ExternalView)extViews.get(resource)).getRecord().getMapFields();
                if (instanceStateMap.size() < partitions) {
                    LOG.info((Object)("Number of externalViews (" + instanceStateMap.size() + ") < partitions (" + partitions + ")"));
                    return false;
                }
                for (String partition : instanceStateMap.keySet()) {
                    boolean foundMaster = false;
                    for (String instance : instanceStateMap.get(partition).keySet()) {
                        if (!instanceStateMap.get(partition).get(instance).equalsIgnoreCase("MASTER")) continue;
                        foundMaster = true;
                        break;
                    }
                    if (foundMaster) continue;
                    LOG.info((Object)("No MASTER for partition: " + partition));
                    return false;
                }
            }
            return true;
        }
    }

    public static class BestPossAndExtViewZkVerifier
    implements ZkVerifier {
        private final String clusterName;
        private final Map<String, Map<String, String>> errStates;
        private final ZkClient zkClient;
        private final Set<String> resources;

        public BestPossAndExtViewZkVerifier(String zkAddr, String clusterName) {
            this(zkAddr, clusterName, null);
        }

        public BestPossAndExtViewZkVerifier(String zkAddr, String clusterName, Map<String, Map<String, String>> errStates) {
            this(zkAddr, clusterName, errStates, null);
        }

        public BestPossAndExtViewZkVerifier(String zkAddr, String clusterName, Map<String, Map<String, String>> errStates, Set<String> resources) {
            this(ClusterStateVerifier.validateAndGetClient(zkAddr, clusterName), clusterName, errStates, resources);
        }

        public BestPossAndExtViewZkVerifier(ZkClient zkClient, String clusterName, Map<String, Map<String, String>> errStates, Set<String> resources) {
            if (zkClient == null || clusterName == null) {
                throw new IllegalArgumentException("requires zkClient|clusterName");
            }
            this.clusterName = clusterName;
            this.errStates = errStates;
            this.zkClient = zkClient;
            this.resources = resources;
        }

        @Override
        public boolean verify() {
            try {
                ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(this.clusterName, new ZkBaseDataAccessor<ZNRecord>(this.zkClient));
                return this.verifyBestPossAndExtView(accessor, this.errStates, this.clusterName, this.resources);
            }
            catch (Exception e) {
                LOG.error((Object)"exception in verification", (Throwable)e);
                return false;
            }
        }

        private boolean verifyBestPossAndExtView(HelixDataAccessor accessor, Map<String, Map<String, String>> errStates, String clusterName, Set<String> resources) {
            try {
                PropertyKey.Builder keyBuilder = accessor.keyBuilder();
                ClusterDataCache cache = new ClusterDataCache();
                cache.refresh(accessor);
                Map<String, IdealState> idealStates = cache.getIdealStates();
                if (idealStates == null) {
                    idealStates = Collections.emptyMap();
                }
                Iterator<Map.Entry<String, IdealState>> it = idealStates.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, IdealState> pair = it.next();
                    if (!pair.getValue().getStateModelDefRef().equals("Task")) continue;
                    it.remove();
                }
                Map<String, Object> extViews = accessor.getChildValuesMap(keyBuilder.externalViews());
                if (extViews == null) {
                    extViews = Collections.emptyMap();
                }
                if (resources != null && !resources.isEmpty()) {
                    idealStates.keySet().retainAll(resources);
                    extViews.keySet().retainAll(resources);
                }
                for (String resource : extViews.keySet()) {
                    if (idealStates.containsKey(resource)) continue;
                    idealStates.put(resource, new IdealState(resource));
                }
                BestPossibleStateOutput bestPossOutput = this.calcBestPossState(cache, resources);
                Map<String, Map<Partition, Map<String, String>>> bestPossStateMap = bestPossOutput.getStateMap();
                if (errStates != null) {
                    for (String resourceName : errStates.keySet()) {
                        Map<String, String> partErrStates = errStates.get(resourceName);
                        for (String partitionName : partErrStates.keySet()) {
                            String instanceName = partErrStates.get(partitionName);
                            if (!bestPossStateMap.containsKey(resourceName)) {
                                bestPossStateMap.put(resourceName, new HashMap());
                            }
                            Partition partition = new Partition(partitionName);
                            if (!bestPossStateMap.get(resourceName).containsKey(partition)) {
                                bestPossStateMap.get(resourceName).put(partition, new HashMap());
                            }
                            bestPossStateMap.get(resourceName).get(partition).put(instanceName, HelixDefinedState.ERROR.name());
                        }
                    }
                }
                for (String resourceName : idealStates.keySet()) {
                    int bestPossStateSize;
                    ExternalView extView = (ExternalView)extViews.get(resourceName);
                    if (extView == null) {
                        IdealState is = idealStates.get(resourceName);
                        if (is.isExternalViewDisabled()) continue;
                        LOG.info((Object)("externalView for " + resourceName + " is not available"));
                        return false;
                    }
                    Map<Partition, Map<String, String>> bpStateMap = bestPossOutput.getResourceMap(resourceName);
                    Iterator<Map.Entry<Partition, Map<String, String>>> iter = bpStateMap.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<Partition, Map<String, String>> entry = iter.next();
                        Map<String, String> instanceStateMap = entry.getValue();
                        if (instanceStateMap.isEmpty()) {
                            iter.remove();
                            continue;
                        }
                        Iterator<Map.Entry<String, String>> insIter = instanceStateMap.entrySet().iterator();
                        while (insIter.hasNext()) {
                            Map.Entry<String, String> insEntry = insIter.next();
                            String state = insEntry.getValue();
                            if (!state.equalsIgnoreCase(HelixDefinedState.DROPPED.name())) continue;
                            insIter.remove();
                        }
                    }
                    int extViewSize = extView.getRecord().getMapFields().size();
                    if (extViewSize != (bestPossStateSize = bestPossOutput.getResourceMap(resourceName).size())) {
                        LOG.info((Object)("exterView size (" + extViewSize + ") is different from bestPossState size (" + bestPossStateSize + ") for resource: " + resourceName));
                        return false;
                    }
                    for (String partition : extView.getRecord().getMapFields().keySet()) {
                        Map<String, String> bpInstanceStateMap;
                        Map<String, String> evInstanceStateMap = extView.getRecord().getMapField(partition);
                        boolean result = this.compareMap(evInstanceStateMap, bpInstanceStateMap = bestPossOutput.getInstanceStateMap(resourceName, new Partition(partition)));
                        if (result) continue;
                        LOG.info((Object)("externalView is different from bestPossibleState for partition:" + partition));
                        return false;
                    }
                }
                return true;
            }
            catch (Exception e) {
                LOG.error((Object)"exception in verification", (Throwable)e);
                return false;
            }
        }

        private BestPossibleStateOutput calcBestPossState(ClusterDataCache cache, Set<String> resources) throws Exception {
            ClusterEvent event = new ClusterEvent("sampleEvent");
            event.addAttribute("ClusterDataCache", cache);
            ResourceComputationStage rcState = new ResourceComputationStage();
            CurrentStateComputationStage csStage = new CurrentStateComputationStage();
            BestPossibleStateCalcStage bpStage = new BestPossibleStateCalcStage();
            this.runStage(event, rcState);
            if (resources != null) {
                Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES.name());
                resourceMap.keySet().retainAll(resources);
            }
            this.runStage(event, csStage);
            this.runStage(event, bpStage);
            BestPossibleStateOutput output = (BestPossibleStateOutput)event.getAttribute(AttributeName.BEST_POSSIBLE_STATE.name());
            return output;
        }

        private void runStage(ClusterEvent event, Stage stage) throws Exception {
            StageContext context = new StageContext();
            stage.init(context);
            stage.preProcess();
            stage.process(event);
            stage.postProcess();
        }

        private <K, V> boolean compareMap(Map<K, V> map1, Map<K, V> map2) {
            boolean isEqual;
            block2: {
                block4: {
                    block3: {
                        isEqual = true;
                        if (map1 == null && map2 == null) break block2;
                        if (map1 != null || map2 == null) break block3;
                        if (map2.isEmpty()) break block2;
                        isEqual = false;
                        break block2;
                    }
                    if (map1 == null || map2 != null) break block4;
                    if (map1.isEmpty()) break block2;
                    isEqual = false;
                    break block2;
                }
                if (map1.size() != map2.size()) {
                    isEqual = false;
                }
                for (K key : map1.keySet()) {
                    if (map1.get(key).equals(map2.get(key))) continue;
                    LOG.debug((Object)("different value for key: " + key + "(map1: " + map1.get(key) + ", map2: " + map2.get(key) + ")"));
                    isEqual = false;
                    break;
                }
            }
            return isEqual;
        }

        @Override
        public ZkClient getZkClient() {
            return this.zkClient;
        }

        @Override
        public String getClusterName() {
            return this.clusterName;
        }

        public String toString() {
            String verifierName = this.getClass().getName();
            verifierName = verifierName.substring(verifierName.lastIndexOf(46) + 1, verifierName.length());
            return verifierName + "(" + this.clusterName + "@" + this.zkClient.getServers() + ")";
        }
    }

    @Deprecated
    static class ExtViewVeriferZkListener
    implements IZkChildListener,
    IZkDataListener {
        final CountDownLatch _countDown;
        final ZkClient _zkClient;
        final Verifier _verifier;

        public ExtViewVeriferZkListener(CountDownLatch countDown, ZkClient zkClient, ZkVerifier verifier) {
            this._countDown = countDown;
            this._zkClient = zkClient;
            this._verifier = verifier;
        }

        public void handleDataChange(String dataPath, Object data) throws Exception {
            boolean result = this._verifier.verify();
            if (result) {
                this._countDown.countDown();
            }
        }

        public void handleDataDeleted(String dataPath) throws Exception {
        }

        public void handleChildChange(String parentPath, List<String> currentChilds) throws Exception {
            for (String child : currentChilds) {
                String childPath = parentPath.equals("/") ? parentPath + child : parentPath + "/" + child;
                this._zkClient.subscribeDataChanges(childPath, this);
            }
            boolean result = this._verifier.verify();
            if (result) {
                this._countDown.countDown();
            }
        }
    }

    public static interface ZkVerifier
    extends Verifier {
        public ZkClient getZkClient();

        public String getClusterName();
    }

    public static interface Verifier {
        public boolean verify();
    }
}

