/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.client;

import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.restli.client.BatchGetKVRequest;
import com.linkedin.restli.client.BatchGetRequest;
import com.linkedin.restli.client.BatchGetRequestUtil;
import com.linkedin.restli.client.BatchKVRequestBuilder;
import com.linkedin.restli.client.GetRequest;
import com.linkedin.restli.client.RestliRequestOptions;
import com.linkedin.restli.common.BatchResponse;
import com.linkedin.restli.common.ComplexResourceKey;
import com.linkedin.restli.common.CompoundKey;
import com.linkedin.restli.common.ResourceSpec;
import com.linkedin.restli.internal.client.BatchKVResponseDecoder;
import com.linkedin.restli.internal.client.BatchResponseDecoder;
import com.linkedin.restli.internal.client.RestResponseDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchGetRequestBuilder<K, V extends RecordTemplate>
extends BatchKVRequestBuilder<K, V, BatchGetRequest<V>> {
    private final RestResponseDecoder<BatchResponse<V>> _decoder;

    public static <RT extends RecordTemplate> BatchGetRequest<RT> batch(List<BatchGetRequest<RT>> requests) {
        return BatchGetRequestBuilder.batch(requests, true);
    }

    public static <RT extends RecordTemplate> BatchGetRequest<RT> batch(List<BatchGetRequest<RT>> requests, boolean batchFields) {
        BatchGetRequest<RT> firstRequest = requests.get(0);
        Class keyClass = firstRequest.getResourceSpec().getKeyClass();
        BatchGetRequestBuilder.throwIfClassCompoundOrComplex(keyClass, "batch", "batchKV");
        ResourceSpec firstResourceSpec = firstRequest.getResourceSpec();
        Map<String, Object> batchQueryParams = BatchGetRequestBuilder.getReadOnlyQueryParameters(BatchGetRequestUtil.getBatchQueryParam(requests, batchFields));
        return new BatchGetRequest(BatchGetRequestBuilder.getReadOnlyHeaders(firstRequest.getHeaders()), BatchGetRequestBuilder.getReadOnlyCookies(firstRequest.getCookies()), firstRequest.getResponseDecoder(), batchQueryParams, firstRequest.getQueryParamClasses(), firstResourceSpec, firstRequest.getBaseUriTemplate(), BatchGetRequestBuilder.getReadOnlyPathKeys(firstRequest.getPathKeys()), firstRequest.getRequestOptions());
    }

    public static <K, RT extends RecordTemplate> BatchGetKVRequest<K, RT> batchKV(List<BatchGetKVRequest<K, RT>> requests) {
        return BatchGetRequestBuilder.batchKV(requests, true);
    }

    public static <K, RT extends RecordTemplate> BatchGetKVRequest<K, RT> batchKV(List<BatchGetKVRequest<K, RT>> requests, boolean batchFields) {
        BatchGetKVRequest<K, RT> firstRequest = requests.get(0);
        ResourceSpec firstResourceSpec = firstRequest.getResourceSpec();
        Map<String, Object> batchQueryParams = BatchGetRequestBuilder.getReadOnlyQueryParameters(BatchGetRequestUtil.getBatchQueryParam(requests, batchFields));
        return new BatchGetKVRequest(BatchGetRequestBuilder.getReadOnlyHeaders(firstRequest.getHeaders()), BatchGetRequestBuilder.getReadOnlyCookies(firstRequest.getCookies()), firstRequest.getResponseDecoder(), batchQueryParams, Collections.emptyMap(), firstResourceSpec, firstRequest.getBaseUriTemplate(), BatchGetRequestBuilder.getReadOnlyPathKeys(firstRequest.getPathKeys()), firstRequest.getRequestOptions());
    }

    public static <K, RT extends RecordTemplate> BatchGetKVRequest<K, RT> batchKV(GetRequest<RT> request) {
        Object id = request.getObjectId();
        if (id == null) {
            throw new IllegalArgumentException("It is not possible to create a batch get request from a get request without an id.");
        }
        HashMap<String, Object> queryParams = new HashMap<String, Object>(request.getQueryParamsObjects());
        queryParams.put("ids", new ArrayList<Object>(Arrays.asList(id)));
        return new BatchGetKVRequest(BatchGetRequestBuilder.getReadOnlyHeaders(request.getHeaders()), BatchGetRequestBuilder.getReadOnlyCookies(request.getCookies()), new BatchKVResponseDecoder(request.getEntityClass(), request.getResourceProperties().getKeyType().getType(), request.getResourceProperties().getKeyParts(), request.getResourceProperties().getComplexKeyType() == null ? null : request.getResourceProperties().getComplexKeyType().getKeyType().getType(), request.getResourceProperties().getComplexKeyType() == null ? null : request.getResourceProperties().getComplexKeyType().getParamsType().getType()), BatchGetRequestBuilder.getReadOnlyQueryParameters(queryParams), request.getQueryParamClasses(), request.getResourceSpec(), request.getBaseUriTemplate(), BatchGetRequestBuilder.getReadOnlyPathKeys(request.getPathKeys()), request.getRequestOptions());
    }

    public static <RT extends RecordTemplate> BatchGetRequest<RT> batch(GetRequest<RT> request) {
        Object id = request.getObjectId();
        if (id == null) {
            throw new IllegalArgumentException("It is not possible to create a batch get request from a get request without an id.");
        }
        Class keyClass = request.getResourceSpec().getKeyClass();
        BatchGetRequestBuilder.throwIfClassCompoundOrComplex(keyClass, "batch", "batchKV");
        HashMap<String, Object> queryParams = new HashMap<String, Object>(request.getQueryParamsObjects());
        queryParams.put("ids", new ArrayList<Object>(Arrays.asList(id)));
        return new BatchGetRequest(BatchGetRequestBuilder.getReadOnlyHeaders(request.getHeaders()), BatchGetRequestBuilder.getReadOnlyCookies(request.getCookies()), new BatchResponseDecoder<RT>(request.getEntityClass()), BatchGetRequestBuilder.getReadOnlyQueryParameters(queryParams), Collections.emptyMap(), request.getResourceSpec(), request.getBaseUriTemplate(), BatchGetRequestBuilder.getReadOnlyPathKeys(request.getPathKeys()), request.getRequestOptions());
    }

    public BatchGetRequestBuilder(String baseUriTemplate, Class<V> modelClass, ResourceSpec resourceSpec, RestliRequestOptions requestOptions) {
        this(baseUriTemplate, new BatchResponseDecoder<V>(modelClass), resourceSpec, requestOptions);
    }

    public BatchGetRequestBuilder(String baseUriTemplate, RestResponseDecoder<BatchResponse<V>> decoder, ResourceSpec resourceSpec, RestliRequestOptions requestOptions) {
        super(baseUriTemplate, resourceSpec, requestOptions);
        this._decoder = decoder;
    }

    public BatchGetRequestBuilder<K, V> ids(K ... ids) {
        return this.ids((Collection<K>)Arrays.asList(ids));
    }

    public BatchGetRequestBuilder<K, V> ids(Collection<K> ids) {
        this.addKeys(ids);
        return this;
    }

    @Override
    public BatchGetRequestBuilder<K, V> setParam(String key, Object value) {
        super.setParam(key, value);
        return this;
    }

    @Override
    public BatchGetRequestBuilder<K, V> setReqParam(String key, Object value) {
        super.setReqParam(key, value);
        return this;
    }

    @Override
    public BatchGetRequestBuilder<K, V> addParam(String key, Object value) {
        super.addParam(key, value);
        return this;
    }

    @Override
    public BatchGetRequestBuilder<K, V> addReqParam(String key, Object value) {
        super.addReqParam(key, value);
        return this;
    }

    @Override
    public BatchGetRequestBuilder<K, V> setHeader(String key, String value) {
        super.setHeader(key, value);
        return this;
    }

    public BatchGetRequestBuilder<K, V> setHeaders(Map<String, String> headers) {
        super.setHeaders((Map)headers);
        return this;
    }

    @Override
    public BatchGetRequestBuilder<K, V> addHeader(String name, String value) {
        super.addHeader(name, value);
        return this;
    }

    public BatchGetRequestBuilder<K, V> pathKey(String name, Object value) {
        super.pathKey(name, value);
        return this;
    }

    @Override
    public BatchGetRequest<V> build() {
        this.ensureBatchKeys();
        Class keyClass = this._resourceSpec.getKeyClass();
        BatchGetRequestBuilder.throwIfClassCompoundOrComplex(keyClass, "build", "buildKV");
        return new BatchGetRequest(this.buildReadOnlyHeaders(), this.buildReadOnlyCookies(), this._decoder, this.buildReadOnlyQueryParameters(), Collections.emptyMap(), this._resourceSpec, this.getBaseUriTemplate(), this.buildReadOnlyPathKeys(), this.getRequestOptions());
    }

    public BatchGetKVRequest<K, V> buildKV() {
        this.ensureBatchKeys();
        BatchKVResponseDecoder decoder = new BatchKVResponseDecoder(this._resourceSpec.getValueType(), this._resourceSpec.getKeyType(), this._resourceSpec.getKeyParts(), this._resourceSpec.getComplexKeyType());
        return new BatchGetKVRequest(this.buildReadOnlyHeaders(), this.buildReadOnlyCookies(), decoder, this.buildReadOnlyQueryParameters(), this.getQueryParamClasses(), this._resourceSpec, this.getBaseUriTemplate(), this.buildReadOnlyPathKeys(), this.getRequestOptions());
    }

    public BatchGetRequestBuilder<K, V> fields(PathSpec ... fieldPaths) {
        this.addFields(fieldPaths);
        return this;
    }

    private static void throwIfClassCompoundOrComplex(Class<?> keyClass, String currentMethod, String replacementMethod) {
        if (CompoundKey.class.isAssignableFrom(keyClass) || keyClass == ComplexResourceKey.class) {
            throw new UnsupportedOperationException("The " + currentMethod + " method cannot be used with Compound or Complex key types. Please use the " + replacementMethod + " method instead.");
        }
    }
}

