/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.client;

import com.linkedin.data.template.RecordTemplate;
import com.linkedin.restli.client.BatchGetRequestUtil;
import com.linkedin.restli.client.BatchRequest;
import com.linkedin.restli.client.Request;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class BatchingKey<T extends RecordTemplate, R extends BatchRequest<?>> {
    private final R _request;
    private final Map<String, Object> _queryParams;
    private final boolean _batchFields;

    public BatchingKey(R request, boolean batchFields) {
        this._request = request;
        this._queryParams = BatchGetRequestUtil.getQueryParamsForBatchingKey(request);
        this._batchFields = batchFields;
    }

    public <T> void validate(BatchRequest<T> request) {
        if (!request.getBaseUriTemplate().equals(((Request)this._request).getBaseUriTemplate()) || !request.getPathKeys().equals(((Request)this._request).getPathKeys())) {
            throw new IllegalArgumentException("Requests must have same base URI template and path keys to batch");
        }
        if (!request.getResourceProperties().equals(((Request)this._request).getResourceProperties())) {
            throw new IllegalArgumentException("Requests must be for the same resource to batch");
        }
        if (!request.getRequestOptions().equals(((Request)this._request).getRequestOptions())) {
            throw new IllegalArgumentException("Requests must have the same RestliRequestOptions to batch!");
        }
        Map<String, Object> queryParams = BatchGetRequestUtil.getQueryParamsForBatchingKey(request);
        if (!queryParams.equals(this._queryParams)) {
            throw new IllegalArgumentException("Requests must have same parameters to batch");
        }
        if (!this._batchFields && !request.getFields().equals(((Request)this._request).getFields())) {
            throw new IllegalArgumentException("Requests must have same fields to batch");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof BatchingKey)) {
            return false;
        }
        BatchingKey that = (BatchingKey)o;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)((Request)this._request).getBaseUriTemplate(), (Object)((Request)that._request).getBaseUriTemplate());
        builder.append(((Request)this._request).getPathKeys(), ((Request)that._request).getPathKeys());
        builder.append((Object)((Request)this._request).getResourceProperties(), (Object)((Request)that._request).getResourceProperties());
        builder.append((Object)((Request)this._request).getRequestOptions(), (Object)((Request)that._request).getRequestOptions());
        builder.append(this._queryParams, that._queryParams);
        builder.append(this._batchFields, that._batchFields);
        if (this._batchFields) {
            builder.append(((Request)this._request).getFields(), ((Request)that._request).getFields());
        }
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)((Request)this._request).getBaseUriTemplate()).append(((Request)this._request).getPathKeys()).append((Object)((Request)this._request).getResourceProperties()).append((Object)((Request)this._request).getRequestOptions()).append(this._queryParams);
        if (this._batchFields && null != ((Request)this._request).getFields()) {
            builder.append(((Request)this._request).getFields());
        }
        return builder.toHashCode();
    }
}

