/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup.rocksdb;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.io.DataInputDeserializer;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataOutputSerializer;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.lookup.ByteArray;
import org.apache.paimon.lookup.State;
import org.apache.paimon.lookup.rocksdb.RocksDBBulkLoader;
import org.apache.paimon.lookup.rocksdb.RocksDBStateFactory;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Cache;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.paimon.sort.BinaryExternalSortBuffer;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.WriteOptions;

public abstract class RocksDBState<K, V, CacheV>
implements State<K, V> {
    protected final RocksDBStateFactory stateFactory;
    protected final RocksDB db;
    protected final WriteOptions writeOptions;
    protected final ColumnFamilyHandle columnFamily;
    protected final Serializer<K> keySerializer;
    protected final Serializer<V> valueSerializer;
    protected final DataOutputSerializer keyOutView;
    protected final DataInputDeserializer valueInputView;
    protected final DataOutputSerializer valueOutputView;
    protected final Cache<ByteArray, CacheV> cache;

    public RocksDBState(RocksDBStateFactory stateFactory, ColumnFamilyHandle columnFamily, Serializer<K> keySerializer, Serializer<V> valueSerializer, long lruCacheSize) {
        this.stateFactory = stateFactory;
        this.db = stateFactory.db();
        this.columnFamily = columnFamily;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.keyOutView = new DataOutputSerializer(32);
        this.valueInputView = new DataInputDeserializer();
        this.valueOutputView = new DataOutputSerializer(32);
        this.writeOptions = new WriteOptions().setDisableWAL(true);
        this.cache = Caffeine.newBuilder().softValues().maximumSize(lruCacheSize).executor(Runnable::run).build();
    }

    @Override
    public byte[] serializeKey(K key) throws IOException {
        this.keyOutView.clear();
        this.keySerializer.serialize(key, (DataOutputView)this.keyOutView);
        return this.keyOutView.getCopyOfBuffer();
    }

    @Override
    public byte[] serializeValue(V value) throws IOException {
        this.valueOutputView.clear();
        this.valueSerializer.serialize(value, (DataOutputView)this.valueOutputView);
        return this.valueOutputView.getCopyOfBuffer();
    }

    @Override
    public V deserializeValue(byte[] valueBytes) throws IOException {
        this.valueInputView.setBuffer(valueBytes);
        return (V)this.valueSerializer.deserialize((DataInputView)this.valueInputView);
    }

    protected ByteArray wrap(byte[] bytes) {
        return new ByteArray(bytes);
    }

    protected Reference ref(byte[] bytes) {
        return new Reference(bytes);
    }

    public RocksDBBulkLoader createBulkLoader() {
        return new RocksDBBulkLoader(this.db, this.stateFactory.options(), this.columnFamily, this.stateFactory.path());
    }

    public static BinaryExternalSortBuffer createBulkLoadSorter(IOManager ioManager, CoreOptions options) {
        return BinaryExternalSortBuffer.create(ioManager, RowType.of((DataType[])new DataType[]{DataTypes.BYTES(), DataTypes.BYTES()}), new int[]{0}, options.writeBufferSize() / 2L, options.pageSize(), options.localSortMaxNumFileHandles(), options.spillCompressOptions(), options.writeBufferSpillDiskSize(), options.sequenceFieldSortOrderIsAscending());
    }

    protected static class Reference {
        @Nullable
        protected final byte[] bytes;

        protected Reference(@Nullable byte[] bytes) {
            this.bytes = bytes;
        }

        public boolean isPresent() {
            return this.bytes != null;
        }
    }
}

