/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cache;

import java.util.Objects;
import org.apache.gravitino.Entity;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.SupportsRelationOperations;
import org.apache.gravitino.cache.EntityCacheKey;

public class EntityCacheRelationKey
extends EntityCacheKey {
    private final SupportsRelationOperations.Type relationType;

    public static EntityCacheRelationKey of(NameIdentifier ident, Entity.EntityType type, SupportsRelationOperations.Type relationType) {
        return new EntityCacheRelationKey(ident, type, relationType);
    }

    public static EntityCacheRelationKey of(NameIdentifier ident, Entity.EntityType type) {
        return new EntityCacheRelationKey(ident, type, null);
    }

    private EntityCacheRelationKey(NameIdentifier identifier, Entity.EntityType type, SupportsRelationOperations.Type relationType) {
        super(identifier, type);
        this.relationType = relationType;
    }

    public SupportsRelationOperations.Type relationType() {
        return this.relationType;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EntityCacheRelationKey)) {
            return false;
        }
        EntityCacheRelationKey other = (EntityCacheRelationKey)obj;
        return super.equals(obj) && Objects.equals((Object)this.relationType, (Object)other.relationType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.identifier(), super.entityType(), this.relationType});
    }

    @Override
    public String toString() {
        String stringExpr = super.identifier().toString() + ":" + super.entityType().toString();
        if (this.relationType != null) {
            stringExpr = stringExpr + ":" + this.relationType.name();
        }
        return stringExpr;
    }
}

