/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino;

public class Field {
    private String fieldName;
    private Class<?> typeClass;
    private String description;
    private boolean optional;

    private Field() {
    }

    public static Field required(String fieldName, Class<?> typeClass, String description) {
        return new Builder(false).withName(fieldName).withTypeClass(typeClass).withDescription(description).build();
    }

    public static Field optional(String fieldName, Class<?> typeClass, String description) {
        return new Builder(true).withName(fieldName).withTypeClass(typeClass).withDescription(description).build();
    }

    public static Field required(String fieldName, Class<?> typeClass) {
        return new Builder(false).withName(fieldName).withTypeClass(typeClass).build();
    }

    public static Field optional(String fieldName, Class<?> typeClass) {
        return new Builder(true).withName(fieldName).withTypeClass(typeClass).build();
    }

    public <T> void validate(T fieldValue) {
        if (fieldValue == null && !this.optional) {
            throw new IllegalArgumentException("Field " + this.fieldName + " is required");
        }
        if (fieldValue != null && !this.typeClass.isAssignableFrom(fieldValue.getClass())) {
            throw new IllegalArgumentException("Field " + this.fieldName + " is not of type " + this.typeClass.getName());
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Field)) {
            return false;
        }
        Field other = (Field)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.optional != other.optional) {
            return false;
        }
        String this$fieldName = this.fieldName;
        String other$fieldName = other.fieldName;
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        Class<?> this$typeClass = this.typeClass;
        Class<?> other$typeClass = other.typeClass;
        if (this$typeClass == null ? other$typeClass != null : !this$typeClass.equals(other$typeClass)) {
            return false;
        }
        String this$description = this.description;
        String other$description = other.description;
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Field;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.optional ? 79 : 97);
        String $fieldName = this.fieldName;
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        Class<?> $typeClass = this.typeClass;
        result = result * 59 + ($typeClass == null ? 43 : $typeClass.hashCode());
        String $description = this.description;
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public static class Builder {
        private final Field field = new Field();

        public Builder(boolean isOptional) {
            this.field.optional = isOptional;
        }

        public Builder withName(String name) {
            this.field.fieldName = name;
            return this;
        }

        public Builder withTypeClass(Class<?> typeClass) {
            this.field.typeClass = typeClass;
            return this;
        }

        public Builder withDescription(String description) {
            this.field.description = description;
            return this;
        }

        public Field build() {
            if (this.field.fieldName == null) {
                throw new IllegalArgumentException("Field name is required");
            }
            if (this.field.typeClass == null) {
                throw new IllegalArgumentException("Field type class is required");
            }
            return this.field;
        }
    }
}

