/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.Schema;
import org.apache.gravitino.SchemaChange;
import org.apache.gravitino.catalog.CapabilityHelpers;
import org.apache.gravitino.catalog.CatalogManager;
import org.apache.gravitino.catalog.SchemaDispatcher;
import org.apache.gravitino.connector.capability.Capability;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NonEmptySchemaException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;

public class SchemaNormalizeDispatcher
implements SchemaDispatcher {
    private final CatalogManager catalogManager;
    private final SchemaDispatcher dispatcher;

    public SchemaNormalizeDispatcher(SchemaDispatcher dispatcher, CatalogManager catalogManager) {
        this.dispatcher = dispatcher;
        this.catalogManager = catalogManager;
    }

    @Override
    public NameIdentifier[] listSchemas(Namespace namespace) throws NoSuchCatalogException {
        NameIdentifier[] identifiers = this.dispatcher.listSchemas(namespace);
        return this.normalizeCaseSensitive(identifiers);
    }

    @Override
    public boolean schemaExists(NameIdentifier ident) {
        return this.dispatcher.schemaExists(this.normalizeCaseSensitive(ident));
    }

    @Override
    public Schema createSchema(NameIdentifier ident, String comment, Map<String, String> properties) throws NoSuchCatalogException, SchemaAlreadyExistsException {
        return this.dispatcher.createSchema(this.normalizeNameIdentifier(ident), comment, properties);
    }

    @Override
    public Schema loadSchema(NameIdentifier ident) throws NoSuchSchemaException {
        return this.dispatcher.loadSchema(this.normalizeCaseSensitive(ident));
    }

    @Override
    public Schema alterSchema(NameIdentifier ident, SchemaChange ... changes) throws NoSuchSchemaException {
        return this.dispatcher.alterSchema(this.normalizeCaseSensitive(ident), changes);
    }

    @Override
    public boolean dropSchema(NameIdentifier ident, boolean cascade) throws NonEmptySchemaException {
        return this.dispatcher.dropSchema(this.normalizeNameIdentifier(ident), cascade);
    }

    private NameIdentifier normalizeNameIdentifier(NameIdentifier schemaIdent) {
        Capability capabilities = CapabilityHelpers.getCapability(schemaIdent, this.catalogManager);
        return CapabilityHelpers.applyCapabilities(schemaIdent, Capability.Scope.SCHEMA, capabilities);
    }

    private NameIdentifier normalizeCaseSensitive(NameIdentifier schemaIdent) {
        Capability capabilities = CapabilityHelpers.getCapability(schemaIdent, this.catalogManager);
        return CapabilityHelpers.applyCaseSensitive(schemaIdent, Capability.Scope.SCHEMA, capabilities);
    }

    private NameIdentifier[] normalizeCaseSensitive(NameIdentifier[] schemaIdents) {
        if (ArrayUtils.isEmpty((Object[])schemaIdents)) {
            return schemaIdents;
        }
        Capability capabilities = CapabilityHelpers.getCapability(schemaIdents[0], this.catalogManager);
        return CapabilityHelpers.applyCaseSensitive(schemaIdents, Capability.Scope.SCHEMA, capabilities);
    }
}

