/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.casbin.jcasbin.log.Logger;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.rbac.ConditionalRoleManager;
import org.casbin.jcasbin.rbac.RoleManager;
import org.casbin.jcasbin.util.Util;

public class Assertion {
    public String key;
    public String value;
    public String[] tokens;
    public String[] paramsTokens;
    public List<List<String>> policy = new ArrayList<List<String>>();
    public Map<String, Integer> policyIndex = new HashMap<String, Integer>();
    public RoleManager rm;
    public ConditionalRoleManager condRM;
    public int priorityIndex;
    private Logger logger;

    public Assertion() {
    }

    public Assertion(Logger logger) {
        this.setLogger(logger);
    }

    protected void buildRoleLinks(RoleManager rm) {
        this.rm = rm;
        int count = 0;
        for (int i = 0; i < this.value.length(); ++i) {
            if (this.value.charAt(i) != '_') continue;
            ++count;
        }
        for (List<String> rule : this.policy) {
            if (count < 2) {
                throw new IllegalArgumentException("the number of \"_\" in role definition should be at least 2");
            }
            if (rule.size() < count) {
                throw new IllegalArgumentException("grouping policy elements do not meet role definition");
            }
            if (rule.size() > count) {
                rule = rule.subList(0, count);
            }
            this.rm.addLink(rule.get(0), rule.get(1), rule.subList(2, rule.size()).toArray(new String[0]));
        }
        Util.logPrint("Role links for: " + this.key);
        rm.printRoles();
    }

    public void buildIncrementalRoleLinks(RoleManager rm, Model.PolicyOperations op, List<List<String>> rules) {
        this.rm = rm;
        int count = 0;
        for (int i = 0; i < this.value.length(); ++i) {
            if (this.value.charAt(i) != '_') continue;
            ++count;
        }
        block5: for (List<String> rule : rules) {
            if (count < 2) {
                throw new IllegalArgumentException("the number of \"_\" in role definition should be at least 2");
            }
            if (rule.size() < count) {
                throw new IllegalArgumentException("grouping policy elements do not meet role definition");
            }
            if (rule.size() > count) {
                rule = rule.subList(0, count);
            }
            switch (op) {
                case POLICY_ADD: {
                    rm.addLink(rule.get(0), rule.get(1), rule.subList(2, rule.size()).toArray(new String[0]));
                    continue block5;
                }
                case POLICY_REMOVE: {
                    rm.deleteLink(rule.get(0), rule.get(1), rule.subList(2, rule.size()).toArray(new String[0]));
                    continue block5;
                }
            }
            throw new IllegalArgumentException("invalid operation:" + op.toString());
        }
    }

    public void buildIncrementalConditionalRoleLinks(ConditionalRoleManager condRM, Model.PolicyOperations op, List<List<String>> rules) {
        this.condRM = condRM;
        int count = 0;
        for (int i = 0; i < this.value.length(); ++i) {
            if (this.value.charAt(i) != '_') continue;
            ++count;
        }
        if (count < 2) {
            throw new IllegalArgumentException("the number of \"_\" in role definition should be at least 2");
        }
        block5: for (List<String> rule : rules) {
            if (count < 2) {
                throw new IllegalArgumentException("the number of \"_\" in role definition should be at least 2");
            }
            if (rule.size() < count) {
                throw new IllegalArgumentException("grouping policy elements do not meet role definition");
            }
            if (rule.size() > count) {
                rule = rule.subList(0, count);
            }
            List<String> domainRule = rule.subList(2, this.tokens.length);
            switch (op) {
                case POLICY_ADD: {
                    this.addConditionalRoleLink(rule, domainRule);
                    continue block5;
                }
                case POLICY_REMOVE: {
                    condRM.deleteLink(rule.get(0), rule.get(1), rule.subList(2, rule.size()).toArray(new String[0]));
                    continue block5;
                }
            }
            throw new IllegalArgumentException("invalid operation:" + op.toString());
        }
    }

    public void buildConditionalRoleLinks(ConditionalRoleManager condRM) {
        this.condRM = condRM;
        int count = 0;
        for (int i = 0; i < this.value.length(); ++i) {
            if (this.value.charAt(i) != '_') continue;
            ++count;
        }
        for (List<String> rule : this.policy) {
            if (count < 2) {
                throw new IllegalArgumentException("the number of \"_\" in role definition should be at least 2");
            }
            if (rule.size() < count) {
                throw new IllegalArgumentException("grouping policy elements do not meet role definition");
            }
            if (rule.size() > count) {
                rule = rule.subList(0, count);
            }
            List<String> domainRule = rule.subList(2, this.tokens.length);
            this.addConditionalRoleLink(rule, domainRule);
        }
        Util.logPrint("Role links for: " + this.key);
        condRM.printRoles();
    }

    public void addConditionalRoleLink(List<String> rule, List<String> domainRule) {
        int domainRule_num;
        int n = domainRule_num = domainRule != null ? domainRule.size() : 0;
        if (domainRule_num == 0) {
            this.condRM.addLink(rule.get(0), rule.get(1), new String[0]);
            this.condRM.setLinkConditionFuncParams(rule.get(0), rule.get(1), rule.subList(this.tokens.length, rule.size()).toArray(new String[0]));
            this.rm = this.condRM;
        } else {
            String domain = domainRule.get(0);
            this.condRM.addLink(rule.get(0), rule.get(1), new String[0]);
            this.condRM.setDomainLinkConditionFuncParams(rule.get(0), rule.get(1), domain, rule.subList(this.tokens.length, rule.size()).toArray(new String[0]));
            this.rm = this.condRM;
        }
    }

    public void initPriorityIndex() {
        this.priorityIndex = -1;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

