/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cache;

import com.google.common.collect.ImmutableMap;
import org.apache.gravitino.Config;
import org.apache.gravitino.Configs;
import org.apache.gravitino.cache.CaffeineEntityCache;
import org.apache.gravitino.cache.EntityCache;

public final class CacheFactory {
    public static final ImmutableMap<String, String> ENTITY_CACHES = ImmutableMap.of((Object)"caffeine", (Object)CaffeineEntityCache.class.getCanonicalName());

    private CacheFactory() {
    }

    public static EntityCache getEntityCache(Config config) {
        String name = (String)config.get(Configs.CACHE_IMPLEMENTATION);
        String className = (String)ENTITY_CACHES.getOrDefault((Object)name, (Object)name);
        try {
            return (EntityCache)Class.forName(className).getDeclaredConstructor(Config.class).newInstance(config);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create and initialize EntityCache: " + name, e);
        }
    }
}

