/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.invokers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.testng.DataProviderHolder;
import org.testng.DataProviderInvocationException;
import org.testng.IClassListener;
import org.testng.IDataProviderListener;
import org.testng.IHookable;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.IRetryAnalyzer;
import org.testng.ISuite;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.SkipException;
import org.testng.SuiteRunState;
import org.testng.SuiteRunner;
import org.testng.TestException;
import org.testng.TestNGException;
import org.testng.collections.CollectionUtils;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.IConfiguration;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.MethodGroupsHelper;
import org.testng.internal.MethodHelper;
import org.testng.internal.MethodInstance;
import org.testng.internal.Parameters;
import org.testng.internal.RegexpExpectedExceptionsHolder;
import org.testng.internal.RuntimeBehavior;
import org.testng.internal.TestListenerHelper;
import org.testng.internal.TestResult;
import org.testng.internal.invokers.BaseInvoker;
import org.testng.internal.invokers.ConfigInvoker;
import org.testng.internal.invokers.ConfigMethodArguments;
import org.testng.internal.invokers.ExceptionUtils;
import org.testng.internal.invokers.ExpectedExceptionsHolder;
import org.testng.internal.invokers.GroupConfigMethodArguments;
import org.testng.internal.invokers.IInvocationStatus;
import org.testng.internal.invokers.IMethodRunner;
import org.testng.internal.invokers.ITestInvoker;
import org.testng.internal.invokers.InvokeMethodRunnable;
import org.testng.internal.invokers.InvokedMethod;
import org.testng.internal.invokers.InvokedMethodListenerMethod;
import org.testng.internal.invokers.Invoker;
import org.testng.internal.invokers.MethodInvocationHelper;
import org.testng.internal.invokers.ParameterHandler;
import org.testng.internal.invokers.SingleTestMethodWorker;
import org.testng.internal.invokers.TestMethodArguments;
import org.testng.internal.invokers.TestMethodWorker;
import org.testng.internal.invokers.TestNgMethodUtils;
import org.testng.internal.thread.ThreadExecutionException;
import org.testng.internal.thread.ThreadUtil;
import org.testng.thread.IWorker;
import org.testng.xml.XmlSuite;

class TestInvoker
extends BaseInvoker
implements ITestInvoker {
    private final ConfigInvoker invoker;
    private final DataProviderHolder holder;
    private final List<IClassListener> m_classListeners;
    private final boolean m_skipFailedInvocationCounts;

    public TestInvoker(ITestResultNotifier m_notifier, ITestContext m_testContext, SuiteRunState m_suiteState, IConfiguration m_configuration, Collection<IInvokedMethodListener> m_invokedMethodListeners, DataProviderHolder holder, List<IClassListener> m_classListeners, boolean m_skipFailedInvocationCounts, ConfigInvoker invoker) {
        super(m_notifier, m_invokedMethodListeners, m_testContext, m_suiteState, m_configuration);
        this.holder = holder;
        this.m_classListeners = m_classListeners;
        this.m_skipFailedInvocationCounts = m_skipFailedInvocationCounts;
        this.invoker = invoker;
    }

    @Override
    public ITestResultNotifier getNotifier() {
        return this.m_notifier;
    }

    @Override
    public List<ITestResult> invokeTestMethods(ITestNGMethod testMethod, ConfigurationGroupMethods groupMethods, Object instance, ITestContext context) {
        if (testMethod.getTestClass() == null) {
            throw new IllegalArgumentException("COULDN'T FIND TESTCLASS FOR " + testMethod.getRealClass());
        }
        if (!MethodHelper.isEnabled(testMethod.getConstructorOrMethod().getMethod(), this.annotationFinder())) {
            return Collections.emptyList();
        }
        Map<String, String> parameters = testMethod.findMethodParameters(context.getCurrentXmlTest());
        String okToProceed = this.checkDependencies(testMethod);
        if (okToProceed != null) {
            ArrayList<ITestResult> results = new ArrayList<ITestResult>();
            Consumer<ITestResult> resultProcessor = result -> {
                this.m_notifier.addSkippedTest(testMethod, (ITestResult)result);
                InvokedMethod invokedMethod = new InvokedMethod(System.currentTimeMillis(), (ITestResult)result);
                this.invokeListenersForSkippedTestResult((ITestResult)result, invokedMethod);
            };
            boolean reportAllDataDrivenTestsAsSkipped = this.m_configuration.getReportAllDataDrivenTestsAsSkipped();
            if (reportAllDataDrivenTestsAsSkipped && testMethod.isDataDriven()) {
                ParameterHandler handler = new ParameterHandler(this.m_configuration.getObjectFactory(), this.annotationFinder(), this.buildDataProviderHolder(), 1);
                ParameterHandler.ParameterBag bag = handler.createParameters(testMethod, Maps.newHashMap(), Maps.newHashMap(), context, instance);
                Iterator<Object[]> allParamValues = Objects.requireNonNull(bag.parameterHolder).parameters;
                Iterable<Object[]> allParameterValues = CollectionUtils.asIterable(allParamValues);
                for (Object[] next : allParameterValues) {
                    if (next == null) continue;
                    Method m = testMethod.getConstructorOrMethod().getMethod();
                    Object[] parameterValues = Parameters.injectParameters(next, m, context);
                    ITestResult result2 = this.registerSkippedTestResult(testMethod, System.currentTimeMillis(), new Throwable(okToProceed));
                    result2.setParameters(parameterValues);
                    resultProcessor.accept(result2);
                    results.add(result2);
                }
            } else {
                ITestResult result3 = this.registerSkippedTestResult(testMethod, System.currentTimeMillis(), new Throwable(okToProceed));
                resultProcessor.accept(result3);
                results.add(result3);
            }
            testMethod.incrementCurrentInvocationCount();
            GroupConfigMethodArguments args = new GroupConfigMethodArguments.Builder().forTestMethod(testMethod).withGroupConfigMethods(groupMethods).forInstance(instance).withParameters(parameters).build();
            this.invoker.invokeAfterGroupsConfigurations(args);
            return Collections.unmodifiableList(results);
        }
        if (testMethod.getInvocationCount() > 1 && testMethod.getThreadPoolSize() > 1) {
            return this.invokePooledTestMethods(testMethod, parameters, groupMethods, context);
        }
        long timeOutInvocationCount = testMethod.getInvocationTimeOut();
        boolean onlyOne = testMethod.getThreadPoolSize() > 1 || timeOutInvocationCount > 0L;
        ITestClass testClass = testMethod.getTestClass();
        ITestNGMethod[] beforeMethods = TestNgMethodUtils.filterBeforeTestMethods(testClass, Invoker.CAN_RUN_FROM_CLASS);
        ITestNGMethod[] afterMethods = TestNgMethodUtils.filterAfterTestMethods(testClass, Invoker.CAN_RUN_FROM_CLASS);
        int invocationCount = onlyOne ? 1 : testMethod.getInvocationCount();
        TestMethodArguments arguments = new TestMethodArguments.Builder().usingInstance(instance).forTestMethod(testMethod).withParameters(parameters).forTestClass(testClass).usingBeforeMethods(beforeMethods).usingAfterMethods(afterMethods).usingGroupMethods(groupMethods).build();
        MethodInvocationAgent agent = new MethodInvocationAgent(arguments, this, context);
        while (invocationCount-- > 0) {
            invocationCount = agent.invoke(invocationCount);
        }
        return agent.getResult();
    }

    @Override
    public ITestResult invokeTestMethod(TestMethodArguments arguments, XmlSuite suite, ITestInvoker.FailureContext failureContext) {
        arguments.getTestMethod().setId(ThreadUtil.currentThreadInfo());
        return this.invokeMethod(arguments, suite, failureContext);
    }

    @Override
    public ITestInvoker.FailureContext retryFailed(TestMethodArguments arguments, List<ITestResult> result, int failureCount, ITestContext testContext) {
        ITestInvoker.FailureContext failure = new ITestInvoker.FailureContext();
        failure.count = failureCount;
        failure.representsRetriedMethod = true;
        do {
            failure.instances = Lists.newArrayList();
            Map<String, String> allParameters = Maps.newHashMap();
            int verbose = testContext.getCurrentXmlTest().getVerbose();
            ParameterHandler handler = new ParameterHandler(this.m_configuration.getObjectFactory(), this.annotationFinder(), this.holder, verbose);
            ParameterHandler.ParameterBag bag = handler.createParameters(arguments.getTestMethod(), arguments.getParameters(), allParameters, testContext);
            ITestResult errorResult = bag.errorResult;
            if (errorResult != null) {
                Throwable cause = errorResult.getThrowable();
                String m = errorResult.getMethod().getMethodName();
                String msg = String.format("Encountered problems when gathering parameter values for [%s]. Root cause: ", m);
                throw new DataProviderInvocationException(msg, cause);
            }
            Object[] parameterValues = arguments.getParameterValues();
            TestMethodArguments tma = new TestMethodArguments.Builder().usingArguments(arguments).withParameterValues(parameterValues).withParameters(allParameters).build();
            result.add(this.invokeMethod(tma, testContext.getSuite().getXmlSuite(), failure));
        } while (!failure.instances.isEmpty());
        return failure;
    }

    @Override
    public void runTestResultListener(ITestResult tr) {
        boolean isFinished = tr.getStatus() != 16;
        List<ITestListener> listeners = isFinished ? Lists.newReversedArrayList(this.m_notifier.getTestListeners()) : this.m_notifier.getTestListeners();
        TestListenerHelper.runTestListeners(tr, listeners);
    }

    private Collection<IDataProviderListener> dataProviderListeners() {
        ISuite suite = this.m_testContext.getSuite();
        Set<IDataProviderListener> dpListeners = Sets.newHashSet(this.holder.getListeners());
        if (suite instanceof SuiteRunner) {
            Collection<IDataProviderListener> listeners = ((SuiteRunner)suite).getDataProviderListeners();
            dpListeners.addAll(listeners);
        }
        return dpListeners;
    }

    private DataProviderHolder buildDataProviderHolder() {
        DataProviderHolder holder = new DataProviderHolder();
        holder.addListeners(this.dataProviderListeners());
        holder.addInterceptors(this.holder.getInterceptors());
        return holder;
    }

    private String checkDependencies(ITestNGMethod testMethod) {
        ITestNGMethod[] methods;
        if (testMethod.isAlwaysRun()) {
            return null;
        }
        if (testMethod.getMissingGroup() != null && !testMethod.ignoreMissingDependencies()) {
            return "Method " + testMethod + " depends on nonexistent group \"" + testMethod.getMissingGroup() + "\"";
        }
        String[] groups = testMethod.getGroupsDependedUpon();
        ITestNGMethod[] allTestMethods = this.m_testContext.getAllTestMethods();
        if (null != groups && groups.length > 0) {
            for (String element : groups) {
                ITestNGMethod[] methods2 = MethodGroupsHelper.findMethodsThatBelongToGroup(testMethod, allTestMethods, element);
                if (methods2.length == 0 && !testMethod.ignoreMissingDependencies()) {
                    return "Method " + testMethod + " depends on nonexistent group \"" + element + "\"";
                }
                if (!this.failuresPresentInUpstreamDependency(testMethod, methods2)) continue;
                return "Method " + testMethod + " depends on not successfully finished methods in group \"" + element + "\"";
            }
        }
        if (TestNgMethodUtils.cannotRunMethodIndependently(testMethod) && this.failuresPresentInUpstreamDependency(testMethod, methods = MethodHelper.findDependedUponMethods(testMethod, allTestMethods))) {
            return "Method " + testMethod + " depends on not successfully finished methods";
        }
        return null;
    }

    private List<ITestResult> runWorkers(ITestNGMethod testMethod, List<IWorker<ITestNGMethod>> workers, int threadPoolSize, ConfigurationGroupMethods groupMethods, Map<String, String> parameters) {
        Object[] instances;
        ITestClass testClass = testMethod.getTestClass();
        for (Object instance : instances = testClass.getInstances(true)) {
            GroupConfigMethodArguments arguments = new GroupConfigMethodArguments.Builder().forTestMethod(testMethod).withGroupConfigMethods(groupMethods).withParameters(parameters).forInstance(instance).build();
            this.invoker.invokeBeforeGroupsConfigurations(arguments);
        }
        long maxTimeOut = workers.parallelStream().map(IWorker::getTimeOut).max(Long::compare).orElse(-1L);
        ThreadUtil.execute("methods", workers, threadPoolSize, maxTimeOut);
        List<ITestResult> result = workers.parallelStream().filter(tmw -> tmw instanceof TestMethodWorker).flatMap(tmw -> ((TestMethodWorker)tmw).getTestResults().stream()).collect(Collectors.toList());
        for (Object instance : instances) {
            GroupConfigMethodArguments arguments = new GroupConfigMethodArguments.Builder().forTestMethod(testMethod).withGroupConfigMethods(groupMethods).withParameters(parameters).forInstance(instance).build();
            this.invoker.invokeAfterGroupsConfigurations(arguments);
        }
        return result;
    }

    private boolean failuresPresentInUpstreamDependency(ITestNGMethod testMethod, ITestNGMethod[] methods) {
        for (ITestNGMethod method : methods) {
            boolean wasMethodRetried;
            Set<ITestResult> results = this.keepSameInstances(testMethod, this.m_notifier.getPassedTests(method));
            Set<ITestResult> failedAndSkippedMethods = Sets.newHashSet();
            Set<ITestResult> skippedAttempts = this.m_notifier.getSkippedTests(method);
            failedAndSkippedMethods.addAll(this.m_notifier.getFailedTests(method));
            failedAndSkippedMethods.addAll(skippedAttempts);
            Set<ITestResult> failedresults = this.keepSameInstances(testMethod, failedAndSkippedMethods);
            boolean bl = wasMethodRetried = !results.isEmpty() && !skippedAttempts.isEmpty();
            if (!wasMethodRetried && !failedresults.isEmpty()) {
                return true;
            }
            Optional<ITestResult> found = results.parallelStream().filter(testResult -> !testResult.isSuccess()).findAny();
            if (!found.isPresent()) continue;
            return true;
        }
        return false;
    }

    private Set<ITestResult> keepSameInstances(ITestNGMethod method, Set<ITestResult> results) {
        return results.parallelStream().filter(r -> {
            Object instance = r.getInstance() != null ? r.getInstance() : r.getMethod().getInstance();
            return r.getTestClass() != method.getTestClass() || instance == method.getInstance();
        }).collect(Collectors.toSet());
    }

    private List<ITestResult> invokePooledTestMethods(ITestNGMethod testMethod, Map<String, String> parameters, ConfigurationGroupMethods groupMethods, ITestContext testContext) {
        List<IWorker<ITestNGMethod>> workers = Lists.newArrayList();
        for (int i = 0; i < testMethod.getInvocationCount(); ++i) {
            ITestNGMethod clonedMethod = testMethod.clone();
            clonedMethod.setInvocationCount(1);
            clonedMethod.setThreadPoolSize(1);
            MethodInstance mi = new MethodInstance(clonedMethod);
            workers.add(new SingleTestMethodWorker(this, this.invoker, mi, parameters, testContext, this.m_classListeners));
        }
        return this.runWorkers(testMethod, workers, testMethod.getThreadPoolSize(), groupMethods, parameters);
    }

    private void collectResults(ITestNGMethod testMethod, ITestResult result) {
        int status = result.getStatus();
        if (1 == status) {
            this.m_notifier.addPassedTest(testMethod, result);
        } else if (3 == status) {
            this.m_notifier.addSkippedTest(testMethod, result);
        } else if (2 == status) {
            this.m_notifier.addFailedTest(testMethod, result);
        } else if (4 == status) {
            this.m_notifier.addFailedButWithinSuccessPercentageTest(testMethod, result);
        } else assert (false) : "UNKNOWN STATUS:" + status;
    }

    @Override
    public void invokeListenersForSkippedTestResult(ITestResult r, IInvokedMethod invokedMethod) {
        if (this.m_configuration.alwaysRunListeners()) {
            this.runInvokedMethodListeners(InvokedMethodListenerMethod.BEFORE_INVOCATION, invokedMethod, r);
            this.runInvokedMethodListeners(InvokedMethodListenerMethod.AFTER_INVOCATION, invokedMethod, r);
        }
        this.runTestResultListener(r);
    }

    private static void setTestStatus(ITestResult result, int status) {
        if (result.getStatus() == 16) {
            result.setStatus(status);
        }
    }

    private void handleInvocationResult(ITestNGMethod testMethod, ITestResult testResult, ITestInvoker.FailureContext failure, StatusHolder holder, boolean willRetry) {
        if (willRetry) {
            Object instance = testResult.getInstance();
            if (!failure.instances.contains(instance)) {
                failure.instances.add(instance);
            }
            testResult.setStatus(3);
            testResult.setWasRetried(true);
        } else {
            testResult.setStatus(holder.status);
            if (holder.status == 2 && !holder.handled) {
                int count = failure.count++;
                if (testMethod.isDataDriven()) {
                    count = 0;
                }
                this.handleException(testResult.getThrowable(), testMethod, testResult, count);
            }
        }
    }

    private boolean shouldRetryTestMethod(ITestNGMethod testMethod, ITestResult testResult, ITestInvoker.FailureContext failure, StatusHolder holder) {
        IRetryAnalyzer retryAnalyzer = testMethod.getRetryAnalyzer(testResult);
        return retryAnalyzer != null && holder.status == 2 && failure.instances != null && retryAnalyzer.retry(testResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITestResult invokeMethod(TestMethodArguments arguments, XmlSuite suite, ITestInvoker.FailureContext failureContext) {
        TestResult testResult = TestResult.newEmptyTestResult();
        testResult.setParameters(arguments.getParameterValues());
        testResult.setParameterIndex(arguments.getParametersIndex());
        testResult.setHost(this.m_testContext.getHost());
        GroupConfigMethodArguments cfgArgs = new GroupConfigMethodArguments.Builder().forTestMethod(arguments.getTestMethod()).withGroupConfigMethods(arguments.getGroupMethods()).withParameters(arguments.getParameters()).forInstance(arguments.getInstance()).build();
        this.invoker.invokeBeforeGroupsConfigurations(cfgArgs);
        ITestNGMethod[] setupConfigMethods = TestNgMethodUtils.filterSetupConfigurationMethods(arguments.getTestMethod(), arguments.getBeforeMethods());
        this.runConfigMethods(arguments, suite, testResult, setupConfigMethods);
        long startTime = System.currentTimeMillis();
        InvokedMethod invokedMethod = new InvokedMethod(startTime, testResult);
        if (!failureContext.representsRetriedMethod && this.invoker.hasConfigurationFailureFor(arguments.getTestMethod(), arguments.getTestMethod().getGroups(), arguments.getTestClass(), arguments.getInstance())) {
            Throwable exception = ExceptionUtils.getExceptionDetails(this.m_testContext, arguments.getInstance());
            ITestResult result = this.registerSkippedTestResult(arguments.getTestMethod(), System.currentTimeMillis(), exception, testResult);
            result.setParameters(testResult.getParameters());
            TestResult.copyAttributes(testResult, result);
            this.m_notifier.addSkippedTest(arguments.getTestMethod(), result);
            arguments.getTestMethod().incrementCurrentInvocationCount();
            testResult.setMethod(arguments.getTestMethod());
            invokedMethod = new InvokedMethod(startTime, result);
            this.invokeListenersForSkippedTestResult(result, invokedMethod);
            this.runAfterConfigurations(arguments, suite, testResult);
            this.runAfterGroupsConfigurations(arguments);
            return result;
        }
        try {
            IHookable hookableInstance;
            testResult = TestResult.newTestResultFrom(testResult, arguments.getTestMethod(), this.m_testContext, System.currentTimeMillis());
            invokedMethod = new InvokedMethod(invokedMethod.getDate(), testResult);
            testResult.setStatus(16);
            Reporter.setCurrentTestResult(testResult);
            if (!this.m_suiteState.isFailed()) {
                this.runTestResultListener(testResult);
            }
            TestInvoker.log(3, "Invoking " + arguments.getTestMethod().getQualifiedName());
            this.runInvokedMethodListeners(InvokedMethodListenerMethod.BEFORE_INVOCATION, invokedMethod, testResult);
            if (testResult.getStatus() == 3) {
                TestResult exception = testResult;
                return exception;
            }
            if (arguments.getTestMethod() instanceof IInvocationStatus) {
                ((IInvocationStatus)((Object)arguments.getTestMethod())).setInvokedAt(invokedMethod.getDate());
            }
            Method thisMethod = arguments.getTestMethod().getConstructorOrMethod().getMethod();
            if (RuntimeBehavior.isDryRun()) {
                TestInvoker.setTestStatus(testResult, 1);
                TestResult expectedExceptionClasses = testResult;
                return expectedExceptionClasses;
            }
            IHookable iHookable = hookableInstance = IHookable.class.isAssignableFrom(arguments.getTestMethod().getRealClass()) ? (IHookable)arguments.getInstance() : this.m_configuration.getHookable();
            if (MethodHelper.calculateTimeOut(arguments.getTestMethod()) <= 0L) {
                if (hookableInstance != null) {
                    MethodInvocationHelper.invokeHookable(arguments.getInstance(), arguments.getParameterValues(), hookableInstance, thisMethod, testResult);
                } else {
                    MethodInvocationHelper.invokeMethod(thisMethod, arguments.getInstance(), arguments.getParameterValues());
                }
                TestInvoker.setTestStatus(testResult, 1);
            } else {
                MethodInvocationHelper.invokeWithTimeout(arguments.getTestMethod(), arguments.getInstance(), arguments.getParameterValues(), testResult, hookableInstance);
            }
        }
        catch (InvocationTargetException ite) {
            testResult.setThrowable(ite.getCause());
            TestInvoker.setTestStatus(testResult, 2);
        }
        catch (ThreadExecutionException tee) {
            Throwable cause = tee.getCause();
            if (InvokeMethodRunnable.TestNGRuntimeException.class.equals(cause.getClass())) {
                testResult.setThrowable(cause.getCause());
            } else {
                testResult.setThrowable(cause);
            }
            TestInvoker.setTestStatus(testResult, 2);
        }
        catch (Throwable thr) {
            testResult.setThrowable(thr);
            int status = 2;
            if (thr instanceof SkipException) {
                status = 3;
            }
            TestInvoker.setTestStatus(testResult, status);
        }
        finally {
            testResult.setEndMillis(System.currentTimeMillis());
            ExpectedExceptionsHolder expectedExceptionClasses = new ExpectedExceptionsHolder(this.annotationFinder(), arguments.getTestMethod(), new RegexpExpectedExceptionsHolder(this.annotationFinder(), arguments.getTestMethod()));
            StatusHolder holder = this.considerExceptions(arguments.getTestMethod(), testResult, expectedExceptionClasses, failureContext);
            this.runInvokedMethodListeners(InvokedMethodListenerMethod.AFTER_INVOCATION, invokedMethod, testResult);
            TestInvoker.updateStatusHolderAccordingToTestResult(testResult, holder);
            boolean willRetryMethod = this.shouldRetryTestMethod(arguments.getTestMethod(), testResult, failureContext, holder);
            this.handleInvocationResult(arguments.getTestMethod(), testResult, failureContext, holder, willRetryMethod);
            if (testResult.getThrowable() != null && (arguments.getParameterValues().length > 0 || testResult.getFactoryParameters().length > 0)) {
                int parametersIndex = arguments.getParametersIndex();
                if (null != testResult.getMethod().getFactoryMethodParamsInfo()) {
                    parametersIndex = testResult.getMethod().getFactoryMethodParamsInfo().getIndex();
                }
                arguments.getTestMethod().addFailedInvocationNumber(parametersIndex);
            }
            arguments.getTestMethod().incrementCurrentInvocationCount();
            this.runTestResultListener(testResult);
            this.collectResults(arguments.getTestMethod(), testResult);
            this.runAfterConfigurations(arguments, suite, testResult);
            if (!willRetryMethod) {
                this.runAfterGroupsConfigurations(arguments);
            }
            Reporter.setCurrentTestResult(null);
        }
        return testResult;
    }

    private void runAfterConfigurations(TestMethodArguments arguments, XmlSuite suite, TestResult testResult) {
        ITestNGMethod[] teardownConfigMethods = TestNgMethodUtils.filterTeardownConfigurationMethods(arguments.getTestMethod(), arguments.getAfterMethods());
        this.runConfigMethods(arguments, suite, testResult, teardownConfigMethods);
    }

    private void runAfterGroupsConfigurations(TestMethodArguments arguments) {
        GroupConfigMethodArguments grpArgs = new GroupConfigMethodArguments.Builder().forTestMethod(arguments.getTestMethod()).withGroupConfigMethods(arguments.getGroupMethods()).withParameters(arguments.getParameters()).forInstance(arguments.getInstance()).build();
        this.invoker.invokeAfterGroupsConfigurations(grpArgs);
    }

    private void runConfigMethods(TestMethodArguments arguments, XmlSuite suite, TestResult testResult, ITestNGMethod[] teardownConfigMethods) {
        ConfigMethodArguments cfgArgs = new ConfigMethodArguments.Builder().forTestClass(arguments.getTestClass()).forTestMethod(arguments.getTestMethod()).usingConfigMethodsAs(teardownConfigMethods).forSuite(suite).usingParameters(arguments.getParameters()).usingParameterValues(arguments.getParameterValues()).usingInstance(arguments.getInstance()).withResult(testResult).build();
        this.invoker.invokeConfigurations(cfgArgs);
    }

    @Override
    public ITestResult registerSkippedTestResult(ITestNGMethod testMethod, long start, Throwable throwable, ITestResult source) {
        TestResult result = TestResult.newEndTimeAwareTestResult(testMethod, this.m_testContext, throwable, start);
        if (source != null) {
            TestResult.copyAttributes(source, result);
            result.setParameters(source.getParameters());
        }
        result.setStatus(16);
        this.runTestResultListener(result);
        result.setStatus(3);
        Reporter.setCurrentTestResult(result);
        return result;
    }

    private StatusHolder considerExceptions(ITestNGMethod tm, ITestResult testResult, ExpectedExceptionsHolder exceptionsHolder, ITestInvoker.FailureContext failure) {
        TestException exception;
        StatusHolder holder = new StatusHolder();
        int status = testResult.getStatus();
        holder.handled = false;
        Throwable ite = testResult.getThrowable();
        if (status == 2 && ite != null) {
            if (exceptionsHolder != null) {
                if (exceptionsHolder.isExpectedException(ite)) {
                    testResult.setStatus(1);
                    status = 1;
                } else if (this.isSkipExceptionAndSkip(ite)) {
                    status = 3;
                } else {
                    testResult.setThrowable(exceptionsHolder.wrongException(ite));
                    status = 2;
                }
            } else {
                this.handleException(ite, tm, testResult, failure.count++);
                holder.handled = true;
                status = testResult.getStatus();
            }
        } else if (status != 3 && exceptionsHolder != null && (exception = exceptionsHolder.noException(tm)) != null) {
            testResult.setThrowable(exception);
            status = 2;
        }
        holder.originalStatus = testResult.getStatus();
        holder.status = status;
        return holder;
    }

    private static void updateStatusHolderAccordingToTestResult(ITestResult testResult, StatusHolder holder) {
        if (holder.originalStatus != testResult.getStatus()) {
            holder.status = testResult.getStatus();
        }
    }

    private class MethodInvocationAgent {
        private final ITestContext context;
        private final List<ITestResult> result = Lists.newArrayList();
        private final ITestInvoker.FailureContext failure = new ITestInvoker.FailureContext();
        private final ITestInvoker invoker;
        private final TestMethodArguments arguments;

        public MethodInvocationAgent(TestMethodArguments arguments, ITestInvoker invoker, ITestContext context) {
            this.arguments = arguments;
            this.invoker = invoker;
            this.context = context;
        }

        public List<ITestResult> getResult() {
            return this.result;
        }

        public int invoke(int invCount) {
            AtomicInteger invocationCount = new AtomicInteger(invCount);
            long start = System.currentTimeMillis();
            Map<String, String> allParameterNames = Maps.newHashMap();
            int verbose = this.context.getCurrentXmlTest().getVerbose();
            ParameterHandler handler = new ParameterHandler(TestInvoker.this.m_configuration.getObjectFactory(), TestInvoker.this.annotationFinder(), TestInvoker.this.buildDataProviderHolder(), verbose);
            ParameterHandler.ParameterBag bag = handler.createParameters(this.arguments.getTestMethod(), this.arguments.getParameters(), allParameterNames, this.context, this.arguments.getInstance());
            if (bag.hasErrors()) {
                ITestResult tr = bag.errorResult;
                Throwable throwable = Objects.requireNonNull(tr).getThrowable();
                if (throwable instanceof TestNGException) {
                    tr.setStatus(2);
                    TestInvoker.this.m_notifier.addFailedTest(this.arguments.getTestMethod(), tr);
                } else {
                    tr.setStatus(3);
                    TestInvoker.this.m_notifier.addSkippedTest(this.arguments.getTestMethod(), tr);
                }
                TestInvoker.this.runTestResultListener(tr);
                this.result.add(tr);
                return invocationCount.get();
            }
            Iterator<Object[]> allParameterValues = Objects.requireNonNull(bag.parameterHolder).parameters;
            try {
                IMethodRunner runner = this.invoker.getRunner();
                if (bag.runInParallel()) {
                    List<ITestResult> parallel = runner.runInParallel(this.arguments, this.invoker, this.context, invocationCount, this.failure, allParameterValues, TestInvoker.this.m_skipFailedInvocationCounts);
                    this.result.addAll(parallel);
                } else {
                    List<ITestResult> sequential = runner.runInSequence(this.arguments, this.invoker, this.context, invocationCount, this.failure, allParameterValues, TestInvoker.this.m_skipFailedInvocationCounts);
                    this.result.addAll(sequential);
                }
            }
            catch (Throwable cause) {
                TestResult r = TestResult.newEndTimeAwareTestResult(this.arguments.getTestMethod(), TestInvoker.this.m_testContext, cause, start);
                r.setStatus(2);
                this.result.add(r);
                TestInvoker.this.runTestResultListener(r);
                TestInvoker.this.m_notifier.addFailedTest(this.arguments.getTestMethod(), r);
            }
            return invocationCount.get();
        }
    }

    private static class StatusHolder {
        boolean handled = false;
        int originalStatus;
        int status;

        private StatusHolder() {
        }
    }
}

