/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars;

import groovy.lang.Closure;
import groovy.time.Duration;
import groovyx.gpars.GParsConfig;
import groovyx.gpars.GParsPool;
import groovyx.gpars.extra166y.Ops;
import groovyx.gpars.extra166y.ParallelArray;
import groovyx.gpars.memoize.LRUProtectionStorage;
import groovyx.gpars.pa.CallAsyncTask;
import groovyx.gpars.pa.CallClosure;
import groovyx.gpars.pa.ClosureMapper;
import groovyx.gpars.pa.ClosureNegationPredicate;
import groovyx.gpars.pa.ClosurePredicate;
import groovyx.gpars.pa.ClosureReducer;
import groovyx.gpars.pa.GParsPoolUtilHelper;
import groovyx.gpars.pa.PAWrapper;
import groovyx.gpars.pa.SumClosure;
import groovyx.gpars.scheduler.FJPool;
import groovyx.gpars.util.GeneralTimer;
import groovyx.gpars.util.PAGroovyUtils;
import groovyx.gpars.util.PAUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import jsr166y.ForkJoinPool;
import jsr166y.ForkJoinTask;
import jsr166y.RecursiveTask;

public class GParsPoolUtil {
    private static final GeneralTimer timer = GParsConfig.retrieveDefaultTimer("GParsTimeoutTimer", true);

    private static ForkJoinPool retrievePool() {
        ForkJoinPool pool = (ForkJoinPool)GParsPool.retrieveCurrentPool();
        if (pool == null) {
            throw new IllegalStateException("No ForkJoinPool available for the current thread");
        }
        return pool;
    }

    public static <T> Future<T> callParallel(Closure<T> task) {
        ForkJoinPool pool = (ForkJoinPool)GParsPool.retrieveCurrentPool();
        if (pool == null) {
            throw new IllegalStateException("No ForkJoinPool available for the current thread.");
        }
        return pool.submit(new CallAsyncTask<T>(task));
    }

    public static <T> Future<T> callAsync(Closure<T> cl, Object ... args) {
        return GParsPoolUtilHelper.callAsync(cl, args);
    }

    public static <T> Future<T> callTimeoutAsync(Closure<T> cl, long timeout, Object ... args) {
        final Future<T> f = GParsPoolUtil.callAsync(cl, args);
        timer.schedule(new Runnable(){

            @Override
            public void run() {
                f.cancel(true);
            }
        }, timeout);
        return f;
    }

    public static <T> Future<T> callTimeoutAsync(Closure<T> cl, Duration timeout, Object ... args) {
        return GParsPoolUtil.callTimeoutAsync(cl, timeout.toMilliseconds(), args);
    }

    public static <T> Future<T> leftShift(ForkJoinPool pool, final Closure<T> task) {
        return pool.submit((ForkJoinTask)new RecursiveTask<T>(){

            protected T compute() {
                return task.call();
            }
        });
    }

    public static Closure async(Closure cl) {
        return GParsPoolUtilHelper.async(cl);
    }

    public static Closure asyncFun(Closure original) {
        return GParsPoolUtil.asyncFun(original, false);
    }

    public static Closure asyncFun(Closure original, boolean blocking) {
        return GParsPoolUtilHelper.asyncFun(original, blocking);
    }

    public static Closure asyncFun(Closure original, FJPool pool) {
        return GParsPoolUtil.asyncFun(original, pool, false);
    }

    public static Closure asyncFun(Closure original, FJPool pool, boolean blocking) {
        return GParsPoolUtilHelper.asyncFun(original, blocking, pool);
    }

    @Deprecated
    public static <T> Closure<T> gmemoize(Closure<T> cl) {
        return GParsPoolUtilHelper.buildMemoizeFunction(new ConcurrentHashMap(), cl);
    }

    @Deprecated
    public static <T> Closure<T> gmemoizeAtMost(Closure<T> cl, int maxCacheSize) {
        if (maxCacheSize < 0) {
            throw new IllegalArgumentException("A non-negative number is required as the maxCacheSize parameter for gmemoizeAtMost.");
        }
        return GParsPoolUtilHelper.buildMemoizeFunction(Collections.synchronizedMap(new LRUProtectionStorage(maxCacheSize)), cl);
    }

    @Deprecated
    public static <T> Closure<T> gmemoizeAtLeast(Closure<T> cl, int protectedCacheSize) {
        if (protectedCacheSize < 0) {
            throw new IllegalArgumentException("A non-negative number is required as the protectedCacheSize parameter for gmemoizeAtLeast.");
        }
        return GParsPoolUtilHelper.buildSoftReferenceMemoizeFunction(protectedCacheSize, new ConcurrentHashMap(), cl);
    }

    @Deprecated
    public static <T> Closure<T> gmemoizeBetween(Closure<T> cl, int protectedCacheSize, int maxCacheSize) {
        if (protectedCacheSize < 0) {
            throw new IllegalArgumentException("A non-negative number is required as the protectedCacheSize parameter for gmemoizeBetween.");
        }
        if (maxCacheSize < 0) {
            throw new IllegalArgumentException("A non-negative number is required as the maxCacheSize parameter for gmemoizeBetween.");
        }
        if (protectedCacheSize > maxCacheSize) {
            throw new IllegalArgumentException("The maxCacheSize parameter to gmemoizeBetween is required to be greater or equal to the protectedCacheSize parameter.");
        }
        return GParsPoolUtilHelper.buildSoftReferenceMemoizeFunction(protectedCacheSize, Collections.synchronizedMap(new LRUProtectionStorage(maxCacheSize)), cl);
    }

    private static <K, V> ParallelArray<Map.Entry<K, V>> createPA(Map<K, V> collection, ForkJoinPool pool) {
        return GParsPoolUtilHelper.createPAFromArray(PAUtils.createArray(collection), pool);
    }

    public static Object makeConcurrent(Object collection) {
        return GParsPoolUtilHelper.makeConcurrent(collection);
    }

    public static Object makeSequential(Object collection) {
        return GParsPoolUtilHelper.makeSequential(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void asConcurrent(Object collection, Closure code) {
        GParsPoolUtil.makeConcurrent(collection);
        try {
            code.call(collection);
        }
        finally {
            GParsPoolUtil.makeSequential(collection);
        }
    }

    public static boolean isConcurrent(Object collection) {
        return false;
    }

    public static <T> Collection<T> eachParallel(Collection<T> collection, Closure cl) {
        GParsPoolUtilHelper.eachParallelPA(GParsPoolUtilHelper.createPAFromCollection(collection, GParsPoolUtil.retrievePool()), cl);
        return collection;
    }

    public static <T> T eachParallel(T collection, Closure cl) {
        GParsPoolUtilHelper.eachParallelPA(GParsPoolUtilHelper.createPA(collection, GParsPoolUtil.retrievePool()), cl);
        return collection;
    }

    public static <K, V> Map<K, V> eachParallel(Map<K, V> collection, Closure cl) {
        GParsPoolUtilHelper.eachParallelPA(GParsPoolUtil.createPA(collection, GParsPoolUtil.retrievePool()), PAUtils.buildClosureForMaps(cl));
        return collection;
    }

    public static <T> Collection<T> eachWithIndexParallel(Collection<T> collection, Closure cl) {
        ArrayList<List<Object>> indexedCollection = new ArrayList<List<Object>>();
        int index = 0;
        for (T element : collection) {
            indexedCollection.add(Arrays.asList(element, index));
            ++index;
        }
        ParallelArray<List<Object>> paFromCollection = GParsPoolUtilHelper.createPAFromCollection(indexedCollection, GParsPoolUtil.retrievePool());
        GParsPoolUtilHelper.eachWithIndex(paFromCollection, cl).all();
        return collection;
    }

    public static <T> T eachWithIndexParallel(T collection, Closure cl) {
        GParsPoolUtil.eachWithIndexParallel(PAGroovyUtils.createCollection(collection), cl);
        return collection;
    }

    public static <K, V> Map<K, V> eachWithIndexParallel(Map<K, V> collection, Closure cl) {
        GParsPoolUtil.eachWithIndexParallel(PAGroovyUtils.createCollection(collection), PAUtils.buildClosureForMapsWithIndex(cl));
        return collection;
    }

    public static <T> Collection<T> collectParallel(Collection collection, Closure<? extends T> cl) {
        return GParsPoolUtilHelper.createPAFromCollection(collection, GParsPoolUtil.retrievePool()).withMapping(new ClosureMapper<T>(new CallClosure<T>(cl))).all().asList();
    }

    public static <T> Collection<T> collectParallel(Object collection, Closure<? extends T> cl) {
        return GParsPoolUtilHelper.createPA(collection, GParsPoolUtil.retrievePool()).withMapping(new ClosureMapper<T>(new CallClosure<T>(cl))).all().asList();
    }

    public static <T> Collection<T> collectParallel(Map collection, Closure<? extends T> cl) {
        return GParsPoolUtil.createPA(collection, GParsPoolUtil.retrievePool()).withMapping(new ClosureMapper<T>(PAUtils.buildClosureForMaps(cl))).all().asList();
    }

    public static <T> List<T> collectManyParallel(Collection collection, Closure<Collection<? extends T>> projection) {
        return GParsPoolUtilHelper.createPAFromCollection(collection, GParsPoolUtil.retrievePool()).withMapping(new ClosureMapper<Collection<? extends T>>(new CallClosure<Collection<? extends T>>(projection))).reduce(new ClosureReducer(SumClosure.getInstance()), null);
    }

    public static <T> List<T> collectManyParallel(Object collection, Closure<Collection<? extends T>> projection) {
        return GParsPoolUtilHelper.createPA(collection, GParsPoolUtil.retrievePool()).withMapping(new ClosureMapper<Collection<? extends T>>(new CallClosure<Collection<? extends T>>(projection))).reduce(new ClosureReducer(SumClosure.getInstance()), null);
    }

    public static <T> List<T> collectManyParallel(Map collection, Closure<Collection<? extends T>> projection) {
        return GParsPoolUtil.createPA(collection, GParsPoolUtil.retrievePool()).withMapping(new ClosureMapper<Collection<? extends T>>(PAUtils.buildClosureForMaps(projection))).reduce(new ClosureReducer(SumClosure.getInstance()), null);
    }

    public static <T> Collection<T> findAllParallel(Collection<T> collection, Closure cl) {
        return GParsPoolUtilHelper.findAllParallelPA(GParsPoolUtilHelper.createPAFromCollection(collection, GParsPoolUtil.retrievePool()), cl);
    }

    public static Collection<Object> findAllParallel(Object collection, Closure cl) {
        return GParsPoolUtilHelper.findAllParallelPA(GParsPoolUtilHelper.createPA(collection, GParsPoolUtil.retrievePool()), cl);
    }

    public static <K, V> Map<K, V> findAllParallel(Map<K, V> collection, Closure cl) {
        return PAUtils.buildResultMap(GParsPoolUtilHelper.findAllParallelPA(GParsPoolUtil.createPA(collection, GParsPoolUtil.retrievePool()), PAUtils.buildClosureForMaps(cl)));
    }

    public static <T> T findParallel(Collection<T> collection, Closure cl) {
        return GParsPoolUtilHelper.findParallelPA(GParsPoolUtilHelper.createPAFromCollection(collection, GParsPoolUtil.retrievePool()), cl);
    }

    public static Object findParallel(Object collection, Closure cl) {
        return GParsPoolUtilHelper.findParallelPA(GParsPoolUtilHelper.createPA(collection, GParsPoolUtil.retrievePool()), cl);
    }

    public static <K, V> Map.Entry<K, V> findParallel(Map<K, V> collection, Closure cl) {
        return GParsPoolUtilHelper.findParallelPA(GParsPoolUtil.createPA(collection, GParsPoolUtil.retrievePool()), PAUtils.buildClosureForMaps(cl));
    }

    public static <T> T findAnyParallel(Collection<T> collection, Closure cl) {
        return GParsPoolUtilHelper.findAnyParallelPA(GParsPoolUtilHelper.createPAFromCollection(collection, GParsPoolUtil.retrievePool()), cl);
    }

    public static Object findAnyParallel(Object collection, Closure cl) {
        return GParsPoolUtilHelper.findAnyParallelPA(GParsPoolUtilHelper.createPA(collection, GParsPoolUtil.retrievePool()), cl);
    }

    public static <K, V> Map.Entry<K, V> findAnyParallel(Map<K, V> collection, Closure cl) {
        return GParsPoolUtilHelper.findAnyParallelPA(GParsPoolUtil.createPA(collection, GParsPoolUtil.retrievePool()), PAUtils.buildClosureForMaps(cl));
    }

    public static <T> Collection<T> grepParallel(Collection<T> collection, Object filter) {
        return GParsPoolUtilHelper.grepParallelPA(GParsPoolUtilHelper.createPAFromCollection(collection, GParsPoolUtil.retrievePool()), filter);
    }

    public static Object grepParallel(Object collection, Object filter) {
        return GParsPoolUtilHelper.grepParallelPA(GParsPoolUtilHelper.createPA(collection, GParsPoolUtil.retrievePool()), filter);
    }

    public static <K, V> Map<K, V> grepParallel(Map<K, V> collection, Object filter) {
        return PAUtils.buildResultMap(GParsPoolUtilHelper.grepParallelPA(GParsPoolUtil.createPA(collection, GParsPoolUtil.retrievePool()), filter instanceof Closure ? PAUtils.buildClosureForMaps((Closure)filter) : filter));
    }

    public static <T> Collection<T> splitParallel(Collection<T> collection, Object filter) {
        Map groups = GParsPoolUtil.groupByParallel(collection, (Closure)filter);
        return Arrays.asList(groups.containsKey(Boolean.TRUE) ? groups.get(Boolean.TRUE) : new ArrayList(), groups.containsKey(Boolean.FALSE) ? groups.get(Boolean.FALSE) : new ArrayList());
    }

    public static Object splitParallel(Object collection, Object filter) {
        Map groups = GParsPoolUtil.groupByParallelPA(GParsPoolUtilHelper.createPA(collection, GParsPoolUtil.retrievePool()), (Closure)filter);
        return Arrays.asList(groups.containsKey(Boolean.TRUE) ? groups.get(Boolean.TRUE) : new ArrayList(), groups.containsKey(Boolean.FALSE) ? groups.get(Boolean.FALSE) : new ArrayList());
    }

    public static int countParallel(Collection collection, final Object filter) {
        return GParsPoolUtilHelper.createPAFromCollection(collection, GParsPoolUtil.retrievePool()).withFilter(new Ops.Predicate<Object>(){

            @Override
            public boolean op(Object o) {
                return filter.equals(o);
            }
        }).size();
    }

    public static int countParallel(Object collection, final Object filter) {
        return GParsPoolUtilHelper.createPA(collection, GParsPoolUtil.retrievePool()).withFilter(new Ops.Predicate<Object>(){

            @Override
            public boolean op(Object o) {
                return filter.equals(o);
            }
        }).size();
    }

    public static int countParallel(Collection collection, Closure filter) {
        return GParsPoolUtilHelper.createPAFromCollection(collection, GParsPoolUtil.retrievePool()).withFilter(new ClosurePredicate(filter)).size();
    }

    public static int countParallel(Object collection, Closure filter) {
        return GParsPoolUtilHelper.createPA(collection, GParsPoolUtil.retrievePool()).withFilter(new ClosurePredicate(filter)).size();
    }

    public static boolean anyParallel(Collection collection, Closure cl) {
        return GParsPoolUtilHelper.createPAFromCollection(collection, GParsPoolUtil.retrievePool()).withFilter(new ClosurePredicate(cl)).any() != null;
    }

    public static boolean anyParallel(Object collection, Closure cl) {
        return GParsPoolUtilHelper.createPA(collection, GParsPoolUtil.retrievePool()).withFilter(new ClosurePredicate(cl)).any() != null;
    }

    public static boolean anyParallel(Map collection, Closure cl) {
        Closure mapClosure = PAUtils.buildClosureForMaps(cl);
        return GParsPoolUtil.createPA(collection, GParsPoolUtil.retrievePool()).withFilter(new ClosurePredicate(mapClosure)).any() != null;
    }

    public static boolean everyParallel(Collection collection, Closure cl) {
        return GParsPoolUtilHelper.createPAFromCollection(collection, GParsPoolUtil.retrievePool()).withFilter(new ClosureNegationPredicate(cl)).any() == null;
    }

    public static boolean everyParallel(Object collection, Closure cl) {
        return GParsPoolUtilHelper.createPA(collection, GParsPoolUtil.retrievePool()).withFilter(new ClosureNegationPredicate(cl)).any() == null;
    }

    public static boolean everyParallel(Map collection, Closure cl) {
        Closure mapClosure = PAUtils.buildClosureForMaps(cl);
        return GParsPoolUtil.createPA(collection, GParsPoolUtil.retrievePool()).withFilter(new ClosureNegationPredicate(mapClosure)).any() == null;
    }

    public static <K, T> Map<K, List<T>> groupByParallel(Collection<T> collection, Closure<K> cl) {
        return GParsPoolUtil.groupByParallelPA(GParsPoolUtilHelper.createPAFromCollection(collection, GParsPoolUtil.retrievePool()), cl);
    }

    public static <K> Map<K, List<Object>> groupByParallel(Object collection, Closure<K> cl) {
        return GParsPoolUtil.groupByParallelPA(GParsPoolUtilHelper.createPA(collection, GParsPoolUtil.retrievePool()), cl);
    }

    private static <K, T> Map<K, List<T>> groupByParallelPA(ParallelArray<T> pa, Closure<K> cl) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        GParsPoolUtilHelper.eachParallelPA(pa, PAUtils.createGroupByClosure(cl, map));
        return map;
    }

    public static <T> T minParallel(Collection<T> collection, Closure cl) {
        return (T)GParsPoolUtilHelper.createPAFromCollection(collection, GParsPoolUtil.retrievePool()).min(PAUtils.createComparator((Closure<Object>)cl));
    }

    public static Object minParallel(Object collection, Closure cl) {
        return GParsPoolUtilHelper.createPA(collection, GParsPoolUtil.retrievePool()).min(PAUtils.createComparator((Closure<Object>)cl));
    }

    public static <T> T minParallel(Collection<T> collection) {
        return GParsPoolUtilHelper.createPAFromCollection(collection, GParsPoolUtil.retrievePool()).min();
    }

    public static Object minParallel(Object collection) {
        return GParsPoolUtilHelper.createPA(collection, GParsPoolUtil.retrievePool()).min();
    }

    public static <T> T maxParallel(Collection<T> collection, Closure cl) {
        return (T)GParsPoolUtilHelper.createPAFromCollection(collection, GParsPoolUtil.retrievePool()).max(PAUtils.createComparator((Closure<Object>)cl));
    }

    public static Object maxParallel(Object collection, Closure cl) {
        return GParsPoolUtilHelper.createPA(collection, GParsPoolUtil.retrievePool()).max(PAUtils.createComparator((Closure<Object>)cl));
    }

    public static <T> T maxParallel(Collection<T> collection) {
        return GParsPoolUtilHelper.createPAFromCollection(collection, GParsPoolUtil.retrievePool()).max();
    }

    public static Object maxParallel(Object collection) {
        return GParsPoolUtilHelper.createPA(collection, GParsPoolUtil.retrievePool()).max();
    }

    public static <T> T sumParallel(Collection<T> collection) {
        return GParsPoolUtil.foldParallel(collection, (Closure)SumClosure.getInstance());
    }

    public static Object sumParallel(Object collection) {
        return GParsPoolUtil.foldParallel(collection, (Closure)SumClosure.getInstance());
    }

    @Deprecated
    public static <T> T foldParallel(Collection<T> collection, Closure cl) {
        return GParsPoolUtilHelper.createPAFromCollection(collection, GParsPoolUtil.retrievePool()).reduce(new ClosureReducer(cl), (Object)null);
    }

    @Deprecated
    public static Object foldParallel(Object collection, Closure cl) {
        return GParsPoolUtilHelper.createPA(collection, GParsPoolUtil.retrievePool()).reduce(new ClosureReducer(cl), null);
    }

    @Deprecated
    public static <T> T foldParallel(Collection<T> collection, T seed, Closure cl) {
        return GParsPoolUtilHelper.foldParallel(collection, seed, cl);
    }

    @Deprecated
    public static Object foldParallel(Object collection, Object seed, Closure cl) {
        return GParsPoolUtilHelper.foldParallel(collection, seed, cl);
    }

    public static <T> T injectParallel(Collection<T> collection, Closure cl) {
        return GParsPoolUtilHelper.createPAFromCollection(collection, GParsPoolUtil.retrievePool()).reduce(new ClosureReducer(cl), (Object)null);
    }

    public static Object injectParallel(Object collection, Closure cl) {
        return GParsPoolUtilHelper.createPA(collection, GParsPoolUtil.retrievePool()).reduce(new ClosureReducer(cl), null);
    }

    public static <T> T injectParallel(Collection<T> collection, T seed, Closure cl) {
        return GParsPoolUtilHelper.foldParallel(collection, seed, cl);
    }

    public static Object injectParallel(Object collection, Object seed, Closure cl) {
        return GParsPoolUtilHelper.foldParallel(collection, seed, cl);
    }

    public static <T> PAWrapper<T> getParallel(Collection<T> collection) {
        return new PAWrapper(GParsPoolUtilHelper.createPAFromCollection(collection, GParsPoolUtil.retrievePool()));
    }

    public static PAWrapper getParallel(Object collection) {
        return new PAWrapper(GParsPoolUtilHelper.createPA(collection, GParsPoolUtil.retrievePool()));
    }

    public static <T> ParallelArray<T> getParallelArray(Collection<T> collection) {
        return GParsPoolUtilHelper.createPAFromCollection(collection, GParsPoolUtil.retrievePool());
    }

    public static ParallelArray getParallelArray(Object collection) {
        return GParsPoolUtilHelper.createPA(collection, GParsPoolUtil.retrievePool());
    }
}

