/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.Iterator;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.RuleFactory;

public class PropertiesRule
implements Rule<JDefinedClass, JDefinedClass> {
    private final RuleFactory ruleFactory;

    protected PropertiesRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JDefinedClass apply(String nodeName, JsonNode node, JsonNode parent, JDefinedClass jclass, Schema schema) {
        if (node == null) {
            node = JsonNodeFactory.instance.objectNode();
        }
        Iterator properties = node.fieldNames();
        while (properties.hasNext()) {
            String property = (String)properties.next();
            this.ruleFactory.getPropertyRule().apply(property, node.get(property), node, jclass, schema);
        }
        if (this.ruleFactory.getGenerationConfig().isGenerateBuilders() && !jclass._extends().name().equals("Object")) {
            this.addOverrideBuilders(jclass, jclass.owner()._getClass(jclass._extends().fullName()));
        }
        this.ruleFactory.getAnnotator().propertyOrder(jclass, node);
        return jclass;
    }

    private void addOverrideBuilders(JDefinedClass jclass, JDefinedClass parentJclass) {
        if (parentJclass == null) {
            return;
        }
        for (JMethod parentJMethod : parentJclass.methods()) {
            if (!parentJMethod.name().startsWith("with") || parentJMethod.params().size() != 1) continue;
            this.addOverrideBuilder(jclass, parentJMethod, (JVar)parentJMethod.params().get(0));
        }
    }

    private void addOverrideBuilder(JDefinedClass thisJDefinedClass, JMethod parentBuilder, JVar parentParam) {
        if (thisJDefinedClass.getMethod(parentBuilder.name(), new JType[]{parentParam.type()}) == null) {
            JMethod builder = thisJDefinedClass.method(parentBuilder.mods().getValue(), (JType)thisJDefinedClass, parentBuilder.name());
            builder.annotate(Override.class);
            JVar param = builder.param(parentParam.type(), parentParam.name());
            JBlock body = builder.body();
            body.invoke(JExpr._super(), parentBuilder).arg((JExpression)param);
            body._return(JExpr._this());
        }
    }
}

