/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.rm;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MRAppMaster;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.JobStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.impl.JobImpl;
import org.apache.hadoop.mapreduce.v2.app.rm.RMContainerAllocationException;
import org.apache.hadoop.mapreduce.v2.app.rm.RMHeartbeatHandler;
import org.apache.hadoop.mapreduce.v2.util.MRWebAppUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.ApplicationMasterNotRegisteredException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RMCommunicator
extends AbstractService
implements RMHeartbeatHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RMCommunicator.class);
    private int rmPollInterval;
    protected ApplicationId applicationId;
    private final AtomicBoolean stopped;
    protected Thread allocatorThread;
    protected EventHandler eventHandler;
    protected ApplicationMasterProtocol scheduler;
    private final ClientService clientService;
    private Resource maxContainerCapability;
    protected Map<ApplicationAccessType, String> applicationACLs;
    private volatile long lastHeartbeatTime;
    private ConcurrentLinkedQueue<Runnable> heartbeatCallbacks;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final AppContext context;
    private Job job;
    protected volatile boolean isSignalled = false;
    private volatile boolean shouldUnregister = true;
    private boolean isApplicationMasterRegistered = false;
    private EnumSet<YarnServiceProtos.SchedulerResourceTypes> schedulerResourceTypes;

    public RMCommunicator(ClientService clientService, AppContext context) {
        super("RMCommunicator");
        this.clientService = clientService;
        this.context = context;
        this.eventHandler = context.getEventHandler();
        this.applicationId = context.getApplicationID();
        this.stopped = new AtomicBoolean(false);
        this.heartbeatCallbacks = new ConcurrentLinkedQueue();
        this.schedulerResourceTypes = EnumSet.of(YarnServiceProtos.SchedulerResourceTypes.MEMORY);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.rmPollInterval = conf.getInt("yarn.app.mapreduce.am.scheduler.heartbeat.interval-ms", 1000);
    }

    protected void serviceStart() throws Exception {
        this.scheduler = this.createSchedulerProxy();
        JobID id = TypeConverter.fromYarn((ApplicationId)this.applicationId);
        JobId jobId = TypeConverter.toYarn((JobID)id);
        this.job = this.context.getJob(jobId);
        this.register();
        this.startAllocatorThread();
        super.serviceStart();
    }

    protected AppContext getContext() {
        return this.context;
    }

    protected Job getJob() {
        return this.job;
    }

    protected float getApplicationProgress() {
        return this.job.getProgress();
    }

    protected void register() {
        InetSocketAddress serviceAddr = null;
        if (this.clientService != null) {
            serviceAddr = this.clientService.getBindAddress();
        }
        try {
            RegisterApplicationMasterRequest request = (RegisterApplicationMasterRequest)this.recordFactory.newRecordInstance(RegisterApplicationMasterRequest.class);
            if (serviceAddr != null) {
                request.setHost(serviceAddr.getHostName());
                request.setRpcPort(serviceAddr.getPort());
                request.setTrackingUrl(MRWebAppUtil.getAMWebappScheme((Configuration)this.getConfig()) + serviceAddr.getHostName() + ":" + this.clientService.getHttpPort());
            }
            RegisterApplicationMasterResponse response = this.scheduler.registerApplicationMaster(request);
            this.isApplicationMasterRegistered = true;
            this.maxContainerCapability = response.getMaximumResourceCapability();
            this.context.getClusterInfo().setMaxContainerCapability(this.maxContainerCapability);
            if (UserGroupInformation.isSecurityEnabled()) {
                this.setClientToAMToken(response.getClientToAMTokenMasterKey());
            }
            this.applicationACLs = response.getApplicationACLs();
            LOG.info("maxContainerCapability: " + this.maxContainerCapability);
            String queue = response.getQueue();
            LOG.info("queue: " + queue);
            this.job.setQueueName(queue);
            this.schedulerResourceTypes.addAll(response.getSchedulerResourceTypes());
        }
        catch (Exception are) {
            LOG.error("Exception while registering", (Throwable)are);
            throw new YarnRuntimeException((Throwable)are);
        }
    }

    private void setClientToAMToken(ByteBuffer clientToAMTokenMasterKey) {
        byte[] key = clientToAMTokenMasterKey.array();
        this.context.getClientToAMTokenSecretManager().setMasterKey(key);
    }

    protected void unregister() {
        try {
            this.doUnregistration();
        }
        catch (Exception are) {
            LOG.error("Exception while unregistering ", (Throwable)are);
            MRAppMaster.RunningAppContext raContext = (MRAppMaster.RunningAppContext)this.context;
            raContext.resetIsLastAMRetry();
        }
    }

    @VisibleForTesting
    protected void doUnregistration() throws YarnException, IOException, InterruptedException {
        FinalApplicationStatus finishState = FinalApplicationStatus.UNDEFINED;
        JobImpl jobImpl = (JobImpl)this.job;
        if (jobImpl.getInternalState() == JobStateInternal.SUCCEEDED) {
            finishState = FinalApplicationStatus.SUCCEEDED;
        } else if (jobImpl.getInternalState() == JobStateInternal.KILLED || jobImpl.getInternalState() == JobStateInternal.RUNNING && this.isSignalled) {
            finishState = FinalApplicationStatus.KILLED;
        } else if (jobImpl.getInternalState() == JobStateInternal.FAILED || jobImpl.getInternalState() == JobStateInternal.ERROR) {
            finishState = FinalApplicationStatus.FAILED;
        }
        StringBuffer sb = new StringBuffer();
        for (String s : this.job.getDiagnostics()) {
            sb.append(s).append("\n");
        }
        LOG.info("Setting job diagnostics to " + sb.toString());
        String historyUrl = this.context.getHistoryUrl();
        LOG.info("History url is " + historyUrl);
        FinishApplicationMasterRequest request = FinishApplicationMasterRequest.newInstance((FinalApplicationStatus)finishState, (String)sb.toString(), (String)historyUrl);
        try {
            while (true) {
                FinishApplicationMasterResponse response;
                if ((response = this.scheduler.finishApplicationMaster(request)).getIsUnregistered()) {
                    MRAppMaster.RunningAppContext raContext = (MRAppMaster.RunningAppContext)this.context;
                    raContext.markSuccessfulUnregistration();
                    break;
                }
                LOG.info("Waiting for application to be successfully unregistered.");
                Thread.sleep(this.rmPollInterval);
            }
        }
        catch (ApplicationMasterNotRegisteredException e) {
            this.register();
            this.doUnregistration();
        }
    }

    protected Resource getMaxContainerCapability() {
        return this.maxContainerCapability;
    }

    protected void serviceStop() throws Exception {
        if (this.stopped.getAndSet(true)) {
            return;
        }
        if (this.allocatorThread != null) {
            this.allocatorThread.interrupt();
            try {
                this.allocatorThread.join();
            }
            catch (InterruptedException ie) {
                LOG.warn("InterruptedException while stopping", (Throwable)ie);
            }
        }
        if (this.isApplicationMasterRegistered && this.shouldUnregister) {
            this.unregister();
        }
        super.serviceStop();
    }

    protected void startAllocatorThread() {
        this.allocatorThread = new Thread(new AllocatorRunnable());
        this.allocatorThread.setName("RMCommunicator Allocator");
        this.allocatorThread.start();
    }

    protected ApplicationMasterProtocol createSchedulerProxy() {
        Configuration conf = this.getConfig();
        try {
            return (ApplicationMasterProtocol)ClientRMProxy.createRMProxy((Configuration)conf, ApplicationMasterProtocol.class);
        }
        catch (IOException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    protected abstract void heartbeat() throws Exception;

    private void executeHeartbeatCallbacks() {
        Runnable callback = null;
        while ((callback = this.heartbeatCallbacks.poll()) != null) {
            callback.run();
        }
    }

    @Override
    public long getLastHeartbeatTime() {
        return this.lastHeartbeatTime;
    }

    @Override
    public void runOnNextHeartbeat(Runnable callback) {
        this.heartbeatCallbacks.add(callback);
    }

    public void setShouldUnregister(boolean shouldUnregister) {
        this.shouldUnregister = shouldUnregister;
        LOG.info("RMCommunicator notified that shouldUnregistered is: " + shouldUnregister);
    }

    public void setSignalled(boolean isSignalled) {
        this.isSignalled = isSignalled;
        LOG.info("RMCommunicator notified that isSignalled is: " + isSignalled);
    }

    @VisibleForTesting
    protected boolean isApplicationMasterRegistered() {
        return this.isApplicationMasterRegistered;
    }

    public EnumSet<YarnServiceProtos.SchedulerResourceTypes> getSchedulerResourceTypes() {
        return this.schedulerResourceTypes;
    }

    @VisibleForTesting
    public class AllocatorRunnable
    implements Runnable {
        @Override
        public void run() {
            while (!RMCommunicator.this.stopped.get() && !Thread.currentThread().isInterrupted()) {
                try {
                    Thread.sleep(RMCommunicator.this.rmPollInterval);
                    try {
                        RMCommunicator.this.heartbeat();
                    }
                    catch (RMContainerAllocationException e) {
                        LOG.error("Error communicating with RM: " + e.getMessage(), (Throwable)e);
                        return;
                    }
                    catch (Exception e) {
                        LOG.error("ERROR IN CONTACTING RM. ", (Throwable)e);
                        continue;
                    }
                    RMCommunicator.this.lastHeartbeatTime = RMCommunicator.this.context.getClock().getTime();
                    RMCommunicator.this.executeHeartbeatCallbacks();
                }
                catch (InterruptedException e) {
                    if (!RMCommunicator.this.stopped.get()) {
                        LOG.warn("Allocated thread interrupted. Returning.");
                    }
                    return;
                }
            }
        }
    }
}

