/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MiscTests.class, SmallTests.class})
public class TestHFileArchiveUtil {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHFileArchiveUtil.class);
    private Path rootDir = new Path("./");
    @Rule
    public TestName name = new TestName();

    @Test
    public void testGetTableArchivePath() {
        Assert.assertNotNull((Object)HFileArchiveUtil.getTableArchivePath((Path)this.rootDir, (TableName)TableName.valueOf((String)this.name.getMethodName())));
    }

    @Test
    public void testGetArchivePath() throws Exception {
        Configuration conf = new Configuration();
        CommonFSUtils.setRootDir((Configuration)conf, (Path)new Path("root"));
        Assert.assertNotNull((Object)HFileArchiveUtil.getArchivePath((Configuration)conf));
    }

    @Test
    public void testRegionArchiveDir() {
        Path regionDir = new Path("region");
        Assert.assertNotNull((Object)HFileArchiveUtil.getRegionArchiveDir((Path)this.rootDir, (TableName)TableName.valueOf((String)this.name.getMethodName()), (Path)regionDir));
    }

    @Test
    public void testGetStoreArchivePath() throws IOException {
        byte[] family = Bytes.toBytes((String)"Family");
        Path tabledir = CommonFSUtils.getTableDir((Path)this.rootDir, (TableName)TableName.valueOf((String)this.name.getMethodName()));
        HRegionInfo region = new HRegionInfo(TableName.valueOf((String)this.name.getMethodName()));
        Configuration conf = new Configuration();
        CommonFSUtils.setRootDir((Configuration)conf, (Path)new Path("root"));
        Assert.assertNotNull((Object)HFileArchiveUtil.getStoreArchivePath((Configuration)conf, (RegionInfo)region, (Path)tabledir, (byte[])family));
    }
}

