/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.ipc.BufferChain;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServer;
import org.apache.hadoop.hbase.ipc.RpcResponse;
import org.apache.hbase.thirdparty.io.netty.buffer.Unpooled;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelOutboundHandlerAdapter;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelPromise;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class NettyRpcServerResponseEncoder
extends ChannelOutboundHandlerAdapter {
    private final MetricsHBaseServer metrics;

    NettyRpcServerResponseEncoder(MetricsHBaseServer metrics) {
        this.metrics = metrics;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof RpcResponse) {
            RpcResponse resp = (RpcResponse)msg;
            BufferChain buf = resp.getResponse();
            ctx.write((Object)Unpooled.wrappedBuffer((ByteBuffer[])buf.getBuffers()), promise).addListener(f -> {
                resp.done();
                if (f.isSuccess()) {
                    this.metrics.sentBytes(buf.size());
                }
            });
        } else {
            ctx.write(msg, promise);
        }
    }
}

