/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.hooks.PrivateHookContext;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHook;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHookContext;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveQueryLifeTimeHook
implements QueryLifeTimeHook {
    private static final Logger LOG = LoggerFactory.getLogger(HiveQueryLifeTimeHook.class);

    @Override
    public void beforeCompile(QueryLifeTimeHookContext ctx) {
    }

    @Override
    public void afterCompile(QueryLifeTimeHookContext ctx, boolean hasError) {
    }

    @Override
    public void beforeExecution(QueryLifeTimeHookContext ctx) {
    }

    @Override
    public void afterExecution(QueryLifeTimeHookContext ctx, boolean hasError) {
        if (hasError) {
            this.checkAndRollbackCTAS(ctx);
        }
    }

    private void checkAndRollbackCTAS(QueryLifeTimeHookContext ctx) {
        HiveConf conf = ctx.getHiveConf();
        QueryPlan queryPlan = ctx.getHookContext().getQueryPlan();
        boolean isCTAS = Optional.ofNullable(queryPlan.getQueryProperties()).map(queryProps -> queryProps.isCTAS()).orElse(false);
        PrivateHookContext pCtx = (PrivateHookContext)ctx.getHookContext();
        Path tblPath = pCtx.getContext().getLocation();
        if (isCTAS && tblPath != null) {
            try {
                FileSystem fs = tblPath.getFileSystem((Configuration)conf);
                if (!fs.exists(tblPath)) {
                    return;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Not able to check whether the CTAS table directory exists due to: ", e);
            }
            boolean isSoftDeleteEnabled = tblPath.getName().matches("(.*)\\.v\\d+");
            if ((HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.TXN_CTAS_X_LOCK) || isSoftDeleteEnabled) && CollectionUtils.isNotEmpty(queryPlan.getAcidSinks())) {
                FileSinkDesc fileSinkDesc = queryPlan.getAcidSinks().iterator().next();
                Table table = fileSinkDesc.getTable();
                long writeId = fileSinkDesc.getTableWriteId();
                if (table != null) {
                    LOG.info("Performing cleanup as part of rollback: {}", (Object)table.getFullTableName().toString());
                    try {
                        CompactionRequest request = new CompactionRequest(table.getDbName(), table.getTableName(), CompactionType.MAJOR);
                        request.setRunas(TxnUtils.findUserToRunAs((String)tblPath.toString(), (org.apache.hadoop.hive.metastore.api.Table)table.getTTable(), (Configuration)conf));
                        request.putToProperties("location", tblPath.toString());
                        request.putToProperties("ifPurge", Boolean.toString(true));
                        boolean success = Hive.get(conf).getMSC().submitForCleanup(request, writeId, pCtx.getQueryState().getTxnManager().getCurrentTxnId());
                        if (success) {
                            LOG.info("The cleanup request has been submitted");
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Not able to submit cleanup operation of directory written by CTAS due to: ", e);
                    }
                }
            }
        }
    }
}

