/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.materialized.alter.rebuild;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ddl.view.materialized.alter.rebuild.MaterializedViewASTBuilder;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseDriver;

public class NonNativeAcidMaterializedViewASTBuilder
extends MaterializedViewASTBuilder {
    private final Table mvTable;

    public NonNativeAcidMaterializedViewASTBuilder(Table mvTable) {
        this.mvTable = mvTable;
    }

    @Override
    public List<ASTNode> createDeleteSelectNodes(String tableName) {
        return this.wrapIntoSelExpr(this.mvTable.getStorageHandler().acidSelectColumns(this.mvTable, Context.Operation.DELETE).stream().map(fieldSchema -> this.createQualifiedColumnNode(tableName, fieldSchema.getName())).collect(Collectors.toList()));
    }

    @Override
    public void appendDeleteSelectNodes(ASTNode selectNode, String tableName) {
        HashSet<String> selectedColumns = new HashSet<String>(selectNode.getChildCount());
        for (int i = 0; i < selectNode.getChildCount(); ++i) {
            ASTNode selectExpr = (ASTNode)selectNode.getChild(i);
            selectedColumns.add(selectExpr.getChild(selectExpr.getChildCount() - 1).getText());
        }
        for (FieldSchema fieldSchema : this.mvTable.getStorageHandler().acidSelectColumns(this.mvTable, Context.Operation.DELETE)) {
            if (selectedColumns.contains(fieldSchema.getName())) continue;
            ParseDriver.adaptor.addChild((Object)selectNode, (Object)this.wrapIntoSelExpr(this.createQualifiedColumnNode(tableName, fieldSchema.getName())));
        }
    }

    @Override
    protected List<ASTNode> createAcidSortNodesInternal(String tableName) {
        return this.mvTable.getStorageHandler().acidSortColumns(this.mvTable, Context.Operation.DELETE).stream().map(fieldSchema -> this.createQualifiedColumnNode(tableName, fieldSchema.getName())).collect(Collectors.toList());
    }
}

