/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.persistence.MatchTracker;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashMultiSetStore;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastHashTableContainerBase;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastMultiKeyHashMultiSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashMultiSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMultiSetResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinNonMatchedIterator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hive.common.util.HashCodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorMapJoinFastMultiKeyHashMultiSetContainer
extends VectorMapJoinFastHashTableContainerBase
implements VectorMapJoinBytesHashMultiSet {
    private static final Logger LOG = LoggerFactory.getLogger(VectorMapJoinFastMultiKeyHashMultiSetContainer.class);
    private final VectorMapJoinFastMultiKeyHashMultiSet[] vectorMapJoinFastMultiKeyHashMultiSets;
    private final int numThreads;

    public VectorMapJoinFastMultiKeyHashMultiSetContainer(boolean isFullOuter, int initialCapacity, float loadFactor, int writeBuffersSize, long estimatedKeyCount, int numHTs) {
        this.vectorMapJoinFastMultiKeyHashMultiSets = new VectorMapJoinFastMultiKeyHashMultiSet[numHTs];
        LOG.info("Initializing {} HT Containers ", (Object)numHTs);
        for (int i = 0; i < numHTs; ++i) {
            this.vectorMapJoinFastMultiKeyHashMultiSets[i] = new VectorMapJoinFastMultiKeyHashMultiSet(isFullOuter, initialCapacity, loadFactor, writeBuffersSize, estimatedKeyCount);
        }
        this.numThreads = numHTs;
    }

    @Override
    public long getHashCode(BytesWritable currentKey) throws HiveException, IOException {
        byte[] keyBytes = currentKey.getBytes();
        int keyLength = currentKey.getLength();
        return HashCodeUtil.murmurHash((byte[])keyBytes, (int)0, (int)keyLength);
    }

    @Override
    public void putRow(long hashCode, BytesWritable currentKey, BytesWritable currentValue) throws HiveException, IOException {
        this.vectorMapJoinFastMultiKeyHashMultiSets[(int)((long)(this.numThreads - 1) & hashCode)].putRow(hashCode, currentKey, currentValue);
    }

    @Override
    public long getEstimatedMemorySize() {
        long estimatedMemorySize = 0L;
        for (int i = 0; i < this.numThreads; ++i) {
            estimatedMemorySize += this.vectorMapJoinFastMultiKeyHashMultiSets[i].getEstimatedMemorySize();
        }
        return estimatedMemorySize;
    }

    @Override
    public int size() {
        int size = 0;
        for (int i = 0; i < this.numThreads; ++i) {
            size += this.vectorMapJoinFastMultiKeyHashMultiSets[i].size();
        }
        return size;
    }

    @Override
    public MatchTracker createMatchTracker() {
        int count = 0;
        for (int i = 0; i < this.numThreads; ++i) {
            count += this.vectorMapJoinFastMultiKeyHashMultiSets[i].logicalHashBucketCount;
        }
        return MatchTracker.create(count);
    }

    @Override
    public VectorMapJoinNonMatchedIterator createNonMatchedIterator(MatchTracker matchTracker) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int spillPartitionId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JoinUtil.JoinResult contains(byte[] keyBytes, int keyStart, int keyLength, VectorMapJoinHashMultiSetResult hashMultiSetResult) throws IOException {
        long hashCode = HashCodeUtil.murmurHash((byte[])keyBytes, (int)keyStart, (int)keyLength);
        return this.vectorMapJoinFastMultiKeyHashMultiSets[(int)((long)(this.numThreads - 1) & hashCode)].contains(keyBytes, keyStart, keyLength, hashMultiSetResult);
    }

    @Override
    public VectorMapJoinHashMultiSetResult createHashMultiSetResult() {
        return new VectorMapJoinFastBytesHashMultiSetStore.HashMultiSetResult();
    }
}

