/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class VectorizerReason {
    private static final long serialVersionUID = 1L;
    private final VectorizerNodeIssue vectorizerNodeIssue;
    private final Operator<? extends OperatorDesc> operator;
    private final String expressionTitle;
    private final String issue;

    private VectorizerReason(VectorizerNodeIssue vectorizerNodeIssue, Operator<? extends OperatorDesc> operator, String expressionTitle, String issue) {
        this.vectorizerNodeIssue = vectorizerNodeIssue;
        this.operator = operator;
        this.expressionTitle = expressionTitle;
        this.issue = issue;
    }

    public static VectorizerReason createNodeIssue(String issue) {
        return new VectorizerReason(VectorizerNodeIssue.NODE_ISSUE, null, null, issue);
    }

    public static VectorizerReason createOperatorIssue(Operator<? extends OperatorDesc> operator, String issue) {
        return new VectorizerReason(VectorizerNodeIssue.OPERATOR_ISSUE, operator, null, issue);
    }

    public static VectorizerReason createExpressionIssue(Operator<? extends OperatorDesc> operator, String expressionTitle, String issue) {
        return new VectorizerReason(VectorizerNodeIssue.EXPRESSION_ISSUE, operator, expressionTitle, issue);
    }

    public VectorizerReason clone() {
        return new VectorizerReason(this.vectorizerNodeIssue, this.operator, this.expressionTitle, this.issue);
    }

    public VectorizerNodeIssue getVectorizerNodeIssue() {
        return this.vectorizerNodeIssue;
    }

    public Operator<? extends OperatorDesc> getOperator() {
        return this.operator;
    }

    public String getExpressionTitle() {
        return this.expressionTitle;
    }

    public String getIssue() {
        return this.issue;
    }

    public String toString() {
        return switch (this.vectorizerNodeIssue.ordinal()) {
            case 1 -> this.issue == null ? "unknown" : this.issue;
            case 2 -> String.valueOf(this.operator == null ? "Unknown" : this.operator.getType()) + " operator: " + (this.issue == null ? "unknown" : this.issue);
            case 3 -> this.expressionTitle + " expression for " + String.valueOf(this.operator == null ? "Unknown" : this.operator.getType()) + " operator: " + (this.issue == null ? "unknown" : this.issue);
            default -> "Unknown " + String.valueOf((Object)this.vectorizerNodeIssue);
        };
    }

    public static enum VectorizerNodeIssue {
        NONE,
        NODE_ISSUE,
        OPERATOR_ISSUE,
        EXPRESSION_ISSUE;

    }
}

