/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.IOUtils;

@Description(name="in_file", value="_FUNC_(str, filename) - Returns true if str appears in the file")
public class GenericUDFInFile
extends GenericUDF {
    private HashSet<String> set;
    private transient ObjectInspector strObjectInspector;
    private transient ObjectInspector fileObjectInspector;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("IN_FILE() accepts exactly 2 arguments.");
        }
        this.strObjectInspector = arguments[0];
        this.fileObjectInspector = arguments[1];
        if (!this.isTypeCompatible(this.strObjectInspector)) {
            throw new UDFArgumentTypeException(0, "The first argument of function IN_FILE must be a string, char or varchar but " + this.strObjectInspector.toString() + " was given.");
        }
        if (((PrimitiveObjectInspector)this.fileObjectInspector).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.STRING || !ObjectInspectorUtils.isConstantObjectInspector((ObjectInspector)this.fileObjectInspector)) {
            throw new UDFArgumentTypeException(1, "The second argument of IN_FILE() must be a constant string but " + this.fileObjectInspector.toString() + " was given.");
        }
        return PrimitiveObjectInspectorFactory.javaBooleanObjectInspector;
    }

    private boolean isTypeCompatible(ObjectInspector argument) {
        PrimitiveObjectInspector poi = (PrimitiveObjectInspector)argument;
        return poi.getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.STRING || poi.getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.CHAR || poi.getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.VARCHAR || poi.getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.VOID;
    }

    @Override
    public String[] getRequiredFiles() {
        return new String[]{ObjectInspectorUtils.getWritableConstantValue((ObjectInspector)this.fileObjectInspector).toString()};
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (arguments[0].get() == null || arguments[1].get() == null) {
            return null;
        }
        String str = ObjectInspectorUtils.copyToStandardJavaObject((Object)arguments[0].get(), (ObjectInspector)this.strObjectInspector).toString();
        if (this.set == null) {
            String filePath = (String)ObjectInspectorUtils.copyToStandardJavaObject((Object)arguments[1].get(), (ObjectInspector)this.fileObjectInspector);
            this.loadFromFile(filePath);
        }
        return this.set.contains(str);
    }

    private BufferedReader getReaderFor(String filePath) throws HiveException {
        try {
            Path fullFilePath = FileSystems.getDefault().getPath(filePath, new String[0]);
            Path fileName = fullFilePath.getFileName();
            if (Files.exists(fileName, new LinkOption[0])) {
                return Files.newBufferedReader(fileName, Charset.defaultCharset());
            }
            if (Files.exists(fullFilePath, new LinkOption[0])) {
                return Files.newBufferedReader(fullFilePath, Charset.defaultCharset());
            }
            throw new HiveException("Could not find \"" + String.valueOf(fileName) + "\" or \"" + String.valueOf(fullFilePath) + "\" in IN_FILE() UDF.");
        }
        catch (IOException exception) {
            throw new HiveException((Throwable)exception);
        }
    }

    private void loadFromFile(String filePath) throws HiveException {
        this.set = new HashSet();
        BufferedReader reader = this.getReaderFor(filePath);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                this.set.add(line);
            }
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        finally {
            IOUtils.closeStream((Closeable)reader);
        }
    }

    @Override
    public void copyToNewInstance(Object newInstance) throws UDFArgumentException {
        super.copyToNewInstance(newInstance);
        GenericUDFInFile that = (GenericUDFInFile)newInstance;
        if (that != this) {
            that.set = this.set == null ? null : (HashSet)this.set.clone();
            that.strObjectInspector = this.strObjectInspector;
            that.fileObjectInspector = this.fileObjectInspector;
        }
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 2);
        return this.getStandardDisplayString("in_file", children);
    }
}

