/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import sqlline.OutputFormat;
import sqlline.Rows;
import sqlline.SqlLine;

class VerticalOutputFormat
implements OutputFormat {
    private final SqlLine sqlLine;

    VerticalOutputFormat(SqlLine sqlLine) {
        this.sqlLine = sqlLine;
    }

    @Override
    public int print(Rows rows) {
        int count = 0;
        Rows.Row header = (Rows.Row)rows.next();
        while (rows.hasNext()) {
            this.printRow(rows, header, (Rows.Row)rows.next());
            ++count;
        }
        return count;
    }

    public void printRow(Rows rows, Rows.Row header, Rows.Row row) {
        int i;
        String[] head = header.values;
        String[] vals = row.values;
        int headWidth = 0;
        for (i = 0; i < head.length && i < vals.length; ++i) {
            headWidth = Math.max(headWidth, head[i].length());
        }
        headWidth += 2;
        for (i = 0; i < head.length && i < vals.length; ++i) {
            this.sqlLine.output(new AttributedStringBuilder().append((CharSequence)SqlLine.rpad(head[i], headWidth), AttributedStyle.BOLD).append((CharSequence)(vals[i] == null ? "" : vals[i])).toAttributedString());
        }
        this.sqlLine.output("");
    }
}

