/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.PxDS;
import com.ibm.as400.access.PxDSFactory;
import com.ibm.as400.access.PxParm;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class PxStringParm
extends PxDS
implements PxParm {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String ENCODING_ = "UTF8";
    private String value_;

    public PxStringParm() {
        super((short)26010);
    }

    public PxStringParm(String value) {
        super((short)26010);
        this.value_ = value;
    }

    protected PxStringParm(short type) {
        super(type);
    }

    protected PxStringParm(short type, String value) {
        super(type);
        this.value_ = value;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        this.value_ = null;
        return super.clone();
    }

    @Override
    public Object getObjectValue() {
        return this.value_;
    }

    public String getStringValue() {
        return this.value_;
    }

    @Override
    public void readFrom(InputStream input, PxDSFactory factory) throws IOException {
        super.readFrom(input, factory);
        DataInputStream dataInput = new DataInputStream(input);
        int length = dataInput.readInt();
        if (length > 0) {
            byte[] buffer = new byte[length];
            int leftToRead = length;
            int bytesRead = 0;
            while (leftToRead > 0) {
                int count = input.read(buffer, bytesRead, leftToRead);
                leftToRead -= count;
                bytesRead += count;
            }
            this.value_ = new String(buffer, 0, length, ENCODING_);
        } else {
            this.value_ = "";
        }
    }

    @Override
    public String toString() {
        if (this.value_ != null) {
            return super.toString() + " (\"" + this.value_ + "\")";
        }
        return super.toString();
    }

    @Override
    public void writeTo(OutputStream output) throws IOException {
        super.writeTo(output);
        DataOutputStream dataOutput = new DataOutputStream(output);
        if (this.value_ != null) {
            byte[] buffer = this.value_.getBytes(ENCODING_);
            dataOutput.writeInt(buffer.length);
            output.write(buffer);
        } else {
            dataOutput.writeInt(0);
        }
    }
}

