/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IEnumHasCodeAndDescription;
import org.w3c.dom.Node;

public class ResultFile
implements Cloneable {
    private static final Class<?> PKG = Const.class;
    public static final int FILE_TYPE_GENERAL = 0;
    public static final int FILE_TYPE_LOG = 1;
    public static final int FILE_TYPE_ERRORLINE = 2;
    public static final int FILE_TYPE_ERROR = 3;
    public static final int FILE_TYPE_WARNING = 4;
    private static final String CONST_PARENT_ORIGIN = "parentorigin";
    private static final String CONST_ORIGIN = "origin";
    private static final String CONST_COMMENT = "comment";
    private static final String CONST_TIMESTAMP = "timestamp";
    public static final String[] fileTypeCode = new String[]{"GENERAL", "LOG", "ERRORLINE", "ERROR", "WARNING"};
    public static final String[] fileTypeDesc = new String[]{BaseMessages.getString(PKG, "ResultFile.FileType.General", new String[0]), BaseMessages.getString(PKG, "ResultFile.FileType.Log", new String[0]), BaseMessages.getString(PKG, "ResultFile.FileType.ErrorLine", new String[0]), BaseMessages.getString(PKG, "ResultFile.FileType.Error", new String[0]), BaseMessages.getString(PKG, "ResultFile.FileType.Warning", new String[0])};
    private static final String XML_TAG = "result-file";
    @JsonIgnore
    private int type;
    @JsonIgnore
    private FileObject file;
    private String originParent;
    private String origin;
    private String comment;
    private Date timestamp;

    public ResultFile(int type, FileObject file, String originParent, String origin) {
        this.type = type;
        this.file = file;
        this.originParent = originParent;
        this.origin = origin;
        this.timestamp = new Date();
    }

    public String toString() {
        return this.file.toString() + " - " + this.getTypeDesc() + " - " + XmlHandler.date2string(this.timestamp) + (String)(this.origin == null ? "" : " - " + this.origin) + (String)(this.originParent == null ? "" : " - " + this.originParent);
    }

    protected ResultFile clone() throws CloneNotSupportedException {
        return (ResultFile)super.clone();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public FileObject getFile() {
        return this.file;
    }

    public void setFile(FileObject file) {
        this.file = file;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getOriginParent() {
        return this.originParent;
    }

    public void setOriginParent(String originParent) {
        this.originParent = originParent;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @JsonIgnore
    public String getTypeDesc() {
        return fileTypeDesc[this.type];
    }

    @JsonInclude
    public String getTypeCode() {
        return fileTypeCode[this.type];
    }

    public static final int getType(String typeString) {
        int idx = Const.indexOfString(typeString, fileTypeDesc);
        if (idx >= 0) {
            return idx;
        }
        idx = Const.indexOfString(typeString, fileTypeCode);
        if (idx >= 0) {
            return idx;
        }
        return 0;
    }

    public static final String getTypeCode(int fileType) {
        return fileTypeCode[fileType];
    }

    public static final String getTypeDesc(int fileType) {
        return fileTypeDesc[fileType];
    }

    public static final String[] getAllTypeDesc() {
        return fileTypeDesc;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    @JsonIgnore
    public RowMetaAndData getRow() {
        RowMetaAndData row = new RowMetaAndData();
        row.addValue(new ValueMetaString("type"), this.getTypeDesc());
        row.addValue(new ValueMetaString("filename"), this.file.getName().getBaseName());
        row.addValue(new ValueMetaString("path"), this.file.getName().getURI());
        row.addValue(new ValueMetaString(CONST_PARENT_ORIGIN), this.originParent);
        row.addValue(new ValueMetaString(CONST_ORIGIN), this.origin);
        row.addValue(new ValueMetaString(CONST_COMMENT), this.comment);
        row.addValue(new ValueMetaDate(CONST_TIMESTAMP), this.timestamp);
        return row;
    }

    @JsonIgnore
    public String getXml() {
        return XmlHandler.openTag(XML_TAG) + XmlHandler.addTagValue("type", this.getTypeCode()) + XmlHandler.addTagValue("file", this.file.getName().toString()) + XmlHandler.addTagValue(CONST_PARENT_ORIGIN, this.originParent) + XmlHandler.addTagValue(CONST_ORIGIN, this.origin) + XmlHandler.addTagValue(CONST_COMMENT, this.comment) + XmlHandler.addTagValue(CONST_TIMESTAMP, this.timestamp) + XmlHandler.closeTag(XML_TAG);
    }

    public ResultFile(Node node) throws HopFileException {
        try {
            this.type = ResultFile.getType(XmlHandler.getTagValue(node, "type"));
            this.file = HopVfs.getFileObject(XmlHandler.getTagValue(node, "file"));
            this.originParent = XmlHandler.getTagValue(node, CONST_PARENT_ORIGIN);
            this.origin = XmlHandler.getTagValue(node, CONST_ORIGIN);
            this.comment = XmlHandler.getTagValue(node, CONST_COMMENT);
            this.timestamp = XmlHandler.stringToDate(XmlHandler.getTagValue(node, CONST_TIMESTAMP));
        }
        catch (Exception e) {
            throw new HopFileException(e);
        }
    }

    public static enum FileType implements IEnumHasCodeAndDescription
    {
        GENERAL("GENERAL", BaseMessages.getString(PKG, "ResultFile.FileType.General", new String[0]), 0),
        LOG("LOG", BaseMessages.getString(PKG, "ResultFile.FileType.Log", new String[0]), 1),
        ERROR_LINE("ERRORLINE", BaseMessages.getString(PKG, "ResultFile.FileType.ErrorLine", new String[0]), 2),
        ERROR("ERROR", BaseMessages.getString(PKG, "ResultFile.FileType.Error", new String[0]), 3),
        WARNING("WARNING", BaseMessages.getString(PKG, "ResultFile.FileType.Warning", new String[0]), 4);

        private final String code;
        private final String description;
        private final int type;

        private FileType(String code, String description, int type) {
            this.code = code;
            this.description = description;
            this.type = type;
        }

        public static String[] getDescriptions() {
            String[] descriptions = new String[FileType.values().length];
            for (int i = 0; i < descriptions.length; ++i) {
                descriptions[i] = FileType.values()[i].getDescription();
            }
            return descriptions;
        }

        public static FileType lookupDescription(String description) {
            for (FileType value : FileType.values()) {
                if (!value.getDescription().equals(description)) continue;
                return value;
            }
            return GENERAL;
        }

        @Override
        public String getCode() {
            return this.code;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public int getType() {
            return this.type;
        }
    }
}

