/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class SharingAllowlistAddError {
    public static final SharingAllowlistAddError NO_ENTRIES_PROVIDED = new SharingAllowlistAddError().withTag(Tag.NO_ENTRIES_PROVIDED);
    public static final SharingAllowlistAddError TOO_MANY_ENTRIES_PROVIDED = new SharingAllowlistAddError().withTag(Tag.TOO_MANY_ENTRIES_PROVIDED);
    public static final SharingAllowlistAddError TEAM_LIMIT_REACHED = new SharingAllowlistAddError().withTag(Tag.TEAM_LIMIT_REACHED);
    public static final SharingAllowlistAddError UNKNOWN_ERROR = new SharingAllowlistAddError().withTag(Tag.UNKNOWN_ERROR);
    public static final SharingAllowlistAddError OTHER = new SharingAllowlistAddError().withTag(Tag.OTHER);
    private Tag _tag;
    private String malformedEntryValue;
    private String entriesAlreadyExistValue;

    private SharingAllowlistAddError() {
    }

    private SharingAllowlistAddError withTag(Tag _tag) {
        SharingAllowlistAddError result = new SharingAllowlistAddError();
        result._tag = _tag;
        return result;
    }

    private SharingAllowlistAddError withTagAndMalformedEntry(Tag _tag, String malformedEntryValue) {
        SharingAllowlistAddError result = new SharingAllowlistAddError();
        result._tag = _tag;
        result.malformedEntryValue = malformedEntryValue;
        return result;
    }

    private SharingAllowlistAddError withTagAndEntriesAlreadyExist(Tag _tag, String entriesAlreadyExistValue) {
        SharingAllowlistAddError result = new SharingAllowlistAddError();
        result._tag = _tag;
        result.entriesAlreadyExistValue = entriesAlreadyExistValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isMalformedEntry() {
        return this._tag == Tag.MALFORMED_ENTRY;
    }

    public static SharingAllowlistAddError malformedEntry(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new SharingAllowlistAddError().withTagAndMalformedEntry(Tag.MALFORMED_ENTRY, value);
    }

    public String getMalformedEntryValue() {
        if (this._tag != Tag.MALFORMED_ENTRY) {
            throw new IllegalStateException("Invalid tag: required Tag.MALFORMED_ENTRY, but was Tag." + this._tag.name());
        }
        return this.malformedEntryValue;
    }

    public boolean isNoEntriesProvided() {
        return this._tag == Tag.NO_ENTRIES_PROVIDED;
    }

    public boolean isTooManyEntriesProvided() {
        return this._tag == Tag.TOO_MANY_ENTRIES_PROVIDED;
    }

    public boolean isTeamLimitReached() {
        return this._tag == Tag.TEAM_LIMIT_REACHED;
    }

    public boolean isUnknownError() {
        return this._tag == Tag.UNKNOWN_ERROR;
    }

    public boolean isEntriesAlreadyExist() {
        return this._tag == Tag.ENTRIES_ALREADY_EXIST;
    }

    public static SharingAllowlistAddError entriesAlreadyExist(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new SharingAllowlistAddError().withTagAndEntriesAlreadyExist(Tag.ENTRIES_ALREADY_EXIST, value);
    }

    public String getEntriesAlreadyExistValue() {
        if (this._tag != Tag.ENTRIES_ALREADY_EXIST) {
            throw new IllegalStateException("Invalid tag: required Tag.ENTRIES_ALREADY_EXIST, but was Tag." + this._tag.name());
        }
        return this.entriesAlreadyExistValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.malformedEntryValue, this.entriesAlreadyExistValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof SharingAllowlistAddError) {
            SharingAllowlistAddError other = (SharingAllowlistAddError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case MALFORMED_ENTRY: {
                    return this.malformedEntryValue == other.malformedEntryValue || this.malformedEntryValue.equals(other.malformedEntryValue);
                }
                case NO_ENTRIES_PROVIDED: {
                    return true;
                }
                case TOO_MANY_ENTRIES_PROVIDED: {
                    return true;
                }
                case TEAM_LIMIT_REACHED: {
                    return true;
                }
                case UNKNOWN_ERROR: {
                    return true;
                }
                case ENTRIES_ALREADY_EXIST: {
                    return this.entriesAlreadyExistValue == other.entriesAlreadyExistValue || this.entriesAlreadyExistValue.equals(other.entriesAlreadyExistValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<SharingAllowlistAddError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SharingAllowlistAddError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case MALFORMED_ENTRY: {
                    g.writeStartObject();
                    this.writeTag("malformed_entry", g);
                    g.writeFieldName("malformed_entry");
                    StoneSerializers.string().serialize(value.malformedEntryValue, g);
                    g.writeEndObject();
                    break;
                }
                case NO_ENTRIES_PROVIDED: {
                    g.writeString("no_entries_provided");
                    break;
                }
                case TOO_MANY_ENTRIES_PROVIDED: {
                    g.writeString("too_many_entries_provided");
                    break;
                }
                case TEAM_LIMIT_REACHED: {
                    g.writeString("team_limit_reached");
                    break;
                }
                case UNKNOWN_ERROR: {
                    g.writeString("unknown_error");
                    break;
                }
                case ENTRIES_ALREADY_EXIST: {
                    g.writeStartObject();
                    this.writeTag("entries_already_exist", g);
                    g.writeFieldName("entries_already_exist");
                    StoneSerializers.string().serialize(value.entriesAlreadyExistValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public SharingAllowlistAddError deserialize(JsonParser p) throws IOException, JsonParseException {
            SharingAllowlistAddError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("malformed_entry".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("malformed_entry", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = SharingAllowlistAddError.malformedEntry(fieldValue);
            } else if ("no_entries_provided".equals(tag)) {
                value = NO_ENTRIES_PROVIDED;
            } else if ("too_many_entries_provided".equals(tag)) {
                value = TOO_MANY_ENTRIES_PROVIDED;
            } else if ("team_limit_reached".equals(tag)) {
                value = TEAM_LIMIT_REACHED;
            } else if ("unknown_error".equals(tag)) {
                value = UNKNOWN_ERROR;
            } else if ("entries_already_exist".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("entries_already_exist", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = SharingAllowlistAddError.entriesAlreadyExist(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        MALFORMED_ENTRY,
        NO_ENTRIES_PROVIDED,
        TOO_MANY_ENTRIES_PROVIDED,
        TEAM_LIMIT_REACHED,
        UNKNOWN_ERROR,
        ENTRIES_ALREADY_EXIST,
        OTHER;

    }
}

