/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequestExecutorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class TaskExecutorChannelStateExecutorFactoryManager {
    private static final Logger LOG = LoggerFactory.getLogger(TaskExecutorChannelStateExecutorFactoryManager.class);
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final Map<JobID, ChannelStateWriteRequestExecutorFactory> executorFactoryByJobId = new HashMap<JobID, ChannelStateWriteRequestExecutorFactory>();
    @GuardedBy(value="lock")
    private boolean closed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelStateWriteRequestExecutorFactory getOrCreateExecutorFactory(@Nonnull JobID jobID) {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException("TaskExecutorChannelStateExecutorFactoryManager is already closed and cannot get a new executor factory.");
            }
            ChannelStateWriteRequestExecutorFactory factory = this.executorFactoryByJobId.get(jobID);
            if (factory == null) {
                LOG.info("Creating the channel state executor factory for job id {}", (Object)jobID);
                factory = new ChannelStateWriteRequestExecutorFactory(jobID);
                this.executorFactoryByJobId.put(jobID, factory);
            }
            return factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseResourcesForJob(@Nonnull JobID jobID) {
        LOG.debug("Releasing the factory under job id {}", (Object)jobID);
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.executorFactoryByJobId.remove(jobID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.executorFactoryByJobId.clear();
            LOG.info("Shutting down TaskExecutorChannelStateExecutorFactoryManager.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @VisibleForTesting
    public ChannelStateWriteRequestExecutorFactory getFactoryByJobId(JobID jobId) {
        Object object = this.lock;
        synchronized (object) {
            return this.executorFactoryByJobId.get(jobId);
        }
    }
}

