/*
 * Decompiled with CFR 0.152.
 */
package io.minio.messages;

import io.minio.Utils;
import io.minio.messages.PrefixConverter;
import java.util.Map;
import javax.annotation.Nullable;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.convert.Convert;

@Root(name="And")
public class AndOperator {
    @Element(name="Prefix", required=false)
    @Convert(value=PrefixConverter.class)
    private String prefix;
    @Element(name="ObjectSizeLessThan", required=false)
    private Long objectSizeLessThan;
    @Element(name="ObjectSizeGreaterThan", required=false)
    private Long objectSizeGreaterThan;
    @ElementMap(attribute=false, entry="Tag", inline=true, key="Key", value="Value", required=false)
    private Map<String, String> tags;

    public AndOperator(@Nullable @Element(name="Prefix", required=false) String prefix, @Nullable @ElementMap(attribute=false, entry="Tag", inline=true, key="Key", value="Value", required=false) Map<String, String> tags) {
        if (prefix == null && tags == null) {
            throw new IllegalArgumentException("At least Prefix or Tags must be set");
        }
        if (tags != null) {
            for (String key : tags.keySet()) {
                if (!key.isEmpty()) continue;
                throw new IllegalArgumentException("Tags must not contain empty key");
            }
        }
        this.prefix = prefix;
        this.tags = Utils.unmodifiableMap(tags);
    }

    public AndOperator(@Nullable @Element(name="Prefix", required=false) String prefix, @Nullable @ElementMap(attribute=false, entry="Tag", inline=true, key="Key", value="Value", required=false) Map<String, String> tags, @Nullable @Element(name="ObjectSizeLessThan", required=false) Long objectSizeLessThan, @Nullable @Element(name="ObjectSizeGreaterThan", required=false) Long objectSizeGreaterThan) {
        this(prefix, tags);
        this.objectSizeLessThan = objectSizeLessThan;
        this.objectSizeGreaterThan = objectSizeGreaterThan;
    }

    public String prefix() {
        return this.prefix;
    }

    public Long objectSizeLessThan() {
        return this.objectSizeLessThan;
    }

    public Long objectSizeGreaterThan() {
        return this.objectSizeGreaterThan;
    }

    public Map<String, String> tags() {
        return this.tags;
    }
}

