/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.cassandrainput;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.databases.cassandra.datastax.DriverConnection;
import org.apache.hop.databases.cassandra.metadata.CassandraConnection;
import org.apache.hop.databases.cassandra.spi.ITableMetaData;
import org.apache.hop.databases.cassandra.spi.Keyspace;
import org.apache.hop.databases.cassandra.util.CqlUtils;
import org.apache.hop.databases.cassandra.util.Selector;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.cassandrainput.CassandraInput;
import org.apache.hop.pipeline.transforms.cassandrainput.CassandraInputData;

@Transform(id="CassandraInput", image="cassandrain.svg", name="Cassandra input", description="Reads data from a Cassandra table", documentationUrl="/pipeline/transforms/cassandra-input.html", keywords={"i18n::CassandraInputMeta.keyword"}, categoryDescription="Cassandra")
public class CassandraInputMeta
extends BaseTransformMeta<CassandraInput, CassandraInputData> {
    protected static final Class<?> PKG = CassandraInputMeta.class;
    @HopMetadataProperty(key="connection", injectionKey="CONNECTION", injectionKeyDescription="CassandraInput.Injection.CONNECTION")
    protected String connectionName;
    @HopMetadataProperty(key="cql_select_query", injectionKey="CQL_QUERY", injectionKeyDescription="CassandraInput.Injection.CQL_QUERY")
    protected String cqlSelectQuery = "SELECT <fields> FROM <table> WHERE <condition>;";
    @HopMetadataProperty(key="execute_for_each_row", injectionKey="EXECUTE_FOR_EACH_ROW", injectionKeyDescription="CassandraInput.Injection.EXECUTE_FOR_EACH_ROW")
    protected boolean executeForEachIncomingRow;
    @HopMetadataProperty(key="max_length", injectionKey="TRANSPORT_MAX_LENGTH", injectionKeyDescription="CassandraInput.Injection.TRANSPORT_MAX_LENGTH")
    protected String maxLength = "";
    protected boolean isSelectStarQuery = false;
    protected int rowLimit = -1;
    protected int colLimit = -1;
    protected int rowBatchSize = 100;
    protected int colBatchSize = 100;
    protected List<String> specificCols;
    private boolean useDriver = true;

    public void setDefault() {
        this.cqlSelectQuery = "SELECT <fields> FROM <table> WHERE <condition>;";
        this.maxLength = "";
    }

    public void getFields(IRowMeta rowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        this.specificCols = null;
        this.rowLimit = -1;
        this.colLimit = -1;
        rowMeta.clear();
        if (Utils.isEmpty((CharSequence)this.connectionName)) {
            throw new HopTransformException("Please specify a Cassandra connection name to use");
        }
        if (!Utils.isEmpty((CharSequence)this.cqlSelectQuery)) {
            CassandraConnection cassandraConnection;
            String subQ = variables.resolve(this.cqlSelectQuery);
            if (!subQ.toLowerCase().startsWith("select")) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"CassandraInput.Error.NoSelectInQuery", (String[])new String[0]));
            }
            if (subQ.indexOf(59) < 0) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"CassandraInput.Error.QueryTermination", (String[])new String[0]));
            }
            if (subQ.toLowerCase().contains("limit")) {
                String limitS = subQ.toLowerCase().substring(subQ.toLowerCase().indexOf("limit") + 5, subQ.length()).trim();
                limitS = limitS.replace(";", "");
                try {
                    this.rowLimit = Integer.parseInt(limitS);
                }
                catch (NumberFormatException ex) {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"CassandraInput.Error.UnableToParseLimitClause", (String[])new String[]{this.cqlSelectQuery}));
                }
            }
            if (subQ.toLowerCase().lastIndexOf("where") > 0) {
                subQ = subQ.substring(0, subQ.toLowerCase().lastIndexOf("where"));
            }
            int fromIndex = subQ.toLowerCase().indexOf("from");
            String tempS = subQ.toLowerCase();
            int offset = fromIndex;
            while (fromIndex > 0 && tempS.charAt(fromIndex - 1) != ' ' && fromIndex + 4 < tempS.length() && tempS.charAt(fromIndex + 4) != ' ') {
                tempS = tempS.substring(fromIndex + 4);
                fromIndex = tempS.indexOf("from");
                offset += 4 + fromIndex;
            }
            fromIndex = offset;
            if (fromIndex < 0) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"CassandraInput.Error.MustSpecifyATable", (String[])new String[0]));
            }
            String tableName = subQ.substring(fromIndex + 4).trim();
            tableName = tableName.contains(" ") ? tableName.substring(0, tableName.indexOf(32)) : tableName.replace(";", "");
            if (tableName.isEmpty()) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"CassandraInput.Error.MustSpecifyATable", (String[])new String[0]));
            }
            tableName = tableName.replaceFirst("^\\s+", "").replaceFirst("\\s+$", "");
            if (subQ.toLowerCase().contains("first ")) {
                String firstS = subQ.substring(subQ.toLowerCase().indexOf("first") + 5).trim();
                subQ = firstS.substring(firstS.indexOf(32) + 1);
                firstS = firstS.substring(0, firstS.indexOf(32));
                try {
                    this.colLimit = Integer.parseInt(firstS);
                }
                catch (NumberFormatException ex) {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"CassandraInput.Error.UnableToParseFirstClause", (String[])new String[]{this.cqlSelectQuery}));
                }
            } else {
                subQ = subQ.substring(subQ.toLowerCase().indexOf("select") + 6);
            }
            fromIndex = subQ.toLowerCase().indexOf("from");
            Selector[] selectors = null;
            if (subQ.contains("*") && !subQ.toLowerCase().contains("count(*)")) {
                this.isSelectStarQuery = true;
            } else {
                this.isSelectStarQuery = false;
                String colsS = subQ.substring(0, fromIndex);
                selectors = CqlUtils.getColumnsInSelect(colsS, true);
            }
            try {
                cassandraConnection = (CassandraConnection)metadataProvider.getSerializer(CassandraConnection.class).load(variables.resolve(this.connectionName));
            }
            catch (HopException e) {
                throw new HopTransformException("Unable to load cassandra connection " + this.connectionName, (Throwable)e);
            }
            try (DriverConnection conn = cassandraConnection.createConnection(variables, false);){
                Keyspace kSpace;
                try {
                    kSpace = cassandraConnection.lookupKeyspace(conn, variables);
                }
                catch (Exception e) {
                    throw new HopTransformException("Unable to connect to Cassandra with '" + this.connectionName + "' or look up the keyspace", (Throwable)e);
                }
                ITableMetaData colMeta = kSpace.getTableMetaData(tableName);
                if (selectors == null) {
                    List<IValueMeta> vms = colMeta.getValueMetasForSchema();
                    for (IValueMeta vm : vms) {
                        rowMeta.addValueMeta(vm);
                    }
                } else {
                    this.specificCols = new ArrayList<String>();
                    for (Selector col : selectors) {
                        if (!col.isFunction() && !colMeta.columnExistsInSchema(col.getColumnName())) {
                            this.logBasic(BaseMessages.getString(PKG, (String)"CassandraInput.Info.DefaultColumnValidator", (Object[])new Object[]{col}));
                        }
                        IValueMeta vm = colMeta.getValueMeta(col);
                        rowMeta.addValueMeta(vm);
                    }
                }
            }
            catch (Exception e) {
                throw new HopTransformException("Error determining output row metadata of Cassandra query", (Throwable)e);
            }
        }
    }

    public boolean isUseDriver() {
        return this.useDriver;
    }

    public String getCqlSelectQuery() {
        return this.cqlSelectQuery;
    }

    public void setCqlSelectQuery(String cqlSelectQuery) {
        this.cqlSelectQuery = cqlSelectQuery;
    }

    public boolean isExecuteForEachIncomingRow() {
        return this.executeForEachIncomingRow;
    }

    public void setExecuteForEachIncomingRow(boolean executeForEachIncomingRow) {
        this.executeForEachIncomingRow = executeForEachIncomingRow;
    }

    public String getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(String maxLength) {
        this.maxLength = maxLength;
    }

    public boolean isSelectStarQuery() {
        return this.isSelectStarQuery;
    }

    public void setSelectStarQuery(boolean selectStarQuery) {
        this.isSelectStarQuery = selectStarQuery;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public int getColLimit() {
        return this.colLimit;
    }

    public void setColLimit(int colLimit) {
        this.colLimit = colLimit;
    }

    public int getRowBatchSize() {
        return this.rowBatchSize;
    }

    public void setRowBatchSize(int rowBatchSize) {
        this.rowBatchSize = rowBatchSize;
    }

    public int getColBatchSize() {
        return this.colBatchSize;
    }

    public void setColBatchSize(int colBatchSize) {
        this.colBatchSize = colBatchSize;
    }

    public List<String> getSpecificCols() {
        return this.specificCols;
    }

    public void setSpecificCols(List<String> specificCols) {
        this.specificCols = specificCols;
    }

    public void setUseDriver(boolean useDriver) {
        this.useDriver = useDriver;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }
}

