/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.CredentialUnavailableException;
import com.sun.jna.Platform;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PowershellManager {
    private static final ClientLogger LOGGER = new ClientLogger(PowershellManager.class);
    public static final Pattern PS_RESPONSE_PATTERN = Pattern.compile("\\s+$");
    private Process process;
    private PrintWriter commandWriter;
    private boolean closed;
    private int waitPause = 1000;
    private long maxWait = 10000L;
    private final String powershellPath;
    private ExecutorService executorService;

    public PowershellManager(String powershellPath) {
        this.powershellPath = powershellPath;
    }

    public PowershellManager(String powershellPath, ExecutorService executorService) {
        this.powershellPath = powershellPath;
        this.executorService = executorService;
    }

    public Mono<PowershellManager> initSession() {
        ProcessBuilder pb = Platform.isWindows() ? new ProcessBuilder("cmd.exe", "/c", "chcp", "65001", ">", "NUL", "&", this.powershellPath, "-ExecutionPolicy", "Bypass", "-NoExit", "-NoProfile", "-Command", "-") : new ProcessBuilder(this.powershellPath, "-nologo", "-noexit", "-Command", "-");
        pb.redirectErrorStream(true);
        Supplier<PowershellManager> supplier = () -> {
            try {
                this.process = pb.start();
                this.commandWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new BufferedOutputStream(this.process.getOutputStream()), StandardCharsets.UTF_8), true);
                if (this.process.waitFor(4L, TimeUnit.SECONDS) && !this.process.isAlive()) {
                    throw new CredentialUnavailableException("Unable to execute PowerShell. Please make sure that it is installed in your system.");
                }
                this.closed = false;
            }
            catch (IOException | InterruptedException e) {
                throw new CredentialUnavailableException("Unable to execute PowerShell. Please make sure that it is installed in your system", e);
            }
            return this;
        };
        return this.executorService != null ? Mono.fromFuture(CompletableFuture.supplyAsync(supplier, this.executorService)) : Mono.fromFuture(CompletableFuture.supplyAsync(supplier));
    }

    public Mono<String> runCommand(String command) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream(), StandardCharsets.UTF_8));
        StringBuilder powerShellOutput = new StringBuilder();
        this.commandWriter.println(command);
        return this.canRead(reader).flatMap(b -> {
            if (b.booleanValue()) {
                return this.readData(reader, powerShellOutput).flatMap(ignored -> Mono.just((Object)PS_RESPONSE_PATTERN.matcher(powerShellOutput.toString()).replaceAll("")));
            }
            return Mono.error((Throwable)((Object)new CredentialUnavailableException("Error reading data from reader")));
        });
    }

    private Mono<Boolean> readData(BufferedReader reader, StringBuilder powerShellOutput) {
        return Mono.defer(() -> {
            try {
                String line = reader.readLine();
                if (line != null) {
                    powerShellOutput.append(line).append("\r\n");
                    return this.canRead(reader).flatMap(b -> {
                        if (!this.closed && b.booleanValue()) {
                            return Mono.empty();
                        }
                        return Mono.just((Object)true);
                    });
                }
                return Mono.just((Object)true);
            }
            catch (IOException e) {
                return Mono.error((Throwable)((Object)new CredentialUnavailableException("Powershell reader not ready for reading", e)));
            }
        }).repeatWhenEmpty(longFlux -> longFlux.concatMap(ignored -> Flux.just((Object)true)));
    }

    private Mono<Boolean> canRead(BufferedReader reader) {
        Supplier<Boolean> supplier = () -> {
            int pause = 62;
            int maxPause = Platform.isMac() ? this.waitPause : 500;
            try {
                while (!reader.ready()) {
                    if (pause > maxPause) {
                        return false;
                    }
                    Thread.sleep(pause *= 2);
                }
            }
            catch (IOException | InterruptedException e) {
                throw new CredentialUnavailableException("Powershell reader not ready for reading", e);
            }
            return true;
        };
        return this.executorService != null ? Mono.fromFuture(CompletableFuture.supplyAsync(supplier, this.executorService)) : Mono.fromFuture(CompletableFuture.supplyAsync(supplier));
    }

    public Mono<Boolean> close() {
        if (!this.closed && this.process != null) {
            Supplier<Boolean> supplier = () -> {
                this.commandWriter.println("exit");
                try {
                    this.process.waitFor(this.maxWait, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    LOGGER.logExceptionAsError(new RuntimeException("PowerShell process encountered unexpected error when closing.", e));
                }
                finally {
                    this.commandWriter.close();
                    try {
                        if (this.process.isAlive()) {
                            this.process.getInputStream().close();
                        }
                    }
                    catch (IOException ex) {
                        LOGGER.logExceptionAsError(new RuntimeException("PowerShell stream encountered unexpected error when closing.", ex));
                    }
                    this.closed = true;
                }
                return this.closed;
            };
            return this.executorService != null ? Mono.fromFuture(CompletableFuture.supplyAsync(supplier, this.executorService)) : Mono.fromFuture(CompletableFuture.supplyAsync(supplier));
        }
        return Mono.just((Object)true);
    }
}

