/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.streamlookup;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Collections;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.hash.ByteArrayHashIndex;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transforms.streamlookup.KeyValue;
import org.apache.hop.pipeline.transforms.streamlookup.StreamLookupData;
import org.apache.hop.pipeline.transforms.streamlookup.StreamLookupMeta;

public class StreamLookup
extends BaseTransform<StreamLookupMeta, StreamLookupData> {
    private static final Class<?> PKG = StreamLookupMeta.class;

    public StreamLookup(TransformMeta transformMeta, StreamLookupMeta meta, StreamLookupData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private void handleNullIf() {
        ((StreamLookupData)this.data).nullIf = new Object[((StreamLookupMeta)this.meta).getValue().length];
        block16: for (int i = 0; i < ((StreamLookupMeta)this.meta).getValue().length; ++i) {
            if (((StreamLookupMeta)this.meta).getValueDefaultType()[i] < 0) {
                ((StreamLookupMeta)this.meta).getValueDefaultType()[i] = 2;
            }
            ((StreamLookupData)this.data).nullIf[i] = null;
            switch (((StreamLookupMeta)this.meta).getValueDefaultType()[i]) {
                case 2: {
                    if (Utils.isEmpty((CharSequence)((StreamLookupData)this.data).valueDefault[i])) {
                        ((StreamLookupData)this.data).nullIf[i] = null;
                        continue block16;
                    }
                    ((StreamLookupData)this.data).nullIf[i] = ((StreamLookupData)this.data).valueDefault[i];
                    continue block16;
                }
                case 3: {
                    try {
                        ((StreamLookupData)this.data).nullIf[i] = DateFormat.getInstance().parse(((StreamLookupData)this.data).valueDefault[i]);
                    }
                    catch (Exception exception) {}
                    continue block16;
                }
                case 1: {
                    try {
                        ((StreamLookupData)this.data).nullIf[i] = Double.parseDouble(((StreamLookupData)this.data).valueDefault[i]);
                    }
                    catch (Exception exception) {}
                    continue block16;
                }
                case 5: {
                    try {
                        ((StreamLookupData)this.data).nullIf[i] = Long.parseLong(((StreamLookupData)this.data).valueDefault[i]);
                    }
                    catch (Exception exception) {}
                    continue block16;
                }
                case 4: {
                    if ("TRUE".equalsIgnoreCase(((StreamLookupData)this.data).valueDefault[i]) || "Y".equalsIgnoreCase(((StreamLookupData)this.data).valueDefault[i])) {
                        ((StreamLookupData)this.data).nullIf[i] = Boolean.TRUE;
                        continue block16;
                    }
                    ((StreamLookupData)this.data).nullIf[i] = Boolean.FALSE;
                    continue block16;
                }
                case 6: {
                    try {
                        ((StreamLookupData)this.data).nullIf[i] = new BigDecimal(((StreamLookupData)this.data).valueDefault[i]);
                    }
                    catch (Exception exception) {}
                    continue block16;
                }
                default: {
                    if (((StreamLookupData)this.data).valueDefault[i] != null && !((StreamLookupData)this.data).valueDefault[i].trim().isEmpty()) {
                        throw new RuntimeException(BaseMessages.getString(PKG, (String)"StreamLookup.Exception.ConversionNotImplemented", (String[])new String[0]) + " " + ValueMetaFactory.getValueMetaName((int)((StreamLookupMeta)this.meta).getValueDefaultType()[i]));
                    }
                    ((StreamLookupData)this.data).nullIf[i] = null;
                }
            }
        }
    }

    private boolean readLookupValues() throws HopException {
        ((StreamLookupData)this.data).infoStream = (IStream)((StreamLookupMeta)this.meta).getTransformIOMeta().getInfoStreams().get(0);
        if (((StreamLookupData)this.data).infoStream.getTransformMeta() == null) {
            this.logError(BaseMessages.getString(PKG, (String)"StreamLookup.Log.NoLookupTransformSpecified", (String[])new String[0]));
            return false;
        }
        if (this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"StreamLookup.Log.ReadingFromStream", (String[])new String[0]) + ((StreamLookupData)this.data).infoStream.getTransformName() + "]");
        }
        int[] keyNrs = new int[((StreamLookupMeta)this.meta).getKeylookup().length];
        int[] valueNrs = new int[((StreamLookupMeta)this.meta).getValue().length];
        boolean firstRun = true;
        IRowSet rowSet = this.findInputRowSet(((StreamLookupData)this.data).infoStream.getTransformName());
        Object[] rowData = this.getRowFrom(rowSet);
        while (rowData != null) {
            int i;
            if (this.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"StreamLookup.Log.ReadLookupRow", (String[])new String[0]) + rowSet.getRowMeta().getString(rowData));
            }
            if (firstRun) {
                firstRun = false;
                ((StreamLookupData)this.data).hasLookupRows = true;
                ((StreamLookupData)this.data).infoMeta = rowSet.getRowMeta().clone();
                RowMeta cacheKeyMeta = new RowMeta();
                RowMeta cacheValueMeta = new RowMeta();
                for (i = 0; i < ((StreamLookupMeta)this.meta).getKeylookup().length; ++i) {
                    keyNrs[i] = rowSet.getRowMeta().indexOfValue(((StreamLookupMeta)this.meta).getKeylookup()[i]);
                    if (keyNrs[i] < 0) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"StreamLookup.Exception.UnableToFindField", (String[])new String[]{((StreamLookupMeta)this.meta).getKeylookup()[i]}));
                    }
                    cacheKeyMeta.addValueMeta(rowSet.getRowMeta().getValueMeta(keyNrs[i]));
                }
                if (((StreamLookupData)this.data).keyTypes == null) {
                    ((StreamLookupData)this.data).keyTypes = cacheKeyMeta.clone();
                }
                for (i = 0; i < keyNrs.length; ++i) {
                    cacheKeyMeta.getValueMeta(i).setStorageType(0);
                }
                for (int v = 0; v < ((StreamLookupMeta)this.meta).getValue().length; ++v) {
                    valueNrs[v] = rowSet.getRowMeta().indexOfValue(((StreamLookupMeta)this.meta).getValue()[v]);
                    if (valueNrs[v] < 0) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"StreamLookup.Exception.UnableToFindField", (String[])new String[]{((StreamLookupMeta)this.meta).getValue()[v]}));
                    }
                    cacheValueMeta.addValueMeta(rowSet.getRowMeta().getValueMeta(valueNrs[v]));
                }
                ((StreamLookupData)this.data).cacheKeyMeta = cacheKeyMeta;
                ((StreamLookupData)this.data).cacheValueMeta = cacheValueMeta;
            }
            Object[] keyData = new Object[keyNrs.length];
            for (int i2 = 0; i2 < keyNrs.length; ++i2) {
                IValueMeta keyMeta = ((StreamLookupData)this.data).keyTypes.getValueMeta(i2);
                keyData[i2] = keyMeta.convertToNormalStorageType(rowData[keyNrs[i2]]);
            }
            Object[] valueData = new Object[valueNrs.length];
            for (i = 0; i < valueNrs.length; ++i) {
                valueData[i] = rowData[valueNrs[i]];
            }
            this.addToCache(((StreamLookupData)this.data).cacheKeyMeta, keyData, ((StreamLookupData)this.data).cacheValueMeta, valueData);
            rowData = this.getRowFrom(rowSet);
        }
        return true;
    }

    private Object[] lookupValues(IRowMeta rowMeta, Object[] row) throws HopException {
        int i;
        if (this.isStopped()) {
            return null;
        }
        if (((StreamLookupData)this.data).lookupColumnIndex == null) {
            String[] names = ((StreamLookupData)this.data).lookupMeta.getFieldNames();
            ((StreamLookupData)this.data).lookupColumnIndex = new int[names.length];
            for (i = 0; i < names.length; ++i) {
                ((StreamLookupData)this.data).lookupColumnIndex[i] = rowMeta.indexOfValue(names[i]);
                if (((StreamLookupData)this.data).lookupColumnIndex[i] >= 0) continue;
                throw new HopTransformException("The lookup column '" + names[i] + "' could not be found");
            }
        }
        Object[] lu = new Object[((StreamLookupData)this.data).keynrs.length];
        for (i = 0; i < ((StreamLookupData)this.data).keynrs.length; ++i) {
            lu[i] = ((StreamLookupData)this.data).convertKeysToNative[i] ? ((StreamLookupData)this.data).lookupMeta.getValueMeta(i).convertBinaryStringToNativeType((byte[])row[((StreamLookupData)this.data).keynrs[i]]) : row[((StreamLookupData)this.data).keynrs[i]];
        }
        if (((StreamLookupData)this.data).keyTypes != null) {
            for (i = 0; i < ((StreamLookupData)this.data).lookupMeta.size(); ++i) {
                IValueMeta inputValue = ((StreamLookupData)this.data).lookupMeta.getValueMeta(i);
                IValueMeta lookupValue = ((StreamLookupData)this.data).keyTypes.getValueMeta(i);
                if (inputValue.getType() == lookupValue.getType()) continue;
                try {
                    lu[i] = lookupValue.convertDataCompatible(inputValue, lu[i]);
                    continue;
                }
                catch (HopValueException e) {
                    throw new HopTransformException("Error converting data while looking up value", (Throwable)e);
                }
            }
        }
        Object[] add = null;
        if (((StreamLookupData)this.data).hasLookupRows) {
            try {
                if (((StreamLookupMeta)this.meta).getKeystream().length <= 0) {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"StreamLookup.Log.GotRowWithoutKeys", (String[])new String[0]));
                }
                add = this.getFromCache(((StreamLookupData)this.data).cacheKeyMeta, lu);
            }
            catch (Exception e) {
                throw new HopTransformException((Throwable)e);
            }
        }
        if (add == null) {
            add = ((StreamLookupData)this.data).nullIf;
        }
        return RowDataUtil.addRowData((Object[])row, (int)rowMeta.size(), (Object[])add);
    }

    private void addToCache(IRowMeta keyMeta, Object[] keyData, IRowMeta valueMeta, Object[] valueData) throws HopValueException {
        if (((StreamLookupMeta)this.meta).isMemoryPreservationActive()) {
            if (((StreamLookupMeta)this.meta).isUsingSortedList()) {
                KeyValue keyValue = new KeyValue(keyData, valueData);
                int idx = Collections.binarySearch(((StreamLookupData)this.data).list, keyValue, ((StreamLookupData)this.data).comparator);
                if (idx < 0) {
                    int index = -idx - 1;
                    ((StreamLookupData)this.data).list.add(index, keyValue);
                } else {
                    ((StreamLookupData)this.data).list.set(idx, keyValue);
                }
            } else if (((StreamLookupMeta)this.meta).isUsingIntegerPair()) {
                if (!((StreamLookupData)this.data).metadataVerifiedIntegerPair) {
                    ((StreamLookupData)this.data).metadataVerifiedIntegerPair = true;
                    if (keyMeta.size() != 1 || valueMeta.size() != 1 || !keyMeta.getValueMeta(0).isInteger() || !valueMeta.getValueMeta(0).isInteger()) {
                        throw new HopValueException(BaseMessages.getString(PKG, (String)"StreamLookup.Exception.CanNotUseIntegerPairAlgorithm", (String[])new String[0]));
                    }
                }
                Long key = keyMeta.getInteger(keyData, 0);
                Long value = valueMeta.getInteger(valueData, 0);
                ((StreamLookupData)this.data).longIndex.put(key.longValue(), value);
            } else {
                if (((StreamLookupData)this.data).hashIndex == null) {
                    ((StreamLookupData)this.data).hashIndex = new ByteArrayHashIndex(keyMeta);
                }
                ((StreamLookupData)this.data).hashIndex.put(RowMeta.extractData((IRowMeta)keyMeta, (Object[])keyData), RowMeta.extractData((IRowMeta)valueMeta, (Object[])valueData));
            }
        } else {
            ((StreamLookupData)this.data).look.put(new RowMetaAndData(keyMeta, keyData), valueData);
        }
    }

    private Object[] getFromCache(IRowMeta keyMeta, Object[] keyData) throws HopValueException {
        if (((StreamLookupMeta)this.meta).isMemoryPreservationActive()) {
            if (((StreamLookupMeta)this.meta).isUsingSortedList()) {
                KeyValue keyValue = new KeyValue(keyData, null);
                int idx = Collections.binarySearch(((StreamLookupData)this.data).list, keyValue, ((StreamLookupData)this.data).comparator);
                if (idx < 0) {
                    return null;
                }
                keyValue = ((StreamLookupData)this.data).list.get(idx);
                return keyValue.getValue();
            }
            if (((StreamLookupMeta)this.meta).isUsingIntegerPair()) {
                Long value = ((StreamLookupData)this.data).longIndex.get(keyMeta.getInteger(keyData, 0).longValue());
                if (value == null) {
                    return null;
                }
                return new Object[]{value};
            }
            try {
                byte[] value = ((StreamLookupData)this.data).hashIndex.get(RowMeta.extractData((IRowMeta)keyMeta, (Object[])keyData));
                if (value == null) {
                    return null;
                }
                return RowMeta.getRow((IRowMeta)((StreamLookupData)this.data).cacheValueMeta, (byte[])value);
            }
            catch (Exception e) {
                this.logError("Oops", e);
                throw new RuntimeException(e);
            }
        }
        return ((StreamLookupData)this.data).look.get(new RowMetaAndData(keyMeta, keyData));
    }

    public boolean processRow() throws HopException {
        Object[] outputRow;
        if (((StreamLookupData)this.data).readLookupValues) {
            ((StreamLookupData)this.data).readLookupValues = false;
            if (!this.readLookupValues()) {
                this.logError(BaseMessages.getString(PKG, (String)"StreamLookup.Log.UnableToReadDataFromLookupStream", (String[])new String[0]));
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            ((StreamLookupData)this.data).valueDefault = new String[((StreamLookupMeta)this.meta).getValueDefault().length];
            for (int i = 0; i < ((StreamLookupData)this.data).valueDefault.length; ++i) {
                ((StreamLookupData)this.data).valueDefault[i] = this.resolve(((StreamLookupMeta)this.meta).getValueDefault()[i]);
            }
            return true;
        }
        Object[] r = this.getRow();
        if (r == null) {
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"StreamLookup.Log.StoppedProcessingWithEmpty", (String[])new String[]{"" + this.getLinesRead()}));
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((StreamLookupData)this.data).keynrs = new int[((StreamLookupMeta)this.meta).getKeystream().length];
            ((StreamLookupData)this.data).lookupMeta = new RowMeta();
            ((StreamLookupData)this.data).convertKeysToNative = new boolean[((StreamLookupMeta)this.meta).getKeystream().length];
            for (int i = 0; i < ((StreamLookupMeta)this.meta).getKeystream().length; ++i) {
                ((StreamLookupData)this.data).keynrs[i] = this.getInputRowMeta().indexOfValue(((StreamLookupMeta)this.meta).getKeystream()[i]);
                if (((StreamLookupData)this.data).keynrs[i] < 0) {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"StreamLookup.Log.FieldNotFound", (String[])new String[]{((StreamLookupMeta)this.meta).getKeystream()[i], this.getInputRowMeta().getString(r)}));
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"StreamLookup.Log.FieldInfo", (String[])new String[]{((StreamLookupMeta)this.meta).getKeystream()[i], "" + ((StreamLookupData)this.data).keynrs[i]}));
                }
                ((StreamLookupData)this.data).lookupMeta.addValueMeta(this.getInputRowMeta().getValueMeta(((StreamLookupData)this.data).keynrs[i]).clone());
                ((StreamLookupData)this.data).convertKeysToNative[i] = this.getInputRowMeta().getValueMeta(((StreamLookupData)this.data).keynrs[i]).isStorageBinaryString();
            }
            ((StreamLookupData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((StreamLookupMeta)this.meta).getFields(((StreamLookupData)this.data).outputRowMeta, this.getTransformName(), new IRowMeta[]{((StreamLookupData)this.data).infoMeta}, null, (IVariables)this, this.metadataProvider);
            this.handleNullIf();
        }
        if ((outputRow = this.lookupValues(this.getInputRowMeta(), r)) == null) {
            this.setOutputDone();
            return false;
        }
        this.putRow(((StreamLookupData)this.data).outputRowMeta, outputRow);
        if (this.checkFeedback(this.getLinesRead()) && this.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"StreamLookup.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            ((StreamLookupData)this.data).readLookupValues = true;
            return true;
        }
        return false;
    }

    public void dispose() {
        ((StreamLookupData)this.data).look = null;
        ((StreamLookupData)this.data).list = null;
        ((StreamLookupData)this.data).hashIndex = null;
        ((StreamLookupData)this.data).longIndex = null;
        super.dispose();
    }
}

