/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.HopServerObjectEntry;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.WebResult;
import org.apache.hop.www.WorkflowMap;
import org.owasp.encoder.Encode;

@HopServerServlet(id="removeWorkflow", name="Remove a workflow from the server")
public class RemoveWorkflowServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    private static final Class<?> PKG = RemoveWorkflowServlet.class;
    private static final long serialVersionUID = -2051906998698124039L;
    public static final String CONTEXT_PATH = "/hop/removeWorkflow";

    public RemoveWorkflowServlet() {
    }

    public RemoveWorkflowServlet(WorkflowMap workflowMap) {
        super(workflowMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        IWorkflowEngine<WorkflowMeta> workflow;
        HopServerObjectEntry entry;
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"RemoveWorkflowServlet.Log.RemoveWorkflowRequested", (String[])new String[0]));
        }
        String workflowName = request.getParameter("name");
        String id = request.getParameter("id");
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        response.setStatus(200);
        if (useXML) {
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
        } else {
            response.setContentType("text/html;charset=UTF-8");
        }
        PrintWriter out = response.getWriter();
        if (Utils.isEmpty((CharSequence)id)) {
            entry = this.getWorkflowMap().getFirstHopServerObjectEntry(workflowName);
            if (entry == null) {
                workflow = null;
            } else {
                id = entry.getId();
                workflow = this.getWorkflowMap().getWorkflow(entry);
            }
        } else {
            entry = new HopServerObjectEntry(workflowName, id);
            workflow = this.getWorkflowMap().getWorkflow(entry);
        }
        if (workflow != null) {
            HopLogStore.discardLines((String)workflow.getLogChannelId(), (boolean)true);
            this.getWorkflowMap().removeWorkflow(entry);
            if (useXML) {
                response.setContentType("text/xml");
                response.setCharacterEncoding("UTF-8");
                out.print(XmlHandler.getXmlHeader((String)"UTF-8"));
                out.print(WebResult.OK.getXml());
            } else {
                response.setContentType("text/html;charset=UTF-8");
                out.println("<HTML>");
                out.println("<HEAD>");
                out.println("<TITLE>" + BaseMessages.getString(PKG, (String)"RemoveWorkflowServlet.WorkflowRemoved", (String[])new String[0]) + "</TITLE>");
                out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
                out.println("<link rel=\"icon\" type=\"image/svg+xml\" href=\"/static/images/favicon.svg\">");
                out.println("</HEAD>");
                out.println("<BODY>");
                out.println("<H3>" + Encode.forHtml((String)BaseMessages.getString(PKG, (String)"RemoveWorkflowServlet.TheWorkflowWasRemoved", (String[])new String[]{workflowName, id})) + "</H3>");
                out.print("<a href=\"" + this.convertContextPath("/hop/status") + "\">" + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><br>");
                out.println("<p>");
                out.println("</BODY>");
                out.println("</HTML>");
            }
        } else if (useXML) {
            out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"RemoveWorkflowServlet.Log.CoundNotFindSpecWorkflow", (String[])new String[]{workflowName})));
        } else {
            out.println("<H1>" + Encode.forHtml((String)BaseMessages.getString(PKG, (String)"RemoveWorkflowServlet.WorkflowRemoved.Log.CoundNotFindWorkflow", (String[])new String[]{workflowName, id})) + "</H1>");
            out.println("<a href=\"" + this.convertContextPath("/hop/status") + "\">" + BaseMessages.getString(PKG, (String)"PipelineStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
            response.setStatus(400);
        }
    }

    public String toString() {
        return "Remove workflow servlet";
    }

    @Override
    public String getService() {
        return "/hop/removeWorkflow (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

